/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idsvcs.rest;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.idsvcs.Attribute;
import com.sun.identity.idsvcs.GeneralFailure;
import com.sun.identity.idsvcs.IdentityDetails;
import com.sun.identity.idsvcs.IdentityServicesFactory;
import com.sun.identity.idsvcs.IdentityServicesImpl;
import com.sun.identity.idsvcs.ObjectNotFound;
import com.sun.identity.idsvcs.Token;
import com.sun.identity.idsvcs.UserDetails;
import com.sun.identity.idsvcs.rest.MarshallerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IdentityServicesHandler
extends HttpServlet {
    private static final long serialVersionUID = 2774677132209419157L;
    private static final String PARAM_PROVIDER = "provider";
    private static final Class PROVIDER_DEFAULT = IdentityServicesImpl.class;
    private IdentityServicesFactory factory;

    public void init() throws ServletException {
        super.init();
        try {
            String def = PROVIDER_DEFAULT.toString();
            String provider = this.getInitParameter(PARAM_PROVIDER, def);
            this.factory = IdentityServicesFactory.getInstance(provider);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IdentityServicesImpl security = this.factory.newInstance();
        SecurityMethod.execute(security, request, response);
    }

    String getInitParameter(String param, String def) {
        String ret = this.getInitParameter(param);
        if (IdentityServicesHandler.isBlank(param)) {
            ret = def;
        }
        return ret;
    }

    private static boolean isBlank(String val) {
        return val == null ? true : val.trim().length() == 0;
    }

    public static class SecurityMethod {
        public static final SecurityMethod AUTHENTICATE = new SecurityMethod("AUTHENTICATE", Token.class, SecurityParameter.USERNAME, SecurityParameter.PASSWORD, SecurityParameter.URI);
        public static final SecurityMethod ISTOKENVALID = new SecurityMethod("ISTOKENVALID", Boolean.class, SecurityParameter.TOKENID);
        public static final SecurityMethod TOKENCOOKIE = new SecurityMethod("GETCOOKIENAMEFORTOKEN", String.class, (SecurityParameter[])null);
        public static final SecurityMethod ALLCOOKIES = new SecurityMethod("GETCOOKIENAMESTOFORWARD", String[].class, (SecurityParameter[])null);
        public static final SecurityMethod LOGOUT = new SecurityMethod("LOGOUT", Void.class, SecurityParameter.SUBJECTID);
        public static final SecurityMethod AUTHORIZE = new SecurityMethod("AUTHORIZE", Boolean.class, SecurityParameter.URI, SecurityParameter.ACTION, SecurityParameter.SUBJECTID);
        public static final SecurityMethod ATTRIBUTES = new SecurityMethod("ATTRIBUTES", UserDetails.class, SecurityParameter.ATTRIBUTENAMES, SecurityParameter.SUBJECTID);
        public static final SecurityMethod LOG = new SecurityMethod("LOG", Void.class, new SecurityParameter[]{SecurityParameter.APPID, SecurityParameter.SUBJECTID, SecurityParameter.LOGNAME, SecurityParameter.MESSAGE});
        public static final SecurityMethod SEARCH = new SecurityMethod("SEARCH", String[].class, new SecurityParameter[]{SecurityParameter.FILTER, SecurityParameter.ATTRIBUTES, SecurityParameter.ADMIN});
        public static final SecurityMethod CREATE = new SecurityMethod("CREATE", Void.class, new SecurityParameter[]{SecurityParameter.IDENTITY, SecurityParameter.ADMIN});
        public static final SecurityMethod READ = new SecurityMethod("READ", IdentityDetails.class, new SecurityParameter[]{SecurityParameter.NAME, SecurityParameter.ATTRIBUTES, SecurityParameter.ADMIN});
        public static final SecurityMethod UPDATE = new SecurityMethod("UPDATE", Void.class, new SecurityParameter[]{SecurityParameter.IDENTITY, SecurityParameter.ADMIN});
        public static final SecurityMethod DELETE = new SecurityMethod("DELETE", Void.class, new SecurityParameter[]{SecurityParameter.IDENTITY, SecurityParameter.ADMIN});
        final Class type;
        final Method method;
        final SecurityParameter[] parameters;

        private SecurityMethod(String name, Class clazz, SecurityParameter[] params) {
            Method[] SECURITY_METHODS = IdentityServicesImpl.class.getMethods();
            Method imethod = null;
            String lname = name.toLowerCase();
            for (int i = 0; i < SECURITY_METHODS.length; ++i) {
                Method m = SECURITY_METHODS[i];
                String mname = m.getName().toLowerCase();
                if (!mname.equals(lname)) continue;
                imethod = m;
                break;
            }
            if (imethod == null) {
                throw new IllegalArgumentException();
            }
            this.type = clazz;
            this.method = imethod;
            this.parameters = params;
        }

        private SecurityMethod(String name, Class clazz, SecurityParameter param1) {
            this(name, clazz, new SecurityParameter[]{param1});
        }

        private SecurityMethod(String name, Class clazz, SecurityParameter param1, SecurityParameter param2) {
            this(name, clazz, new SecurityParameter[]{param1, param2});
        }

        private SecurityMethod(String name, Class clazz, SecurityParameter param1, SecurityParameter param2, SecurityParameter param3) {
            this(name, clazz, new SecurityParameter[]{param1, param2, param3});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void execute(IdentityServicesImpl security, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter wrt = response.getWriter();
            StringWriter sw = null;
            String path = request.getPathInfo();
            MarshallerFactory mar = SecurityMethod.getMarshaller(path);
            if (mar.getProtocol().equalsIgnoreCase("XML")) {
                response.setHeader("content-type", "text/xml");
            } else {
                response.setHeader("content-type", "text/plain");
            }
            path = path.substring(path.lastIndexOf(47) + 1).toUpperCase();
            SecurityMethod method = null;
            if (path.equals("AUTHENTICATE")) {
                method = AUTHENTICATE;
            } else if (path.equals("LOGOUT")) {
                method = LOGOUT;
            } else if (path.equals("AUTHORIZE")) {
                method = AUTHORIZE;
            } else if (path.equals("ATTRIBUTES")) {
                method = ATTRIBUTES;
            } else if (path.equals("LOG")) {
                method = LOG;
            } else if (path.equals("SEARCH")) {
                method = SEARCH;
            } else if (path.equals("CREATE")) {
                method = CREATE;
            } else if (path.equals("READ")) {
                method = READ;
            } else if (path.equals("UPDATE")) {
                method = UPDATE;
            } else if (path.equals("DELETE")) {
                method = DELETE;
            } else if (path.equals("ISTOKENVALID")) {
                method = ISTOKENVALID;
            } else if (path.equals("GETCOOKIENAMEFORTOKEN")) {
                method = TOKENCOOKIE;
            } else if (path.equals("GETCOOKIENAMESTOFORWARD")) {
                method = ALLCOOKIES;
            }
            try {
                if (method == null) {
                    response.sendError(501);
                    mar.newInstance(Throwable.class).marshall(wrt, new UnsupportedOperationException(path));
                    return;
                }
                Object value = method.invoke(security, (ServletRequest)request);
                if (method.type != Void.class && value != null) {
                    mar.newInstance(method.type).marshall(wrt, value);
                } else {
                    response.setHeader("content-type", "text/plain");
                    if (value == null) {
                        ((Writer)wrt).write("NULL");
                    }
                }
            }
            catch (ObjectNotFound ex) {
                try {
                    sw = new StringWriter(100);
                    mar.newInstance(ObjectNotFound.class).marshall(sw, ex);
                    response.sendError(401, sw.toString());
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (GeneralFailure ex) {
                try {
                    sw = new StringWriter(100);
                    mar.newInstance(GeneralFailure.class).marshall(sw, ex);
                    response.sendError(500, sw.toString());
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (Throwable e) {
                try {
                    sw = new StringWriter(100);
                    mar.newInstance(Throwable.class).marshall(sw, e);
                    if (e instanceof UnsupportedOperationException) {
                        response.sendError(501, sw.toString());
                    } else {
                        response.sendError(401, sw.toString());
                    }
                }
                catch (Exception ex) {
                    throw new ServletException((Throwable)ex);
                }
            }
            finally {
                if (sw != null) {
                    sw.close();
                }
            }
        }

        private static MarshallerFactory getMarshaller(String path) {
            boolean xml = path.indexOf("xml/") != -1;
            boolean json = path.indexOf("json/") != -1;
            return xml ? MarshallerFactory.XML : MarshallerFactory.PROPS;
        }

        private Object invoke(IdentityServicesImpl security, ServletRequest request) throws Throwable {
            Object ret;
            block10: {
                Object[] params = null;
                if (this.parameters != null) {
                    params = new Object[this.parameters.length];
                    for (int i = 0; i < this.parameters.length; ++i) {
                        SecurityParameter param = this.parameters[i];
                        params[i] = param.getValue(request);
                    }
                }
                ret = null;
                try {
                    if (this.method == SecurityMethod.AUTHENTICATE.method && params != null && params.length > 1 && params[0] == null && params[1] == null) {
                        try {
                            SSOTokenManager mgr = SSOTokenManager.getInstance();
                            SSOToken token = mgr.createSSOToken((HttpServletRequest)request);
                            if (mgr.isValidToken(token)) {
                                Token t = new Token();
                                t.setId(((Object)token.getTokenID()).toString());
                                ret = t;
                            }
                            break block10;
                        }
                        catch (SSOException ssoe) {
                            ret = this.method.invoke((Object)security, params);
                        }
                        break block10;
                    }
                    ret = this.method.invoke((Object)security, params);
                }
                catch (IllegalArgumentException e) {
                    throw new GeneralFailure(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new GeneralFailure(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return ret;
        }
    }

    public static class SecurityParameter {
        public static final SecurityParameter URI = new SecurityParameter("URI");
        public static final SecurityParameter ACTION = new SecurityParameter("ACTION");
        public static final SecurityParameter USERNAME = new SecurityParameter("USERNAME");
        public static final SecurityParameter PASSWORD = new SecurityParameter("PASSWORD");
        public static final SecurityParameter TOKENID = new SecurityParameter("TOKENID", Token.class);
        public static final SecurityParameter SUBJECTID = new SecurityParameter("SUBJECTID", Token.class);
        public static final SecurityParameter IDENTITY = new SecurityParameter("IDENTITY", IdentityDetails.class);
        public static final SecurityParameter ATTRIBUTENAMES = new SecurityParameter("ATTRIBUTENAMES", new String[1].getClass());
        public static final SecurityParameter LOGNAME = new SecurityParameter("LOGNAME");
        public static final SecurityParameter MESSAGE = new SecurityParameter("MESSAGE");
        public static final SecurityParameter MESSAGECODE = new SecurityParameter("MESSAGECODE");
        public static final SecurityParameter APPID = new SecurityParameter("APPID", Token.class);
        public static final SecurityParameter ADMIN = new SecurityParameter("ADMIN", Token.class);
        public static final SecurityParameter NAME = new SecurityParameter("NAME");
        public static final SecurityParameter FILTER = new SecurityParameter("FILTER");
        public static final SecurityParameter ATTRIBUTES = new SecurityParameter("ATTRIBUTES", Attribute[].class);
        final Class type;
        final String name;

        SecurityParameter(String name) {
            this.name = name;
            this.type = String.class;
        }

        SecurityParameter(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        String name() {
            return this.name;
        }

        Object getValue(ServletRequest request) {
            Object ret = null;
            ret = this.type == Token.class ? this.getToken(request) : (this.type == List.class ? this.getList(request) : (this.type == String[].class ? this.getArray(request) : (this.type == Attribute[].class ? this.getAttributeArray(request) : (this.type == IdentityDetails.class ? this.getIdentityDetails(request) : this.getString(request)))));
            return ret;
        }

        public String getString(ServletRequest request) {
            String name = this.name().toLowerCase();
            String ret = request.getParameter(name);
            if (IdentityServicesHandler.isBlank(ret)) {
                ret = null;
            }
            return ret;
        }

        public Token getToken(ServletRequest request) {
            Token ret = null;
            String n = this.name().toLowerCase();
            String id = request.getParameter(n);
            if (IdentityServicesHandler.isBlank(id)) {
                try {
                    SSOTokenManager mgr = SSOTokenManager.getInstance();
                    SSOToken token = mgr.createSSOToken((HttpServletRequest)request);
                    if (token != null) {
                        id = ((Object)token.getTokenID()).toString();
                    }
                }
                catch (SSOException ex) {
                    // empty catch block
                }
            }
            if (!IdentityServicesHandler.isBlank(id)) {
                ret = new Token();
                ret.setId(id);
            }
            return ret;
        }

        public List getList(ServletRequest request) {
            ArrayList<String> ret = null;
            String n = this.name().toLowerCase();
            String[] values = request.getParameterValues(n);
            if (values != null) {
                ret = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    String value = values[i];
                    if (IdentityServicesHandler.isBlank(value)) continue;
                    ret.add(value);
                }
            }
            return ret;
        }

        public String[] getArray(ServletRequest request) {
            String[] ret = null;
            List valuesList = this.getList(request);
            if (valuesList != null && valuesList.size() > 0) {
                ret = new String[valuesList.size()];
                valuesList.toArray(ret);
            }
            return ret;
        }

        public Attribute[] getAttributeArray(ServletRequest request) {
            Attribute[] ret = null;
            ArrayList<Attribute> attributeList = null;
            String n = this.name().toLowerCase();
            String[] attrNames = request.getParameterValues(n + "_names");
            if (attrNames != null) {
                String attrName;
                for (int i = 0; i < attrNames.length && !IdentityServicesHandler.isBlank(attrName = attrNames[i]); ++i) {
                    String[] attrValues = request.getParameterValues(n + "_values_" + attrName);
                    if (attrValues != null && attrValues.length > 0) {
                        ArrayList<String> attrValueList = new ArrayList<String>();
                        for (int j = 0; j < attrValues.length; ++j) {
                            String attrValue = attrValues[j];
                            if (IdentityServicesHandler.isBlank(attrValue)) continue;
                            attrValueList.add(attrValue);
                        }
                        String[] attrValuesArray = new String[attrValueList.size()];
                        attrValueList.toArray(attrValuesArray);
                        Attribute attribute = new Attribute();
                        attribute.setName(attrName);
                        attribute.setValues(attrValuesArray);
                        if (attributeList == null) {
                            attributeList = new ArrayList();
                        }
                        attributeList.add(attribute);
                        continue;
                    }
                    Attribute attribute = new Attribute();
                    attribute.setName(attrName);
                    if (attributeList == null) {
                        attributeList = new ArrayList<Attribute>();
                    }
                    attributeList.add(attribute);
                }
            }
            if (attributeList != null && attributeList.size() > 0) {
                ret = new Attribute[attributeList.size()];
                attributeList.toArray(ret);
            }
            return ret;
        }

        public IdentityDetails getIdentityDetails(ServletRequest request) {
            IdentityDetails rv = null;
            String n = this.name().toLowerCase();
            String identityName = request.getParameter(n + "_name");
            if (!IdentityServicesHandler.isBlank(identityName)) {
                String[] members;
                String[] groups;
                String[] roles;
                String realm;
                rv = new IdentityDetails();
                rv.setName(identityName);
                String objType = request.getParameter(n + "_type");
                if (!IdentityServicesHandler.isBlank(objType)) {
                    rv.setType(objType);
                }
                if (!IdentityServicesHandler.isBlank(realm = request.getParameter(n + "_realm"))) {
                    rv.setRealm(realm);
                }
                if ((roles = request.getParameterValues(n + "_roles")) != null) {
                    ArrayList<String> rolesList = new ArrayList<String>();
                    for (int i = 0; i < roles.length; ++i) {
                        String role = roles[i];
                        if (IdentityServicesHandler.isBlank(role)) continue;
                        rolesList.add(role);
                    }
                    String[] rolesArray = new String[rolesList.size()];
                    rolesList.toArray(rolesArray);
                    rv.setRoles(rolesArray);
                }
                if ((groups = request.getParameterValues(n + "_groups")) != null) {
                    ArrayList<String> groupsList = new ArrayList<String>();
                    for (int i = 0; i < groups.length; ++i) {
                        String group = groups[i];
                        if (IdentityServicesHandler.isBlank(group)) continue;
                        groupsList.add(group);
                    }
                    String[] groupsArray = new String[groupsList.size()];
                    groupsList.toArray(groupsArray);
                    rv.setGroups(groupsArray);
                }
                if ((members = request.getParameterValues(n + "_members")) != null) {
                    ArrayList<String> membersList = new ArrayList<String>();
                    for (int i = 0; i < members.length; ++i) {
                        String member = members[i];
                        if (IdentityServicesHandler.isBlank(member)) continue;
                        membersList.add(member);
                    }
                    String[] membersArray = new String[membersList.size()];
                    membersList.toArray(membersArray);
                    rv.setMembers(membersArray);
                }
                ArrayList<Attribute> attrList = new ArrayList<Attribute>();
                String[] attrNames = request.getParameterValues(n + "_attribute_names");
                if (attrNames != null) {
                    String attrName;
                    for (int i = 0; i < attrNames.length && !IdentityServicesHandler.isBlank(attrName = attrNames[i]); ++i) {
                        Attribute attribute = null;
                        String[] attrValues = request.getParameterValues(n + "_attribute_values_" + attrName);
                        if (attrValues != null) {
                            ArrayList<String> attrValueList = new ArrayList<String>();
                            for (int j = 0; j < attrValues.length; ++j) {
                                String attrValue = attrValues[j];
                                if (IdentityServicesHandler.isBlank(attrValue)) continue;
                                attrValueList.add(attrValue);
                            }
                            String[] attrValuesArray = new String[attrValueList.size()];
                            attrValueList.toArray(attrValuesArray);
                            attribute = new Attribute();
                            attribute.setName(attrName);
                            attribute.setValues(attrValuesArray);
                            attrList.add(attribute);
                        } else {
                            attribute = new Attribute();
                            attribute.setName(attrName);
                            attrList.add(attribute);
                        }
                        if (attrList.size() <= 0) continue;
                        Attribute[] attrArray = new Attribute[attrList.size()];
                        attrList.toArray(attrArray);
                        rv.setAttributes(attrArray);
                    }
                }
            }
            return rv;
        }
    }
}

