/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idsvcs.opensso;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idsvcs.AccessDenied;
import com.sun.identity.idsvcs.Attribute;
import com.sun.identity.idsvcs.CreateResponse;
import com.sun.identity.idsvcs.DeleteResponse;
import com.sun.identity.idsvcs.DuplicateObject;
import com.sun.identity.idsvcs.GeneralFailure;
import com.sun.identity.idsvcs.IdentityDetails;
import com.sun.identity.idsvcs.InvalidCredentials;
import com.sun.identity.idsvcs.InvalidPassword;
import com.sun.identity.idsvcs.InvalidToken;
import com.sun.identity.idsvcs.LogResponse;
import com.sun.identity.idsvcs.LogoutResponse;
import com.sun.identity.idsvcs.NeedMoreCredentials;
import com.sun.identity.idsvcs.ObjectNotFound;
import com.sun.identity.idsvcs.Token;
import com.sun.identity.idsvcs.TokenExpired;
import com.sun.identity.idsvcs.UpdateResponse;
import com.sun.identity.idsvcs.UserDetails;
import com.sun.identity.idsvcs.UserNotFound;
import com.sun.identity.log.AMLogException;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import netscape.ldap.util.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityServicesImpl
implements com.sun.identity.idsvcs.IdentityServicesImpl {
    private static Debug debug = Debug.getInstance((String)"amIdentityServices");

    @Override
    public Token authenticate(String username, String password, String uri) throws UserNotFound, InvalidPassword, NeedMoreCredentials, InvalidCredentials, GeneralFailure, RemoteException {
        Token ret;
        block15: {
            assert (username != null && password != null);
            ret = null;
            try {
                String realm = "/";
                Object module = null;
                Object level = null;
                if (uri != null) {
                    // empty if block
                }
                AuthContext lc = new AuthContext(realm);
                lc.login();
                while (lc.hasMoreRequirements()) {
                    Callback[] callbacks = lc.getRequirements();
                    ArrayList<Callback> missing = new ArrayList<Callback>();
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            NameCallback nc = (NameCallback)callbacks[i];
                            nc.setName(username);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pc = (PasswordCallback)callbacks[i];
                            pc.setPassword(password.toCharArray());
                            continue;
                        }
                        missing.add(callbacks[i]);
                    }
                    if (missing.size() > 0) {
                        throw new InvalidCredentials("");
                    }
                    lc.submitRequirements(callbacks);
                }
                if (lc.getStatus() != AuthContext.Status.SUCCESS) {
                    String ec = lc.getErrorCode();
                    String em = lc.getErrorMessage();
                    if (ec.equals("103")) {
                        throw new InvalidPassword(em);
                    }
                    if (ec.equals("100") || ec.equals("101") || ec.equals("104") || ec.equals("113") || ec.equals("109")) {
                        throw new UserNotFound(em);
                    }
                    if (ec.equals("107")) {
                        throw new InvalidCredentials(em);
                    }
                    break block15;
                }
                try {
                    ret = new Token();
                    String id = ((Object)lc.getSSOToken().getTokenID()).toString();
                    ret.setId(id);
                }
                catch (Exception e) {
                    debug.error("IdentityServicesImpl:authContext: Unable to get SSOToken", (Throwable)e);
                    throw new GeneralFailure(e.getMessage());
                }
            }
            catch (AuthLoginException le) {
                debug.error("IdentityServicesImpl:authContext AuthException", (Throwable)le);
                throw new GeneralFailure(le.getMessage());
            }
        }
        return ret;
    }

    @Override
    public LogoutResponse logout(Token subject) throws GeneralFailure, RemoteException {
        try {
            SSOToken ssoToken = this.getSSOToken(subject);
            if (ssoToken != null) {
                SSOTokenManager mgr = SSOTokenManager.getInstance();
                mgr.destroyToken(ssoToken);
            }
        }
        catch (TokenExpired te) {
            debug.error("IdentityServicesImpl:logout", (Throwable)te);
            throw new GeneralFailure(te.getMessage());
        }
        catch (SSOException ex) {
            debug.error("IdentityServicesImpl:logout", (Throwable)((Object)ex));
            throw new GeneralFailure(ex.getMessage());
        }
        return new LogoutResponse();
    }

    @Override
    public boolean authorize(String uri, String action, Token subject) throws NeedMoreCredentials, TokenExpired, GeneralFailure, RemoteException {
        boolean isAllowed = false;
        try {
            SSOToken ssoToken = this.getSSOToken(subject);
            String serviceName = "iPlanetAMWebAgentService";
            String resource = uri;
            if (uri.toLowerCase().startsWith("service://")) {
                URI iuri = new URI(uri);
                serviceName = iuri.getHost();
                resource = iuri.getQuery();
                int index = resource.indexOf(61);
                if (index > 0) {
                    resource = resource.substring(index);
                }
            }
            PolicyEvaluator pe = new PolicyEvaluator(serviceName);
            if (action == null || action.length() == 0) {
                action = "GET";
            }
            if (pe.isAllowed(ssoToken, resource, action)) {
                isAllowed = true;
            }
        }
        catch (SSOException e) {
            debug.error("IdentityServicesImpl:authorize", (Throwable)((Object)e));
            throw new TokenExpired(e.getMessage());
        }
        catch (PolicyException ex) {
            debug.error("IdentityServicesImpl:authorize", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        catch (URISyntaxException ex) {
            debug.error("IdentityServicesImpl:authorize", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        return isAllowed;
    }

    @Override
    public LogResponse log(Token app, Token subject, String logName, String message) throws AccessDenied, TokenExpired, GeneralFailure, RemoteException {
        if (app == null) {
            throw new AccessDenied("No logging application token specified");
        }
        SSOToken appToken = null;
        SSOToken subjectToken = null;
        appToken = this.getSSOToken(app);
        subjectToken = subject == null ? appToken : this.getSSOToken(subject);
        try {
            LogRecord logRecord = new LogRecord(Level.INFO, message, subjectToken);
            Logger logger = (Logger)Logger.getLogger(logName);
            logger.log(logRecord, appToken);
            logger.flush();
        }
        catch (AMLogException e) {
            debug.error("IdentityServicesImpl:authorize", (Throwable)e);
            throw new GeneralFailure(e.getMessage());
        }
        return new LogResponse();
    }

    @Override
    public UserDetails attributes(String[] attributeNames, Token subject) throws TokenExpired, GeneralFailure, RemoteException {
        ArrayList<String> attrNames = null;
        if (attributeNames != null && attributeNames.length > 0) {
            attrNames = new ArrayList<String>();
            for (int i = 0; i < attributeNames.length; ++i) {
                attrNames.add(attributeNames[i]);
            }
        }
        return this.attributes(attrNames, subject);
    }

    public UserDetails attributes(List attributeNames, Token subject) throws TokenExpired, GeneralFailure, RemoteException {
        UserDetails details = new UserDetails();
        try {
            SSOToken ssoToken = this.getSSOToken(subject);
            AMIdentity userIdentity = IdUtils.getIdentity(ssoToken);
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentityRepository idrepo = new AMIdentityRepository(adminToken, userIdentity.getRealm());
            Set supportedTypes = idrepo.getSupportedIdTypes();
            HashSet<IdType> membersTypes = new HashSet<IdType>();
            for (IdType type : supportedTypes) {
                if (!type.canHaveMembers().contains(userIdentity.getType())) continue;
                membersTypes.add(type);
            }
            ArrayList<String> roles = new ArrayList<String>();
            for (IdType type : membersTypes) {
                Set mems = userIdentity.getMemberships(type);
                for (AMIdentity mem : mems) {
                    roles.add(mem.getUniversalId());
                }
            }
            String[] r = new String[roles.size()];
            details.setRoles(roles.toArray(r));
            Map userAttributes = null;
            if (attributeNames != null) {
                HashSet attrNames = new HashSet(attributeNames);
                userAttributes = userIdentity.getAttributes(attrNames);
            } else {
                userAttributes = userIdentity.getAttributes();
            }
            if (userAttributes != null) {
                ArrayList<Attribute> attributes = new ArrayList<Attribute>(userAttributes.size());
                Iterator it = userAttributes.keySet().iterator();
                while (it.hasNext()) {
                    Attribute attribute = new Attribute();
                    String name = it.next().toString();
                    attribute.setName(name);
                    Set value = (Set)userAttributes.get(name);
                    ArrayList<String> valueList = new ArrayList<String>(value.size());
                    if (value != null) {
                        for (Object next : value) {
                            if (next == null) continue;
                            valueList.add(next.toString());
                        }
                    }
                    String[] v = new String[valueList.size()];
                    attribute.setValues(valueList.toArray(v));
                    attributes.add(attribute);
                }
                Attribute[] a = new Attribute[attributes.size()];
                details.setAttributes(attributes.toArray(a));
            }
        }
        catch (IdRepoException e) {
            debug.error("IdentityServicesImpl:authorize", (Throwable)e);
            throw new GeneralFailure(e.getMessage());
        }
        catch (SSOException e) {
            debug.error("IdentityServicesImpl:authorize", (Throwable)((Object)e));
            throw new GeneralFailure(e.getMessage());
        }
        details.setToken(subject);
        return details;
    }

    @Override
    public String[] search(String filter, Attribute[] attributes, Token admin) throws TokenExpired, GeneralFailure, RemoteException {
        List identities;
        String[] rv = null;
        ArrayList<Attribute> searchAttrsList = null;
        if (attributes != null && attributes.length > 0) {
            searchAttrsList = new ArrayList<Attribute>();
            for (int i = 0; i < attributes.length; ++i) {
                searchAttrsList.add(attributes[i]);
            }
        }
        if ((identities = this.search(filter, searchAttrsList, admin)) != null && identities.size() > 0) {
            rv = new String[identities.size()];
            identities.toArray(rv);
        }
        return rv;
    }

    public List search(String filter, List attributes, Token admin) throws TokenExpired, GeneralFailure, RemoteException {
        ArrayList<String> rv = null;
        try {
            String realm = null;
            String objectType = null;
            Map<String, Set> searchModifiers = this.attributesToMap(attributes);
            if (searchModifiers != null) {
                Set set = searchModifiers.get("realm");
                if (set != null && !set.isEmpty()) {
                    realm = set.iterator().next().toString();
                    searchModifiers.remove("realm");
                }
                if ((set = searchModifiers.get("objecttype")) != null && !set.isEmpty()) {
                    objectType = set.iterator().next().toString();
                    searchModifiers.remove("objecttype");
                }
            }
            if (realm == null || realm.length() < 1) {
                realm = "/";
            }
            if (objectType == null || objectType.length() < 1) {
                objectType = "User";
            }
            AMIdentityRepository repo = this.getRepo(admin, realm);
            IdType idType = this.getIdType(objectType);
            List objList = null;
            if (idType != null) {
                if (filter == null || filter.length() == 0) {
                    filter = "*";
                }
            } else {
                debug.error("IdentityServicesImpl:search unsupported IdType" + objectType);
                throw new GeneralFailure("search unsupported IdType: " + objectType);
            }
            objList = this.fetchAMIdentities(idType, filter, false, repo, searchModifiers);
            if (objList != null) {
                Iterator objIter = objList.iterator();
                rv = new ArrayList<String>();
                while (objIter.hasNext()) {
                    AMIdentity identity = (AMIdentity)objIter.next();
                    if (!this.identityExists(identity)) continue;
                    rv.add(identity.getName());
                }
            }
        }
        catch (IdRepoException e) {
            debug.error("IdentityServicesImpl:list", (Throwable)e);
            throw new GeneralFailure(e.getMessage());
        }
        catch (SSOException e) {
            debug.error("IdentityServicesImpl:list", (Throwable)((Object)e));
            throw new GeneralFailure(e.getMessage());
        }
        return rv;
    }

    @Override
    public CreateResponse create(IdentityDetails identity, Token admin) throws NeedMoreCredentials, DuplicateObject, TokenExpired, GeneralFailure {
        assert (identity != null);
        assert (admin != null);
        String idName = identity.getName();
        String idType = identity.getType();
        String realm = identity.getRealm();
        if (idName == null || idName.length() < 1) {
            throw new GeneralFailure("Identity name not provided");
        }
        if (idType == null || idType.length() < 1) {
            idType = "user";
        }
        if (realm == null) {
            realm = "/";
        }
        try {
            IdType objectIdType = this.getIdType(idType);
            AMIdentityRepository repo = this.getRepo(admin, realm);
            if (!this.isOperationSupported(repo, objectIdType, IdOperation.CREATE)) {
                throw new UnsupportedOperationException("Unsupported: Type: " + idType + " Operation: CREATE");
            }
            Map<String, Set> idAttrs = this.attributesToMap(identity.getAttributes());
            AMIdentity amIdentity = null;
            if (objectIdType.equals(IdType.AGENT) || objectIdType.equals(IdType.AGENTONLY) || objectIdType.equals(IdType.AGENTGROUP)) {
                String agentType = null;
                String serverUrl = null;
                String agentUrl = null;
                Set set = idAttrs.get("agenttype");
                if (set == null || set.isEmpty()) {
                    throw new UnsupportedOperationException("Unsupported: Agent Type required for " + idType);
                }
                agentType = set.iterator().next().toString();
                idAttrs.remove("agenttype");
                set = idAttrs.get("serverurl");
                if (set != null && !set.isEmpty()) {
                    serverUrl = set.iterator().next().toString();
                    idAttrs.remove("serverurl");
                }
                if ((set = idAttrs.get("agenturl")) != null && !set.isEmpty()) {
                    agentUrl = set.iterator().next().toString();
                    idAttrs.remove("agenturl");
                }
                if (objectIdType.equals(IdType.AGENT) || objectIdType.equals(IdType.AGENTONLY)) {
                    if (serverUrl == null || serverUrl.length() == 0 || agentUrl == null || agentUrl.length() == 0) {
                        AgentConfiguration.createAgent(this.getSSOToken(admin), realm, idName, agentType, idAttrs);
                    } else {
                        AgentConfiguration.createAgent(this.getSSOToken(admin), realm, idName, agentType, idAttrs, serverUrl, agentUrl);
                    }
                } else if (serverUrl == null || serverUrl.length() == 0 || agentUrl == null || agentUrl.length() == 0) {
                    AgentConfiguration.createAgentGroup(this.getSSOToken(admin), realm, idName, agentType, idAttrs);
                } else {
                    AgentConfiguration.createAgentGroup(this.getSSOToken(admin), realm, idName, agentType, idAttrs, serverUrl, agentUrl);
                }
            } else {
                String[] memberNames;
                amIdentity = repo.createIdentity(objectIdType, idName, idAttrs);
                if (objectIdType.equals(IdType.USER)) {
                    String[] groupNames;
                    String[] roleNames = identity.getRoles();
                    if (roleNames != null) {
                        if (!this.isOperationSupported(repo, IdType.ROLE, IdOperation.EDIT)) {
                            throw new NeedMoreCredentials("");
                        }
                        for (int i = 0; i < roleNames.length; ++i) {
                            AMIdentity role = this.fetchAMIdentity(repo, IdType.ROLE, roleNames[i], false);
                            if (!this.identityExists(role)) continue;
                            role.addMember(amIdentity);
                            role.store();
                        }
                    }
                    if ((groupNames = identity.getGroups()) != null) {
                        if (!this.isOperationSupported(repo, IdType.GROUP, IdOperation.EDIT)) {
                            throw new NeedMoreCredentials("");
                        }
                        for (int i = 0; i < groupNames.length; ++i) {
                            AMIdentity group = this.fetchAMIdentity(repo, IdType.GROUP, groupNames[i], false);
                            if (!this.identityExists(group)) continue;
                            group.addMember(amIdentity);
                            group.store();
                        }
                    }
                }
                if ((objectIdType.equals(IdType.GROUP) || objectIdType.equals(IdType.ROLE)) && (memberNames = identity.getMembers()) != null) {
                    if (objectIdType.equals(IdType.GROUP) && !this.isOperationSupported(repo, IdType.GROUP, IdOperation.EDIT)) {
                        throw new NeedMoreCredentials("");
                    }
                    if (objectIdType.equals(IdType.ROLE) && !this.isOperationSupported(repo, IdType.ROLE, IdOperation.EDIT)) {
                        throw new NeedMoreCredentials("");
                    }
                    for (int i = 0; i < memberNames.length; ++i) {
                        AMIdentity user = this.fetchAMIdentity(repo, IdType.USER, memberNames[i], false);
                        if (!this.identityExists(user)) continue;
                        amIdentity.addMember(user);
                    }
                    amIdentity.store();
                }
            }
        }
        catch (IdRepoException ex) {
            debug.error("IdentityServicesImpl:create", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        catch (SSOException ex) {
            debug.error("IdentityServicesImpl:create", (Throwable)((Object)ex));
            throw new GeneralFailure(ex.getMessage());
        }
        catch (SMSException ex) {
            debug.error("IdentityServicesImpl:create", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        catch (ConfigurationException ex) {
            debug.error("IdentityServicesImpl:create", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        catch (MalformedURLException ex) {
            debug.error("IdentityServicesImpl:create", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        return new CreateResponse();
    }

    @Override
    public IdentityDetails read(String name, Attribute[] attributes, Token admin) throws NeedMoreCredentials, ObjectNotFound, TokenExpired, GeneralFailure {
        ArrayList<Attribute> attrList = null;
        if (attributes != null && attributes.length > 0) {
            attrList = new ArrayList<Attribute>();
            for (int i = 0; i < attributes.length; ++i) {
                attrList.add(attributes[i]);
            }
        }
        return this.read(name, attrList, admin);
    }

    public IdentityDetails read(String name, List attributes, Token admin) throws NeedMoreCredentials, ObjectNotFound, TokenExpired, GeneralFailure {
        IdentityDetails rv = null;
        String realm = null;
        String repoRealm = null;
        String identityType = null;
        ArrayList<String> attrsToGet = null;
        if (attributes != null) {
            for (int i = 0; i < attributes.size(); ++i) {
                String[] values;
                Attribute attr = (Attribute)attributes.get(i);
                String attrName = attr.getName();
                if ("realm".equalsIgnoreCase(attrName)) {
                    values = attr.getValues();
                    if (values == null || values.length <= 0) continue;
                    realm = values[0];
                    continue;
                }
                if ("objecttype".equalsIgnoreCase(attrName)) {
                    values = attr.getValues();
                    if (values == null || values.length <= 0) continue;
                    identityType = values[0];
                    continue;
                }
                if (attrsToGet == null) {
                    attrsToGet = new ArrayList<String>();
                }
                attrsToGet.add(attrName);
            }
        }
        repoRealm = realm == null || realm.length() < 1 ? "/" : realm;
        if (identityType == null || identityType.length() < 1) {
            identityType = "User";
        }
        try {
            AMIdentity amIdentity = this.getAMIdentity(admin, identityType, name, repoRealm);
            if (!this.identityExists(amIdentity)) {
                debug.error("IdentityServicesImpl:read identity not found");
                throw new ObjectNotFound(name);
            }
            rv = this.convertToIdentityDetails(amIdentity, attrsToGet);
            if (realm != null && realm.length() > 0) {
                rv.setRealm(realm);
            }
        }
        catch (IdRepoException e) {
            debug.error("IdentityServicesImpl:list", (Throwable)e);
            throw new GeneralFailure(e.getMessage());
        }
        catch (SSOException e) {
            debug.error("IdentityServicesImpl:list", (Throwable)((Object)e));
            throw new GeneralFailure(e.getMessage());
        }
        return rv;
    }

    @Override
    public UpdateResponse update(IdentityDetails identity, Token admin) throws NeedMoreCredentials, ObjectNotFound, TokenExpired, GeneralFailure {
        String idName = identity.getName();
        String idType = identity.getType();
        String realm = identity.getRealm();
        if (idName == null || idName.length() < 1) {
            throw new GeneralFailure("");
        }
        if (idType == null || idType.length() < 1) {
            idType = "user";
        }
        if (realm == null) {
            realm = "";
        }
        try {
            String[] memberNames;
            int i;
            IdType objectIdType = this.getIdType(idType);
            AMIdentityRepository repo = this.getRepo(admin, realm);
            if (!this.isOperationSupported(repo, objectIdType, IdOperation.EDIT)) {
                throw new NeedMoreCredentials("");
            }
            AMIdentity amIdentity = this.getAMIdentity(this.getSSOToken(admin), repo, idType, idName);
            if (!this.identityExists(amIdentity)) {
                String msg = "Object '" + idName + "' of type '" + idType + "' not found.'";
                throw new ObjectNotFound(msg);
            }
            Attribute[] attrs = identity.getAttributes();
            if (attrs != null && attrs.length > 0) {
                HashMap idAttrs = null;
                HashSet<String> removeAttrs = null;
                for (i = 0; i < attrs.length; ++i) {
                    String attrName = attrs[i].getName();
                    String[] attrValues = attrs[i].getValues();
                    if (attrValues != null && attrValues.length > 0) {
                        HashSet<String> idAttrValues = new HashSet<String>(attrValues.length);
                        for (int j = 0; j < attrValues.length; ++j) {
                            idAttrValues.add(attrValues[j]);
                        }
                        if (idAttrs == null) {
                            idAttrs = new HashMap();
                        }
                        idAttrs.put(attrName, idAttrValues);
                        continue;
                    }
                    if (removeAttrs == null) {
                        removeAttrs = new HashSet<String>();
                    }
                    removeAttrs.add(attrName);
                }
                boolean storeNeeded = false;
                if (idAttrs != null) {
                    amIdentity.setAttributes(idAttrs);
                    storeNeeded = true;
                }
                if (removeAttrs != null) {
                    amIdentity.removeAttributes(removeAttrs);
                    storeNeeded = true;
                }
                if (storeNeeded) {
                    amIdentity.store();
                }
            }
            if (objectIdType.equals(IdType.USER)) {
                String[] groupNames;
                String[] roleNames = identity.getRoles();
                if (roleNames != null) {
                    HashSet<String> roleMemberships = new HashSet<String>(roleNames.length);
                    for (i = 0; i < roleNames.length; ++i) {
                        roleMemberships.add(roleNames[i]);
                    }
                    this.setMemberships(repo, amIdentity, roleMemberships, IdType.ROLE);
                }
                if ((groupNames = identity.getGroups()) != null) {
                    HashSet<String> groupMemberships = new HashSet<String>(groupNames.length);
                    for (int i2 = 0; i2 < groupNames.length; ++i2) {
                        groupMemberships.add(groupNames[i2]);
                    }
                    this.setMemberships(repo, amIdentity, groupMemberships, IdType.GROUP);
                }
            }
            if ((objectIdType.equals(IdType.GROUP) || objectIdType.equals(IdType.ROLE)) && (memberNames = identity.getMembers()) != null) {
                HashSet<String> members = new HashSet<String>(memberNames.length);
                for (int i3 = 0; i3 < memberNames.length; ++i3) {
                    members.add(memberNames[i3]);
                }
                this.setMembers(repo, amIdentity, members, IdType.USER);
            }
        }
        catch (IdRepoException ex) {
            debug.error("IdentityServicesImpl:create", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        catch (SSOException ex) {
            debug.error("IdentityServicesImpl:create", (Throwable)((Object)ex));
            throw new GeneralFailure(ex.getMessage());
        }
        return new UpdateResponse();
    }

    @Override
    public DeleteResponse delete(IdentityDetails identity, Token admin) throws NeedMoreCredentials, ObjectNotFound, TokenExpired, GeneralFailure {
        if (identity == null) {
            throw new GeneralFailure("delete failed: identity object not specified.");
        }
        String name = identity.getName();
        String identityType = identity.getType();
        String realm = identity.getRealm();
        if (name == null) {
            throw new ObjectNotFound("delete failed: null object name.");
        }
        if (realm == null) {
            realm = "/";
        }
        try {
            AMIdentityRepository repo;
            AMIdentity amIdentity = this.getAMIdentity(admin, identityType, name, realm);
            if (this.identityExists(amIdentity)) {
                repo = this.getRepo(admin, realm);
                IdType idType = amIdentity.getType();
                if (idType.equals(IdType.GROUP) || idType.equals(IdType.ROLE)) {
                    Set members = this.getMembers(amIdentity, IdType.USER);
                    for (AMIdentity member : members) {
                        this.removeMember(repo, amIdentity, member);
                    }
                }
            } else {
                String msg = "Object '" + name + "' of type '" + identityType + "' was not found.";
                throw new ObjectNotFound(msg);
            }
            this.deleteAMIdentity(repo, amIdentity);
        }
        catch (IdRepoException ex) {
            debug.error("IdentityServicesImpl:delete", (Throwable)ex);
            throw new GeneralFailure(ex.getMessage());
        }
        catch (SSOException ex) {
            debug.error("IdentityServicesImpl:delete", (Throwable)((Object)ex));
            throw new GeneralFailure(ex.getMessage());
        }
        return new DeleteResponse();
    }

    private boolean identityExists(AMIdentity amIdentity) throws SSOException, IdRepoException {
        return amIdentity != null && amIdentity.isExists();
    }

    private AMIdentityRepository getRepo(SSOToken token, String realm) throws IdRepoException, TokenExpired {
        if (realm == null || realm.length() == 0) {
            realm = "/";
        }
        try {
            return new AMIdentityRepository(token, realm);
        }
        catch (SSOException ssoe) {
            throw new TokenExpired(ssoe.getMessage());
        }
    }

    private AMIdentityRepository getRepo(Token admin, String realm) throws IdRepoException, TokenExpired {
        SSOToken ssoToken = this.getSSOToken(admin);
        return this.getRepo(ssoToken, realm);
    }

    private IdType getIdType(String objectType) {
        try {
            return IdUtils.getType(objectType);
        }
        catch (IdRepoException idRepoException) {
            return null;
        }
    }

    private boolean isOperationSupported(AMIdentityRepository repo, IdType idType, IdOperation operation) {
        boolean rv = false;
        try {
            Set ops = repo.getAllowedIdOperations(idType);
            if (ops != null) {
                rv = ops.contains(operation);
            }
        }
        catch (IdRepoException ex) {
        }
        catch (SSOException ex) {
            // empty catch block
        }
        return rv;
    }

    private Set getMembers(AMIdentity amIdentity, IdType type) throws IdRepoException, SSOException {
        return amIdentity.getMembers(type);
    }

    private Set getMemberNames(AMIdentity amIdentity, IdType type) throws IdRepoException, SSOException {
        HashSet<String> rv = null;
        Set members = this.getMembers(amIdentity, type);
        if (members != null) {
            rv = new HashSet<String>();
            for (AMIdentity nextIdentity : members) {
                rv.add(nextIdentity.getName());
            }
        }
        return rv;
    }

    private List fetchAMIdentities(IdType type, String identity, boolean fetchAllAttrs, AMIdentityRepository repo, Map searchModifiers) throws GeneralFailure, IdRepoException {
        IdSearchControl searchControl = new IdSearchControl();
        IdSearchResults searchResults = null;
        ArrayList identities = null;
        if (this.isOperationSupported(repo, type, IdOperation.READ)) {
            try {
                if (fetchAllAttrs) {
                    searchControl.setAllReturnAttributes(true);
                } else {
                    searchControl.setAllReturnAttributes(false);
                }
                if (searchModifiers != null) {
                    searchControl.setSearchModifiers(IdSearchOpModifier.AND, searchModifiers);
                }
                searchResults = repo.searchIdentities(type, identity, searchControl);
                Set resultSet = searchResults.getSearchResults();
                identities = new ArrayList(resultSet);
            }
            catch (Exception e) {
                debug.error("IdentityServicesImpl:fetchAMIdentities", (Throwable)e);
                throw new GeneralFailure(e.getMessage());
            }
        } else {
            identities = new ArrayList();
        }
        return identities;
    }

    private AMIdentity fetchAMIdentity(AMIdentityRepository repo, IdType type, String identity, boolean fetchAllAttrs) throws GeneralFailure, IdRepoException {
        AMIdentity rv = null;
        List identities = this.fetchAMIdentities(type, identity, fetchAllAttrs, repo, null);
        if (identities != null && identities.size() > 0) {
            rv = (AMIdentity)identities.get(0);
        }
        return rv;
    }

    private AMIdentity getAMIdentity(SSOToken ssoToken, AMIdentityRepository repo, String guid, IdType idType) throws IdRepoException, SSOException {
        AMIdentity rv;
        block3: {
            rv = null;
            if (this.isOperationSupported(repo, idType, IdOperation.READ)) {
                try {
                    rv = DN.isDN((String)guid) ? new AMIdentity(ssoToken, guid) : new AMIdentity(ssoToken, guid, idType, repo.getRealmIdentity().getRealm(), null);
                }
                catch (IdRepoException ex) {
                    String errCode = ex.getErrorCode();
                    if ("215".equals(errCode)) break block3;
                    throw ex;
                }
            }
        }
        return rv;
    }

    private AMIdentity getAMIdentity(Token admin, String objectType, String id, String realm) throws GeneralFailure, IdRepoException, TokenExpired {
        SSOToken ssoToken = this.getSSOToken(admin);
        AMIdentityRepository repo = this.getRepo(ssoToken, realm);
        try {
            return this.getAMIdentity(ssoToken, repo, objectType, id);
        }
        catch (SSOException ssoe) {
            throw new TokenExpired(ssoe.getMessage());
        }
    }

    private AMIdentity getAMIdentity(SSOToken ssoToken, AMIdentityRepository repo, String objectType, String id) throws GeneralFailure, IdRepoException, SSOException {
        AMIdentity rv = null;
        IdType idType = null;
        if (objectType != null) {
            idType = this.getIdType(objectType);
        }
        if (idType != null && !this.identityExists(rv = this.getAMIdentity(ssoToken, repo, id, idType))) {
            rv = this.fetchAMIdentity(repo, idType, id, true);
        }
        return rv;
    }

    private void addMember(AMIdentityRepository repo, AMIdentity amIdentity, AMIdentity member) throws NeedMoreCredentials, IdRepoException, SSOException {
        if (!member.isMember(amIdentity)) {
            if (this.isOperationSupported(repo, amIdentity.getType(), IdOperation.EDIT)) {
                amIdentity.addMember(member);
            } else {
                throw new NeedMoreCredentials("");
            }
        }
    }

    private void removeMember(AMIdentityRepository repo, AMIdentity amIdentity, AMIdentity member) throws NeedMoreCredentials, IdRepoException, SSOException {
        if (member.isMember(amIdentity)) {
            IdType type = amIdentity.getType();
            if (this.isOperationSupported(repo, type, IdOperation.EDIT)) {
                amIdentity.removeMember(member);
            } else {
                throw new NeedMoreCredentials("");
            }
        }
    }

    private void deleteAMIdentities(AMIdentityRepository repo, IdType type, Set identities) throws NeedMoreCredentials, IdRepoException, SSOException {
        if (!this.isOperationSupported(repo, type, IdOperation.DELETE)) {
            throw new NeedMoreCredentials("");
        }
        repo.deleteIdentities(identities);
    }

    private void deleteAMIdentity(AMIdentityRepository repo, AMIdentity amIdentity) throws NeedMoreCredentials, IdRepoException, SSOException {
        HashSet<AMIdentity> identities = new HashSet<AMIdentity>();
        identities.add(amIdentity);
        this.deleteAMIdentities(repo, amIdentity.getType(), identities);
    }

    private Set getMemberships(AMIdentity amIdentity, IdType idType) throws SSOException {
        HashSet memberships;
        try {
            memberships = amIdentity.getMemberships(idType);
        }
        catch (IdRepoException ex) {
            memberships = new HashSet(0);
        }
        return memberships;
    }

    private Set getMembershipNames(AMIdentity amIdentity, IdType idType) throws SSOException {
        HashSet<String> rv = null;
        Set memberships = this.getMemberships(amIdentity, idType);
        rv = new HashSet<String>(memberships.size());
        for (AMIdentity container : memberships) {
            rv.add(container.getName());
        }
        return rv;
    }

    private void setMemberships(AMIdentityRepository repo, AMIdentity amIdentity, Set memberships, IdType idType) throws IdRepoException, SSOException, GeneralFailure, NeedMoreCredentials {
        AMIdentity container;
        Set membershipsToAdd = memberships;
        Set membershipsToRemove = null;
        Set currentMemberships = this.getMembershipNames(amIdentity, idType);
        if (currentMemberships != null && currentMemberships.size() > 0) {
            membershipsToRemove = this.removeAllIgnoreCase(currentMemberships, memberships);
            membershipsToAdd = this.removeAllIgnoreCase(memberships, currentMemberships);
        }
        if (membershipsToRemove != null) {
            for (String idName : membershipsToRemove) {
                container = this.fetchAMIdentity(repo, idType, idName, false);
                this.removeMember(repo, container, amIdentity);
            }
        }
        if (membershipsToAdd != null) {
            for (String idName : membershipsToAdd) {
                container = this.fetchAMIdentity(repo, idType, idName, false);
                this.addMember(repo, container, amIdentity);
            }
        }
    }

    private void setMembers(AMIdentityRepository repo, AMIdentity amIdentity, Set members, IdType idType) throws IdRepoException, SSOException, GeneralFailure, NeedMoreCredentials {
        AMIdentity identity;
        Set membershipsToAdd = members;
        Set membershipsToRemove = null;
        Set currentMembers = this.getMemberNames(amIdentity, idType);
        if (currentMembers != null && currentMembers.size() > 0) {
            membershipsToRemove = this.removeAllIgnoreCase(currentMembers, members);
            membershipsToAdd = this.removeAllIgnoreCase(members, currentMembers);
        }
        if (membershipsToRemove != null) {
            for (String memberName : membershipsToRemove) {
                identity = this.fetchAMIdentity(repo, idType, memberName, false);
                if (identity == null) continue;
                this.removeMember(repo, amIdentity, identity);
            }
        }
        if (membershipsToAdd != null) {
            for (String memberName : membershipsToAdd) {
                identity = this.fetchAMIdentity(repo, idType, memberName, false);
                if (identity == null) continue;
                this.addMember(repo, amIdentity, identity);
            }
        }
    }

    private Set removeAllIgnoreCase(Set src, Set removeSet) {
        HashSet result;
        if (src == null || src.size() < 1) {
            result = new HashSet(0);
        } else {
            result = new HashSet(src);
            if (removeSet != null && removeSet.size() > 0) {
                HashMap<String, String> upcaseSrc = new HashMap<String, String>(src.size());
                for (String s : src) {
                    upcaseSrc.put(s.toUpperCase(), s);
                }
                Iterator it = removeSet.iterator();
                while (it.hasNext()) {
                    String s;
                    s = (String)upcaseSrc.get(((String)it.next()).toUpperCase());
                    if (s == null) continue;
                    result.remove(s);
                }
            }
        }
        return result;
    }

    private IdentityDetails convertToIdentityDetails(AMIdentity amIdentity, List attrList) throws IdRepoException, SSOException {
        IdentityDetails rv = null;
        if (amIdentity != null) {
            Set members;
            int i;
            IdType idType = amIdentity.getType();
            Map attrs = null;
            boolean addUniversalId = false;
            rv = new IdentityDetails();
            rv.setName(amIdentity.getName());
            rv.setType(amIdentity.getType().getName());
            rv.setRealm(amIdentity.getRealm());
            if (IdType.USER.equals(idType)) {
                Set groups;
                Set roles = amIdentity.getMemberships(IdType.ROLE);
                if (roles != null && roles.size() > 0) {
                    AMIdentity[] rolesFound = new AMIdentity[roles.size()];
                    String[] roleNames = new String[rolesFound.length];
                    roles.toArray(rolesFound);
                    for (i = 0; i < rolesFound.length; ++i) {
                        roleNames[i] = rolesFound[i].getName();
                    }
                    rv.setRoles(roleNames);
                }
                if ((groups = amIdentity.getMemberships(IdType.GROUP)) != null && groups.size() > 0) {
                    AMIdentity[] groupsFound = new AMIdentity[groups.size()];
                    String[] groupNames = new String[groupsFound.length];
                    groups.toArray(groupsFound);
                    for (int i2 = 0; i2 < groupsFound.length; ++i2) {
                        groupNames[i2] = groupsFound[i2].getName();
                    }
                    rv.setGroups(groupNames);
                }
            }
            if ((IdType.GROUP.equals(idType) || IdType.ROLE.equals(idType)) && (members = amIdentity.getMembers(IdType.USER)) != null && members.size() > 0) {
                AMIdentity[] membersFound = new AMIdentity[members.size()];
                String[] memberNames = new String[membersFound.length];
                members.toArray(membersFound);
                for (i = 0; i < membersFound.length; ++i) {
                    memberNames[i] = membersFound[i].getName();
                }
                rv.setMembers(memberNames);
            }
            if (attrList != null) {
                HashSet<String> attrNames = new HashSet<String>();
                for (String attrName : attrList) {
                    if ("universalid".equalsIgnoreCase(attrName)) {
                        addUniversalId = true;
                        continue;
                    }
                    if (attrNames.contains(attrName)) continue;
                    attrNames.add(attrName);
                }
                attrs = amIdentity.getAttributes(attrNames);
            } else {
                attrs = amIdentity.getAttributes();
                addUniversalId = true;
            }
            if (addUniversalId) {
                if (attrs == null) {
                    attrs = new HashMap();
                }
                HashSet<String> uidValue = new HashSet<String>();
                uidValue.add(amIdentity.getUniversalId());
                attrs.put("universalid", uidValue);
            }
            if (attrs != null) {
                ArrayList<Attribute> attributes = new ArrayList<Attribute>(attrs.size());
                Iterator keyIter = attrs.keySet().iterator();
                while (keyIter.hasNext()) {
                    String key = keyIter.next().toString();
                    Attribute attribute = new Attribute();
                    attribute.setName(key);
                    Set value = (Set)attrs.get(key);
                    ArrayList<String> valueList = null;
                    if (value != null) {
                        valueList = new ArrayList<String>(value.size());
                        for (Object next : value) {
                            if (next == null) continue;
                            valueList.add(next.toString());
                        }
                    }
                    if (valueList == null) continue;
                    String[] valueArray = new String[valueList.size()];
                    attribute.setValues(valueList.toArray(valueArray));
                    attributes.add(attribute);
                }
                Attribute[] attrArray = new Attribute[attributes.size()];
                rv.setAttributes(attributes.toArray(attrArray));
            }
        }
        return rv;
    }

    private SSOToken getSSOToken(Token admin) throws TokenExpired {
        SSOToken token = null;
        try {
            if (admin == null) {
                throw new TokenExpired("Token is NULL");
            }
            SSOTokenManager mgr = SSOTokenManager.getInstance();
            token = mgr.createSSOToken(admin.getId());
        }
        catch (SSOException ex) {
            throw new TokenExpired(ex.getMessage());
        }
        return token;
    }

    private Map<String, Set> attributesToMap(List attrs) {
        if (attrs != null) {
            Attribute[] attributes = new Attribute[attrs.size()];
            attributes = attrs.toArray(attributes);
            return this.attributesToMap(attributes);
        }
        return Collections.EMPTY_MAP;
    }

    private Map<String, Set> attributesToMap(Attribute[] attrs) {
        HashMap idAttrs = new CaseInsensitiveHashMap();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                String attrName = attrs[i].getName();
                String[] attrValues = attrs[i].getValues();
                HashSet<String> idAttrValues = null;
                if (attrValues != null && attrValues.length > 0) {
                    idAttrValues = new HashSet<String>(attrValues.length);
                    for (int j = 0; j < attrValues.length; ++j) {
                        idAttrValues.add(attrValues[j]);
                    }
                } else {
                    idAttrValues = Collections.EMPTY_SET;
                }
                idAttrs.put(attrName, idAttrValues);
            }
        } else {
            idAttrs = new HashMap(1);
        }
        return idAttrs;
    }

    @Override
    public boolean isTokenValid(Token token) throws InvalidToken, GeneralFailure, TokenExpired, RemoteException {
        try {
            SSOTokenManager mgr = SSOTokenManager.getInstance();
            SSOToken t = mgr.createSSOToken(token.getId());
            mgr.validateToken(t);
        }
        catch (SSOException e) {
            throw new InvalidToken(e.getMessage());
        }
        return true;
    }

    @Override
    public String getCookieNameForToken() throws GeneralFailure, RemoteException {
        return SystemProperties.get("com.iplanet.am.cookie.name", "iPlanetDirectoryPro");
    }

    @Override
    public String[] getCookieNamesToForward() throws GeneralFailure, RemoteException {
        String[] cookies = null;
        String ssoTokenCookie = this.getCookieNameForToken();
        String lbCookieName = SystemProperties.get("com.iplanet.am.lbcookie.name");
        if (lbCookieName == null) {
            cookies = new String[1];
        } else {
            cookies = new String[2];
            cookies[1] = lbCookieName;
        }
        cookies[0] = ssoTokenCookie;
        return cookies;
    }
}

