/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idsvcs;

import com.sun.identity.idsvcs.IdentityServicesImpl;
import java.util.HashMap;
import java.util.Map;

public class IdentityServicesFactory {
    private static final String DEFAULT = "com.sun.identity.idsvcs.opensso.IdentityServicesImpl";
    private final Class provider;
    private static IdentityServicesImpl providerImpl;
    private static Map cache;

    private IdentityServicesFactory(Class clazz) {
        this.provider = clazz;
    }

    public static IdentityServicesFactory getInstance() {
        return IdentityServicesFactory.getInstance(DEFAULT);
    }

    public static IdentityServicesFactory getInstance(String provider) {
        Class<IdentityServicesImpl> TEST = IdentityServicesImpl.class;
        IdentityServicesFactory ret = (IdentityServicesFactory)cache.get(provider);
        if (ret == null) {
            try {
                boolean found = false;
                Class<?> clazz = Class.forName(provider);
                Class<?>[] infs = clazz.getInterfaces();
                for (int i = 0; i < infs.length; ++i) {
                    Class<?> tst = infs[i];
                    if (!tst.equals(TEST)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalArgumentException("Does not implement IdentityServices!");
                }
                ret = new IdentityServicesFactory(clazz);
                cache.put(provider, ret);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return ret;
    }

    public IdentityServicesImpl newInstance() {
        if (providerImpl == null) {
            try {
                providerImpl = (IdentityServicesImpl)this.provider.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return providerImpl;
    }

    static {
        cache = new HashMap();
    }
}

