/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.files;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoBundle;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.idm.plugins.files.FilesRepoEntryNotFoundException;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Hash;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.sm.SchemaType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class FilesRepo
extends IdRepo {
    public static final String NAME = "com.sun.identity.idm.plugins.files.FilesRepo";
    public static final Debug debug = Debug.getInstance((String)"amIdRepoFiles");
    public static final String DIRECTORY = "sunFilesIdRepoDirectory";
    public static final String OBJECTCLASS = "sunFilesObjectClasses";
    public static final String PASSWORD = "sunFilesPasswordAttr";
    public static final String STATUS = "sunFilesStatusAttr";
    public static final String HASH = "sunFilesHashAttrs";
    public static final String ENCRYPT = "sunFilesEncryptAttrs";
    public static final String UPDATE_CACHE = "sunFilesMonitorForChanges";
    public static final String UPDATE_CACHE_TIME = "sunFilesMonitoringTime";
    public static final String OC = "objectclass";
    private static Map supportedOps = new CaseInsensitiveHashMap();
    private static Map identityCache = new CaseInsensitiveHashMap();
    private Map identityTimeCache = new HashMap();
    boolean cacheUpdateEnabled;
    int updateCacheInterval;
    private String directory = "/var/opt/SUNWam/idm/flatfiles";
    private String passwordAttribute = "userPassword";
    private String statusAttribute = "inetUserStatus";
    private String statusActive = "Active";
    private String statusInactive = "Inactive";
    Set userOCs;
    private String roleMembershipAttribute = "nsRoleDN";
    private String groupMembersAttribute = "memberOfGroup";
    private Set hashAttributes = new CaseInsensitiveHashSet();
    private Set encryptAttributes = new CaseInsensitiveHashSet();
    IdRepoListener repoListener;
    IdRepoException initializationException;

    public void initialize(Map configParams) {
        String value;
        super.initialize(configParams);
        Set set = (Set)configParams.get(DIRECTORY);
        if (set != null && !set.isEmpty()) {
            this.directory = (String)set.iterator().next();
            try {
                this.initDir(this.directory);
            }
            catch (IdRepoException ide) {
                this.initializationException = ide;
                debug.error("FilesRepo: Init exception", (Throwable)ide);
            }
        }
        if ((set = (Set)configParams.get(PASSWORD)) != null && !set.isEmpty()) {
            this.passwordAttribute = (String)set.iterator().next();
        }
        this.userOCs = (Set)configParams.get(OBJECTCLASS);
        if (this.userOCs == null) {
            this.userOCs = Collections.EMPTY_SET;
        }
        if ((set = (Set)configParams.get(STATUS)) != null && !set.isEmpty()) {
            this.statusAttribute = (String)set.iterator().next();
        }
        if ((set = (Set)configParams.get(HASH)) != null && !set.isEmpty()) {
            this.hashAttributes.addAll(set);
        }
        if ((set = (Set)configParams.get(ENCRYPT)) != null && !set.isEmpty()) {
            this.encryptAttributes.addAll(set);
        }
        if ((set = (Set)configParams.get(UPDATE_CACHE)) != null && !set.isEmpty() && (value = (String)set.iterator().next()).equalsIgnoreCase("true")) {
            this.cacheUpdateEnabled = true;
            set = (Set)configParams.get(UPDATE_CACHE_TIME);
            if (set != null && !set.isEmpty()) {
                value = (String)set.iterator().next();
                try {
                    this.updateCacheInterval = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    this.updateCacheInterval = 10;
                }
            }
            SystemTimer.getTimer().schedule((TaskRunnable)new CacheUpdateRunnable(this), new Date((System.currentTimeMillis() + (long)(this.updateCacheInterval * 60 * 1000)) / 1000L * 1000L));
        }
        if (debug.messageEnabled()) {
            debug.message("FlatFiles: Root dir: " + this.directory + "\n\tUser Objectclasses: " + this.userOCs + "\n\tPassword Attr: " + this.passwordAttribute + "\n\tStatus Attr: " + this.statusAttribute + "\n\tAttrs Hashed: " + this.hashAttributes + "\n\tAttrs Encyrpted: " + this.encryptAttributes + "\n\tUpdate Cache: " + this.cacheUpdateEnabled + "\n\tUpdate Interval: " + this.updateCacheInterval);
        }
    }

    public int addListener(SSOToken token, IdRepoListener listener) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo addListener called");
        }
        this.repoListener = listener;
        return 0;
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType stype, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("Assign service called for: " + type.getName() + ":" + name + "\n\t" + serviceName + "=" + attrMap + "\n\tSchema=" + stype);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        if (type.equals(IdType.USER) || type.equals(IdType.ROLE) || type.equals(IdType.REALM)) {
            HashSet<String> set = new HashSet<String>();
            set.add(OC);
            Map attrs = this.getAttributes(token, type, name, set);
            Set objectclasses = (Set)attrs.get(OC);
            CaseInsensitiveHashMap sAttrs = new CaseInsensitiveHashMap();
            sAttrs.putAll(attrMap);
            Set serviceOcs = (Set)sAttrs.get(OC);
            if (objectclasses != null && !objectclasses.isEmpty() && serviceOcs != null) {
                serviceOcs.addAll(objectclasses);
            }
        } else {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        this.setAttributes(token, type, name, attrMap, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String create(SSOToken token, IdType type, String name, Map attrMap) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        if (!supportedOps.keySet().contains(type)) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName(), type.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        File file = this.constructFile(this.directory, type, name);
        if (file.exists()) {
            Object[] args = new String[]{file.getAbsolutePath()};
            throw new IdRepoException("amIdRepo", "310", args);
        }
        CaseInsensitiveHashMap nAttrs = new CaseInsensitiveHashMap(attrMap);
        Set ocs = (Set)nAttrs.get(OC);
        if (ocs == null) {
            nAttrs.put(OC, this.userOCs);
        } else {
            CaseInsensitiveHashSet ocv = new CaseInsensitiveHashSet((Collection)ocs);
            ocv.addAll(this.userOCs);
        }
        attrMap = FilesRepo.processAttributes(nAttrs, this.hashAttributes, this.encryptAttributes);
        this.writeFile(file, attrMap);
        if (this.repoListener == null) return name;
        this.repoListener.objectChanged(name, 1, this.repoListener.getConfigMap());
        return name;
    }

    public void delete(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("FilesRepo.delete: throwing initialization exception");
            throw this.initializationException;
        }
        File file = this.constructFile(this.directory, type, name);
        file.delete();
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServicesAndOCs) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.getAssignedService called: " + name + "\n\tmapOfServicesAndOCs=" + mapOfServicesAndOCs);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo.getAssignedServices: throwing initialization exception");
            throw this.initializationException;
        }
        HashSet<String> attrNames = new HashSet<String>();
        attrNames.add(OC);
        Map ocs = this.getAttributes(token, type, name, attrNames);
        Set presentOcs = (Set)ocs.get(OC);
        if (presentOcs == null || presentOcs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> answer = new HashSet<String>();
        Iterator items = mapOfServicesAndOCs.keySet().iterator();
        while (items.hasNext()) {
            String serviceName = (String)items.next();
            Set reqOcs = (Set)mapOfServicesAndOCs.get(serviceName);
            if (reqOcs == null || reqOcs.isEmpty() || !presentOcs.containsAll(reqOcs)) continue;
            answer.add(serviceName);
        }
        return answer;
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.getAttributes called: " + name + "\n\treturn attributes=" + attrNames);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo.getAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        Map answer = attrNames == null ? null : new HashMap();
        Map map = this.getAttributes(token, type, name);
        if (attrNames == null) {
            answer = map;
        } else {
            Iterator items = attrNames.iterator();
            while (items.hasNext()) {
                Object key = items.next();
                Object value = map.get(key);
                if (value == null) continue;
                answer.put(key, value);
            }
        }
        return answer;
    }

    public Map getAttributes(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo: get all attributes called: " + type.getName() + "::" + name);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        File file = this.constructFile(this.directory, type, name);
        return FilesRepo.decodeAttributes(this.readFile(file), this.encryptAttributes);
    }

    public Map getBinaryAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        Map stringAttributes = this.getAttributes(token, type, name, attrNames);
        HashMap<String, byte[][]> binaryAttributes = new HashMap<String, byte[][]>();
        Iterator items = stringAttributes.keySet().iterator();
        while (items.hasNext()) {
            String attrName = (String)items.next();
            Set values = (Set)stringAttributes.get(attrName);
            byte[][] binValues = new byte[values.size()][];
            int i = 0;
            try {
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    binValues[i] = ((String)it.next()).getBytes("UTF-8");
                    ++i;
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            binaryAttributes.put(attrName, binValues);
        }
        return binaryAttributes;
    }

    public void setBinaryAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (attributes == null) {
            return;
        }
        HashMap attrs = new HashMap();
        Iterator items = attributes.keySet().iterator();
        while (items.hasNext()) {
            String attrName = (String)items.next();
            byte[][] attrBytes = (byte[][])attributes.get(attrName);
            HashSet<String> attrValues = new HashSet<String>();
            int size = attrBytes.length;
            try {
                for (int i = 0; i < size; ++i) {
                    attrValues.add(new String(attrBytes[i], "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            attrs.put(attrName, attrValues);
        }
        this.setAttributes(token, type, name, attrs, isAdd);
    }

    public Set getMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.getMembers called" + type + ": " + name + ": " + membersType);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo.getMembers: throwing initialization exception");
            throw this.initializationException;
        }
        if (!type.equals(IdType.ROLE) && !type.equals(IdType.GROUP)) {
            debug.message("FilesRepo.getMembers supported for roles and groups");
            throw new IdRepoException(IdRepoBundle.getString("203"), "203");
        }
        HashSet<String> results = new HashSet<String>();
        if (type.equals(IdType.GROUP)) {
            File file = this.constructFile(this.directory, type, name);
            Map attrs = FilesRepo.decodeAttributes(this.readFile(file), this.encryptAttributes);
            Set members = (Set)attrs.get(this.groupMembersAttribute);
            if (members != null && !members.isEmpty()) {
                String mtype = membersType.getName();
                int mtypeLen = mtype.length();
                Iterator items = members.iterator();
                while (items.hasNext()) {
                    String sname = (String)items.next();
                    if (!sname.startsWith(mtype)) continue;
                    results.add(sname.substring(mtypeLen));
                }
            }
        } else if (type.equals(IdType.ROLE)) {
            HashSet<String> returnAttrs = new HashSet<String>();
            returnAttrs.add(this.roleMembershipAttribute);
            RepoSearchResults allUsers = this.search(token, membersType, "*", 0, 0, returnAttrs, false, 0, null, false);
            Map userAttributes = null;
            if (allUsers != null && (userAttributes = allUsers.getResultAttributes()) != null) {
                Iterator i = userAttributes.keySet().iterator();
                while (i.hasNext()) {
                    String sname = (String)i.next();
                    Map attrs = (Map)userAttributes.get(sname);
                    Set roles = (Set)attrs.get(this.roleMembershipAttribute);
                    if (roles == null || !roles.contains(name)) continue;
                    results.add(sname);
                }
            }
        } else {
            Object[] args = new Object[]{NAME, IdOperation.READ.getName(), type.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        return results;
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.getMemberships called " + type + ": " + name + ": " + membershipType);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo.getMemeberships: throwing initialization exception");
            throw this.initializationException;
        }
        if (!type.equals(IdType.USER) && !type.equals(IdType.AGENT)) {
            debug.message("FilesRepo:getMemberships supported for users and agents");
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        Set<String> results = new HashSet();
        if (membershipType.equals(IdType.ROLE)) {
            Set roles;
            HashSet<String> returnAttrs = new HashSet<String>();
            returnAttrs.add(this.roleMembershipAttribute);
            Map attrs = this.getAttributes(token, type, name, returnAttrs);
            if (attrs != null && (roles = (Set)attrs.get(this.roleMembershipAttribute)) != null) {
                results = roles;
            }
        } else if (membershipType.equals(IdType.GROUP)) {
            HashSet<String> returnAttrs = new HashSet<String>();
            returnAttrs.add(this.groupMembersAttribute);
            RepoSearchResults allGroups = this.search(token, membershipType, "*", 0, 0, returnAttrs, false, 0, null, false);
            Map groupAttrs = null;
            if (allGroups != null && (groupAttrs = allGroups.getResultAttributes()) != null) {
                name = type.getName() + name;
                Iterator i = groupAttrs.keySet().iterator();
                while (i.hasNext()) {
                    String sname = (String)i.next();
                    Map attrs = (Map)groupAttrs.get(sname);
                    Set ids = (Set)attrs.get(this.groupMembersAttribute);
                    if (ids == null || !ids.contains(name)) continue;
                    results.add(sname);
                }
            }
        } else {
            Object[] args = new Object[]{NAME, IdOperation.READ.getName(), membershipType.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        return results;
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, true);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, false);
    }

    private Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, boolean isString) throws IdRepoException, SSOException {
        HashMap results;
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.getServiceAttributes called. " + name + "\n\t" + serviceName + "=" + attrNames);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo.getServiceAttributes: throwing initialization exception");
            throw this.initializationException;
        }
        if (!(type.equals(IdType.USER) || type.equals(IdType.ROLE) || type.equals(IdType.REALM))) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        Map map = results = isString ? this.getAttributes(token, type, name, attrNames) : this.getBinaryAttributes(token, type, name, attrNames);
        if (results == null) {
            results = new HashMap();
        }
        if (!type.equals(IdType.USER)) {
            return results;
        }
        Set roles = this.getMemberships(token, type, name, IdType.ROLE);
        Iterator items = roles.iterator();
        while (items.hasNext()) {
            String role = (String)items.next();
            Map roleAttrs = Collections.EMPTY_MAP;
            try {
                roleAttrs = isString ? this.getAttributes(token, IdType.ROLE, role, attrNames) : this.getBinaryAttributes(token, IdType.ROLE, role, attrNames);
            }
            catch (FilesRepoEntryNotFoundException fnf) {
                roleAttrs = Collections.EMPTY_MAP;
            }
            Iterator ris = roleAttrs.keySet().iterator();
            while (ris.hasNext()) {
                Object roleAttrName = ris.next();
                Object roleAttrValues = roleAttrs.get(roleAttrName);
                Object idAttrValues = results.get(roleAttrName);
                if (idAttrValues == null) {
                    results.put(roleAttrName, roleAttrValues);
                    continue;
                }
                if (isString) {
                    ((Set)idAttrValues).addAll((Set)roleAttrValues);
                    continue;
                }
                byte[][] resultsArr = (byte[][])results.get(roleAttrName);
                byte[][] roleArr = (byte[][])roleAttrs.get(roleAttrName);
                resultsArr = this.combineByteArray(resultsArr, roleArr);
                results.put(roleAttrName, resultsArr);
            }
        }
        Map realmAttrs = isString ? this.getAttributes(token, IdType.REALM, "ContainerDefaultTemplateRole", attrNames) : this.getBinaryAttributes(token, IdType.REALM, "ContainerDefaultTemplateRole", attrNames);
        Iterator ris = realmAttrs.keySet().iterator();
        while (ris.hasNext()) {
            Object realmAttrName = ris.next();
            Object realmAttrValues = realmAttrs.get(realmAttrName);
            Object idAttrValues = results.get(realmAttrName);
            if (idAttrValues == null) {
                results.put(realmAttrName, realmAttrValues);
                continue;
            }
            if (isString) {
                ((Set)idAttrValues).addAll((Set)realmAttrValues);
                continue;
            }
            byte[][] resultsArr = (byte[][])results.get(realmAttrName);
            byte[][] realmArr = (byte[][])realmAttrs.get(realmAttrName);
            resultsArr = this.combineByteArray(resultsArr, realmArr);
            results.put(realmAttrName, resultsArr);
        }
        return results;
    }

    private byte[][] combineByteArray(byte[][] resultsArr, byte[][] realmArr) {
        int combinedSize = realmArr.length;
        if (resultsArr != null) {
            int i;
            combinedSize = ((byte[][])resultsArr).length + realmArr.length;
            byte[][] tmpSet = new byte[combinedSize][];
            for (i = 0; i < ((byte[][])resultsArr).length; ++i) {
                tmpSet[i] = resultsArr[i];
            }
            for (i = 0; i < realmArr.length; ++i) {
                tmpSet[i] = realmArr[i];
            }
            resultsArr = tmpSet;
        } else {
            resultsArr = (byte[][])realmArr.clone();
        }
        return resultsArr;
    }

    public boolean isExists(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        boolean entryExists = true;
        try {
            this.getAttributes(token, type, name);
        }
        catch (FilesRepoEntryNotFoundException fe) {
            entryExists = false;
        }
        return entryExists;
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.modifyMemberShip called. " + type + "; name= " + name + "; members= " + members + "; membersType= " + membersType + "; operation= " + operation);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo.modifyMemberShip: throwing initialization exception");
            throw this.initializationException;
        }
        if (members == null || members.isEmpty()) {
            debug.message("FilesRepo.modifyMemberShip: Members set is empty");
            throw new IdRepoException(IdRepoBundle.getString("201"), "201");
        }
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            if (debug.messageEnabled()) {
                debug.message("FilesRepo.modifyMemberShip: Membership to users and agents is not supported");
            }
            throw new IdRepoException(IdRepoBundle.getString("203"), "203");
        }
        if (!membersType.equals(IdType.USER) && !membersType.equals(IdType.AGENT)) {
            if (debug.messageEnabled()) {
                debug.message("FilesRepo.modifyMemberShip: A non user/agent type cannot  be made a member of any identity" + membersType.getName());
            }
            Object[] args = new Object[]{NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        if (type.equals(IdType.GROUP)) {
            File file = this.constructFile(this.directory, type, name);
            Map attrs = FilesRepo.decodeAttributes(this.readFile(file), this.encryptAttributes);
            HashSet<String> gmembers = (HashSet<String>)attrs.get(this.groupMembersAttribute);
            if (gmembers == null) {
                gmembers = new HashSet<String>();
                attrs.put(this.groupMembersAttribute, gmembers);
            }
            Iterator items = members.iterator();
            while (items.hasNext()) {
                String item = membersType.getName() + items.next().toString();
                if (operation == 1) {
                    gmembers.add(item);
                    continue;
                }
                gmembers.remove(item);
            }
            this.setAttributes(token, type, name, attrs, false);
        } else if (type.equals(IdType.ROLE)) {
            HashSet<String> returnAttrs = new HashSet<String>();
            returnAttrs.add(this.roleMembershipAttribute);
            Iterator items = members.iterator();
            while (items.hasNext()) {
                HashSet<String> sroles;
                String sname = (String)items.next();
                HashMap roles = this.getAttributes(token, membersType, sname, returnAttrs);
                if (roles == null) {
                    roles = new HashMap();
                }
                if ((sroles = (HashSet<String>)roles.get(this.roleMembershipAttribute)) == null) {
                    sroles = new HashSet<String>();
                    roles.put(this.roleMembershipAttribute, sroles);
                }
                if (operation == 1) {
                    sroles.add(name);
                } else {
                    sroles.remove(name);
                }
                this.setAttributes(token, membersType, sname, roles, false);
            }
        } else {
            Object[] args = new Object[]{NAME, type.getName()};
            throw new IdRepoException("amIdRepo", "209", args);
        }
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.modifyService called: " + name + "\n\t" + serviceName + "=" + attrMap + "\n\tSchema=" + sType);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo.modifyService: throwing initialization exception");
            throw this.initializationException;
        }
        if (!(type.equals(IdType.USER) || type.equals(IdType.ROLE) || type.equals(IdType.REALM))) {
            Object[] args = new Object[]{NAME, IdOperation.SERVICE.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        this.assignService(token, type, name, serviceName, sType, attrMap);
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        Map answer = this.getAttributes(token, type, name);
        Iterator items = attrNames.iterator();
        while (items.hasNext()) {
            answer.remove(items.next());
        }
        File file = this.constructFile(this.directory, type, name);
        this.writeFile(file, FilesRepo.processAttributes(answer, Collections.EMPTY_SET, this.encryptAttributes));
        if (this.repoListener != null) {
            this.repoListener.objectChanged(name, 4, this.repoListener.getConfigMap());
        }
    }

    public void removeListener() {
        this.repoListener = null;
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive) throws IdRepoException, SSOException {
        int i;
        File dir;
        String[] files;
        if (this.initializationException != null) {
            debug.error("FilesRepo.search: throwing initialization exception");
            throw this.initializationException;
        }
        if (debug.messageEnabled()) {
            debug.message("FilesRepo:search pattern=" + pattern + " type=" + type + " returnAttrs=" + returnAttrs + " filter= " + filterOp + " matchAttrs= " + avPairs);
        }
        if ((files = (dir = new File(new File(this.directory), type.getName())).list(new FileRepoFileFilter(pattern))).length == 0) {
            return new RepoSearchResults(Collections.EMPTY_SET, 0, Collections.EMPTY_MAP, type);
        }
        HashSet<String> results = new HashSet<String>();
        if (avPairs != null && !avPairs.isEmpty()) {
            for (i = 0; i < files.length; ++i) {
                Map allAttrs = this.getAttributes(token, type, files[i]);
                CaseInsensitiveHashSet attrNames = new CaseInsensitiveHashSet();
                attrNames.addAll(allAttrs.keySet());
                boolean addResult = filterOp == 1;
                Iterator items = avPairs.keySet().iterator();
                while (items.hasNext()) {
                    String attrName = (String)items.next();
                    Set attrValue = (Set)avPairs.get(attrName);
                    if (attrValue == null || attrValue.isEmpty() || attrValue.contains("*")) {
                        if (attrNames.contains(attrName)) {
                            if (filterOp != 0) continue;
                            addResult = true;
                            break;
                        }
                        if (filterOp != 1) continue;
                        addResult = false;
                        break;
                    }
                    Set matchValues = (Set)allAttrs.get(attrName);
                    if (matchValues != null && this.containsAttrValue(matchValues, attrValue)) {
                        if (filterOp != 0) continue;
                        addResult = true;
                        break;
                    }
                    if (filterOp != 1) continue;
                    addResult = false;
                    break;
                }
                if (!addResult) continue;
                results.add(files[i]);
            }
        } else {
            for (i = 0; i < files.length; ++i) {
                results.add(files[i]);
            }
        }
        HashMap<String, Map> resultsWithAttrs = new HashMap<String, Map>();
        Iterator items = results.iterator();
        while (items.hasNext()) {
            String item = (String)items.next();
            if (returnAllAttrs || returnAttrs == null) {
                resultsWithAttrs.put(item, this.getAttributes(token, type, item));
                continue;
            }
            if (returnAttrs.isEmpty()) {
                resultsWithAttrs.put(item, Collections.EMPTY_MAP);
                continue;
            }
            resultsWithAttrs.put(item, this.getAttributes(token, type, item, returnAttrs));
        }
        if (debug.messageEnabled()) {
            debug.message("FilesRepo:search results: " + results);
        }
        return new RepoSearchResults(results, 0, resultsWithAttrs, type);
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttrs) throws IdRepoException, SSOException {
        return this.search(token, type, pattern, maxTime, maxResults, returnAttrs, returnAttrs == null, 0, avPairs, recursive);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.setAttributes for " + type + " " + name + "\n\tAttributes=" + attributes.keySet() + " isAdd=" + isAdd);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        HashMap answer = this.getAttributes(token, type, name);
        if (answer == Collections.EMPTY_MAP) {
            answer = new HashMap();
        }
        attributes = FilesRepo.processAttributes(attributes, this.hashAttributes, Collections.EMPTY_SET);
        if (!isAdd) {
            answer.putAll(attributes);
        } else {
            Iterator items = attributes.keySet().iterator();
            while (items.hasNext()) {
                Object key = items.next();
                Set value = (Set)answer.get(key);
                if (value != null) {
                    value.addAll((Set)attributes.get(key));
                } else {
                    value = (Set)attributes.get(key);
                }
                answer.put(key, value);
            }
        }
        File file = this.constructFile(this.directory, type, name);
        this.writeFile(file, FilesRepo.processAttributes(answer, Collections.EMPTY_SET, this.encryptAttributes));
        if (this.repoListener != null) {
            this.repoListener.objectChanged(name, 4, this.repoListener.getConfigMap());
        }
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.unassignService called: " + name + "\n\t" + serviceName + "=" + attrMap);
        }
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(OC);
        Map attrs = this.getAttributes(token, type, name, set);
        Set objectclasses = (Set)attrs.get(OC);
        CaseInsensitiveHashMap sAttrs = new CaseInsensitiveHashMap();
        sAttrs.putAll(attrMap);
        Set serviceOCs = (Set)sAttrs.remove(OC);
        if (objectclasses != null && !objectclasses.isEmpty() && serviceOCs != null) {
            objectclasses.removeAll(serviceOCs);
            this.setAttributes(token, type, name, attrs, false);
        }
        this.removeAttributes(token, type, name, sAttrs.keySet());
    }

    public Set getSupportedOperations(IdType type) {
        return (Set)supportedOps.get(type);
    }

    public Set getSupportedTypes() {
        return supportedOps.keySet();
    }

    public boolean isActive(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        Map attributes = this.getAttributes(token, type, name);
        if (attributes == null) {
            Object[] args = new Object[]{NAME, name};
            throw new IdRepoException("amIdRepo", "202", args);
        }
        Set activeVals = (Set)attributes.get(this.statusAttribute);
        if (activeVals == null || activeVals.isEmpty()) {
            return true;
        }
        Iterator it = activeVals.iterator();
        String active = (String)it.next();
        return active.equalsIgnoreCase(this.statusActive);
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, boolean active) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        HashMap attrs = new HashMap();
        HashSet<String> vals = new HashSet<String>();
        if (active) {
            vals.add(this.statusActive);
        } else {
            vals.add(this.statusInactive);
        }
        attrs.put(this.statusAttribute, vals);
        this.setAttributes(token, type, name, attrs, false);
    }

    private static void loadSupportedOps() {
        HashSet<IdOperation> opSet = new HashSet<IdOperation>();
        opSet.add(IdOperation.EDIT);
        opSet.add(IdOperation.READ);
        opSet.add(IdOperation.CREATE);
        opSet.add(IdOperation.DELETE);
        supportedOps.put(IdType.GROUP, Collections.unmodifiableSet(opSet));
        supportedOps.put(IdType.AGENT, Collections.unmodifiableSet(opSet));
        HashSet<IdOperation> nopSet = new HashSet<IdOperation>(opSet);
        nopSet.add(IdOperation.SERVICE);
        supportedOps.put(IdType.USER, Collections.unmodifiableSet(nopSet));
        supportedOps.put(IdType.ROLE, Collections.unmodifiableSet(nopSet));
        supportedOps.put(IdType.REALM, Collections.unmodifiableSet(nopSet));
        if (debug.messageEnabled()) {
            debug.message("FilesRepo.loadSupportedOps called\n\tsupportedOps=" + supportedOps.toString());
        }
    }

    public String getFullyQualifiedName(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        RepoSearchResults results = this.search(token, type, name, null, true, 0, 0, null);
        Set dns = results.getSearchResults();
        if (dns != null || dns.size() != 1) {
            Object[] args = new String[]{NAME, name};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        return "files://FilesRepo/" + type.getName() + "/" + dns.iterator().next().toString();
    }

    public boolean supportsAuthentication() {
        return true;
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        debug.message("FilesRepo:authenticate called");
        if (this.initializationException != null) {
            debug.error("FilesRepo: throwing initialization exception");
            throw this.initializationException;
        }
        String username = null;
        String password = null;
        for (int i = 0; i < credentials.length; ++i) {
            char[] passwd;
            if (credentials[i] instanceof NameCallback) {
                username = ((NameCallback)credentials[i]).getName();
                if (!debug.messageEnabled()) continue;
                debug.message("FilesRepo:authenticate username: " + username);
                continue;
            }
            if (!(credentials[i] instanceof PasswordCallback) || (passwd = ((PasswordCallback)credentials[i]).getPassword()) == null) continue;
            password = new String(passwd);
            debug.message("FilesRepo:authN passwd present");
        }
        if (username == null || password == null) {
            return false;
        }
        Map attrs = this.searchForAuthN(IdType.USER, username);
        if (attrs == null) {
            attrs = this.searchForAuthN(IdType.AGENT, username);
        }
        if (attrs == null || attrs.isEmpty() || !attrs.containsKey(this.passwordAttribute)) {
            debug.message("FilesRepo:authenticate did not found user/agent");
            return false;
        }
        Set storedPasswords = (Set)attrs.get(this.passwordAttribute);
        if (storedPasswords == null || storedPasswords.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("FilesRepo:authenticate no stored password");
            }
            return false;
        }
        String storedPassword = (String)storedPasswords.iterator().next();
        if (this.hashAttributes.contains(this.passwordAttribute)) {
            password = Hash.hash((String)password);
        }
        if (debug.messageEnabled()) {
            debug.message("FilesRepo:authenticate AuthN of " + username + "=" + password.equals(storedPassword));
        }
        return password.equals(storedPassword);
    }

    private Map searchForAuthN(IdType type, String userName) throws IdRepoException {
        Map attributes = null;
        try {
            attributes = this.getAttributes(null, type, userName);
            if (debug.messageEnabled()) {
                debug.message("FilesRepo:searchForAuthN found " + type.getName() + " entry: " + userName);
            }
        }
        catch (FilesRepoEntryNotFoundException fe) {
            if (debug.messageEnabled()) {
                debug.message("FilesRepo:searchForAuthn did not find " + type.getName() + " entry: " + userName);
            }
        }
        catch (SSOException ssoe) {
            // empty catch block
        }
        return attributes;
    }

    void initDir(String rootDir) throws IdRepoException {
        File root = new File(rootDir);
        if (!root.exists() && !root.mkdirs()) {
            Object[] args = new Object[]{root.getAbsolutePath()};
            throw new IdRepoException("amIdRepo", "309", args);
        }
        if (!root.isDirectory()) {
            Object[] args = new Object[]{root.getAbsolutePath()};
            throw new IdRepoException("amIdRepo", "308", args);
        }
        Set types = supportedOps.keySet();
        Iterator items = types.iterator();
        while (items.hasNext()) {
            File role;
            Object[] args;
            String subDir = ((IdType)items.next()).getName();
            File dir = new File(root, subDir);
            if (!dir.exists() && !dir.mkdir()) {
                args = new String[]{dir.getAbsolutePath()};
                throw new IdRepoException("amIdRepo", "309", args);
            }
            if (!dir.isDirectory()) {
                args = new String[]{dir.getAbsolutePath()};
                throw new IdRepoException("amIdRepo", "308", args);
            }
            if (!subDir.equals(IdType.REALM.getName()) || (role = new File(dir, "ContainerDefaultTemplateRole")).exists()) continue;
            this.writeFile(role, Collections.EMPTY_MAP);
        }
    }

    File constructFile(String rootDir, IdType type, String name) {
        File root = new File(rootDir);
        File subDir = new File(root, type.getName());
        return new File(subDir, name);
    }

    void writeFile(File file, Map values) throws IdRepoException {
        PrintWriter pw = null;
        String fileName = file.getAbsolutePath();
        try {
            SOAPClient client = new SOAPClient();
            String encodedMap = client.encodeMap("result", values);
            pw = new PrintWriter(new FileOutputStream(fileName));
            pw.println(encodedMap);
            identityCache.put(fileName, values);
            this.identityTimeCache.put(fileName, new Long(file.lastModified()));
            identityCache.put(fileName.toLowerCase(), values);
            if (debug.messageEnabled()) {
                debug.message("FilesRepo:writeFile-Identity Cache " + identityCache);
            }
        }
        catch (IOException e) {
            if (debug.messageEnabled()) {
                debug.message("FilesRepo.writeFile: file = " + fileName, (Throwable)e);
            }
            Object[] args = new String[]{NAME, fileName};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    Map readFile(File file) throws IdRepoException {
        String origFileName;
        Map answer = Collections.EMPTY_MAP;
        String fileName = file.getAbsolutePath();
        Long lastModified = (Long)this.identityTimeCache.get(fileName);
        if (lastModified != null && lastModified.longValue() == file.lastModified() && (answer = (Map)identityCache.get(fileName)) != null) {
            return answer;
        }
        Iterator it = identityCache.keySet().iterator();
        while (it.hasNext() && !fileName.equals(origFileName = (String)it.next())) {
            if (!fileName.equalsIgnoreCase(origFileName)) continue;
            fileName = origFileName;
            break;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(fileName));
            StringBuffer encodedMapBuffer = new StringBuffer(200);
            while ((line = br.readLine()) != null) {
                encodedMapBuffer.append(line);
            }
            String encodedMap = encodedMapBuffer.toString();
            SOAPClient client = new SOAPClient();
            Map map = client.decodeMap(encodedMap);
            answer = new CaseInsensitiveHashMap();
            Iterator items = map.keySet().iterator();
            while (items.hasNext()) {
                Object key = items.next();
                Set ovalue = (Set)map.get(key);
                CaseInsensitiveHashSet nvalue = new CaseInsensitiveHashSet();
                nvalue.addAll(ovalue);
                answer.put(key, nvalue);
            }
            this.identityTimeCache.put(fileName, new Long(file.lastModified()));
            identityCache.put(fileName, answer);
        }
        catch (FileNotFoundException fn) {
            if (debug.messageEnabled()) {
                debug.message("FilesRepo.readFile: file not found: " + fileName);
            }
            Object[] args = new String[]{NAME, fileName};
            throw new FilesRepoEntryNotFoundException("amIdRepo", "220", args);
        }
        catch (IOException e) {
            if (debug.messageEnabled()) {
                debug.message("FilesRepo.readFile: error reading file: " + fileName, (Throwable)e);
            }
            Object[] args = new String[]{NAME, fileName};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        finally {
            block18: {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        if (!debug.warningEnabled()) break block18;
                        debug.warning("FilesRepo.redFile: read error: " + fileName, (Throwable)e);
                    }
                }
            }
        }
        return answer;
    }

    public static void clearCache() {
        identityCache = new CaseInsensitiveHashMap();
    }

    static Map processAttributes(Map attrs, Set hashAttrs, Set encAttrs) {
        CaseInsensitiveHashMap answer = new CaseInsensitiveHashMap();
        Iterator items = attrs.keySet().iterator();
        while (items.hasNext()) {
            Iterator i;
            Object key = items.next();
            Set ovalue = (Set)attrs.get(key);
            CaseInsensitiveHashSet nvalue = new CaseInsensitiveHashSet();
            if (hashAttrs.contains(key)) {
                i = ovalue.iterator();
                while (i.hasNext()) {
                    nvalue.add(Hash.hash((String)((String)i.next())));
                }
            } else if (encAttrs.contains(key)) {
                try {
                    i = ovalue.iterator();
                    while (i.hasNext()) {
                        nvalue.add((String)AccessController.doPrivileged(new EncodeAction((String)i.next())));
                    }
                }
                catch (Throwable e) {
                    debug.error("FilesRepo.processAttributes: unable to encode", e);
                }
            } else {
                nvalue.addAll(ovalue);
            }
            answer.put(key, nvalue);
        }
        return answer;
    }

    static Map decodeAttributes(Map attrs, Set encAttrs) {
        if (encAttrs.isEmpty()) {
            return attrs;
        }
        Iterator items = encAttrs.iterator();
        while (items.hasNext()) {
            Object key = items.next();
            Set ovalue = (Set)attrs.get(key);
            if (ovalue == null || ovalue.isEmpty()) continue;
            CaseInsensitiveHashSet nvalue = new CaseInsensitiveHashSet();
            Iterator i = ovalue.iterator();
            while (i.hasNext()) {
                try {
                    nvalue.add((String)AccessController.doPrivileged(new DecodeAction((String)i.next())));
                }
                catch (Throwable e) {
                    debug.error("FilesRepo: unable to decode", e);
                }
            }
            attrs.put(key, nvalue);
        }
        return attrs;
    }

    boolean containsAttrValue(Set attrValues, Set patterns) {
        Iterator ps = patterns.iterator();
        while (ps.hasNext()) {
            String pattern = ps.next().toString();
            if (pattern.indexOf(42) != -1) {
                FileRepoFileFilter ff = new FileRepoFileFilter(pattern);
                Iterator items = attrValues.iterator();
                while (items.hasNext()) {
                    if (!ff.accept(null, items.next().toString())) continue;
                    return true;
                }
                continue;
            }
            if (!attrValues.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    static {
        FilesRepo.loadSupportedOps();
    }

    class CacheUpdateRunnable
    extends GeneralTaskRunnable {
        FilesRepo repo;

        CacheUpdateRunnable(FilesRepo r) {
            this.repo = r;
            debug.message("CacheUpdateRunnable initialized");
        }

        public void run() {
            HashSet fileNames = new HashSet(this.repo.identityTimeCache.keySet());
            Iterator i = fileNames.iterator();
            while (i.hasNext()) {
                String fileName = i.next().toString();
                Long lastModified = (Long)this.repo.identityTimeCache.get(fileName);
                File file = new File(fileName);
                if (file.exists() && lastModified.longValue() == file.lastModified()) continue;
                if (debug.messageEnabled()) {
                    debug.message("CacheUpdateRunnable: File modified: " + fileName);
                }
                identityCache.remove(fileName);
                this.repo.identityTimeCache.remove(fileName);
                if (file.exists()) {
                    this.repo.repoListener.objectChanged(file.getName(), 4, this.repo.repoListener.getConfigMap());
                } else {
                    this.repo.repoListener.objectChanged(file.getName(), 2, this.repo.repoListener.getConfigMap());
                }
                if (!debug.messageEnabled()) continue;
                debug.message("CacheUpdateRunnable: Notification Sent: " + fileName);
            }
        }

        public boolean addElement(Object key) {
            return false;
        }

        public boolean removeElement(Object key) {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }

        public long getRunPeriod() {
            return this.repo.updateCacheInterval * 60 * 1000;
        }
    }

    class FileRepoFileFilter
    implements FilenameFilter {
        Pattern pattern;

        FileRepoFileFilter(String p) {
            if (p != null && p.length() != 0 && !p.equals("*")) {
                int idx = p.indexOf(42);
                while (idx != -1) {
                    p = p.substring(0, idx) + ".*" + p.substring(idx + 1);
                    idx = p.indexOf(42, idx + 2);
                }
                this.pattern = Pattern.compile(p.toLowerCase());
            }
        }

        public boolean accept(File dir, String name) {
            if (this.pattern == null) {
                return true;
            }
            return this.pattern.matcher(name.toLowerCase()).matches();
        }
    }
}

