/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entity;

import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMEntityType;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.entity.EntityException;
import com.sun.identity.entity.EntityObjectIF;
import com.sun.identity.entity.EntityUtils;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class EntityObjectImpl
implements EntityObjectIF {
    protected static Cache oCache;
    protected static Object lock;
    protected SSOToken token;
    protected AMStoreConnection amsc;
    protected AMOrganization entity = null;
    private static SSOTokenManager tokenManager;

    public Set createEntity(String ssotoken, String entityName, String entityType, String entityLocation, Map attributes) throws EntityException, SSOException {
        HashSet<String> entitySet = new HashSet<String>();
        this.initializeObject(ssotoken, entityLocation);
        try {
            int type = 0;
            type = this.getIntTypeFromStr(entityType);
            HashMap<String, Map> input = new HashMap<String, Map>(2);
            input.put(entityName, attributes);
            if (this.entity != null) {
                Set entityObjs = this.entity.createEntities(type, input);
                Iterator it = entityObjs.iterator();
                while (it.hasNext()) {
                    entitySet.add(((AMEntity)it.next()).getDN());
                }
            }
        }
        catch (AMException amex) {
            EntityUtils.debug.error("EntityObjectImpl.createEntity() : Create Entity Failed. " + amex);
            throw EntityUtils.convertException(amex);
        }
        return entitySet;
    }

    public void deleteEntity(String ssoToken, String entityName, String entityType, String entityLocation) throws EntityException, SSOException {
        this.initializeObject(ssoToken, entityLocation);
        HashSet<String> entityNameSet = new HashSet<String>();
        try {
            int type = 0;
            type = this.getIntTypeFromStr(entityType);
            String entDN = this.getEntityDN(entityName, type, entityLocation);
            entityNameSet.add(entDN);
            if (this.entity != null) {
                this.entity.deleteEntities(type, entityNameSet);
                if (EntityUtils.debug.messageEnabled()) {
                    EntityUtils.debug.message("EntityObjectImpl.deleteEntity(): Deleted " + ((Object)entityNameSet).toString());
                }
            }
        }
        catch (AMException amex) {
            EntityUtils.debug.error("EntityObjectImpl.deleteEntity() : Delete Entity Failed. " + amex);
            throw EntityUtils.convertException(amex);
        }
    }

    public Map getEntity(String ssoToken, String entityName, String entityType, String entityLocation) throws EntityException, SSOException, RemoteException {
        this.initializeObject(ssoToken, entityLocation);
        HashMap entityMap = new HashMap();
        return entityMap;
    }

    public Set getEntityNames(String ssoToken, String entityType, String entityLocation, String entityFilter) throws EntityException, SSOException, RemoteException {
        this.initializeObject(ssoToken, entityLocation);
        HashSet entitySet = new HashSet();
        return entitySet;
    }

    public void modifyEntity(String ssoToken, String entityName, String entityType, String entityLocation, Map attributes) throws EntityException, SSOException, RemoteException {
        this.initializeObject(ssoToken, entityLocation);
        AMEntity amEntity = this.getAMEntity(ssoToken, entityName, entityType, entityLocation);
        try {
            if (amEntity != null) {
                amEntity.setAttributes(attributes);
                amEntity.store();
            }
        }
        catch (AMException amex) {
            EntityUtils.debug.error("EntityObjectImpl.modifyEntity() : Modify Entity Failed. " + amex);
            throw EntityUtils.convertException(amex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkInitialization() throws SSOException {
        if (tokenManager == null) {
            Object object = lock;
            synchronized (object) {
                if (tokenManager == null) {
                    try {
                        tokenManager = SSOTokenManager.getInstance();
                        oCache = new Cache(1000);
                    }
                    catch (SSOException ssoe) {
                        EntityUtils.debug.error("EntityObjectImpl:checkInitialization() : Unable to get SSOTokenManager", (Throwable)((Object)ssoe));
                        throw ssoe;
                    }
                }
            }
        }
    }

    protected AMEntity getAMEntity(String ssoToken, String entityName, String entityType, String entityLocation) throws EntityException, SSOException {
        AMEntity amEntity;
        EntityObjectImpl.checkInitialization();
        try {
            int type = 0;
            type = this.getIntTypeFromStr(entityType);
            String entDN = this.getEntityDN(entityName, type, entityLocation);
            String key = ssoToken + "/" + entDN;
            amEntity = (AMEntity)oCache.get(key);
            if (amEntity == null) {
                amEntity = this.amsc.getEntity(entDN);
                oCache.put(key, amEntity);
            }
        }
        catch (SSOException ssoe) {
            EntityUtils.debug.error("EntityObjectImpl.getAMEntity(): Unable to convert SSOToken: " + ssoToken, (Throwable)((Object)ssoe));
            throw ssoe;
        }
        return amEntity;
    }

    protected void initializeObject(String ssoToken, String entityLocation) throws EntityException, SSOException {
        EntityObjectImpl.checkInitialization();
        try {
            this.token = tokenManager.createSSOToken(ssoToken);
            this.amsc = new AMStoreConnection(this.token);
            String orgDN = this.amsc.getOrganizationDN(entityLocation, null);
            this.entity = this.amsc.getOrganization(orgDN);
        }
        catch (AMException amex) {
            EntityUtils.debug.error("EntityObjectImpl.initializeObject() : Unable to get Organization DN " + amex);
            throw EntityUtils.convertException(amex);
        }
        catch (SSOException ssoe) {
            EntityUtils.debug.error("EntityObjectImpl.initializeObject() : Unable to convert SSOToken: " + ssoToken, (Throwable)((Object)ssoe));
            throw ssoe;
        }
        if (EntityUtils.debug.messageEnabled()) {
            EntityUtils.debug.message("EntityObjectImpl.getAMEntity(): Obtained ssotoken: " + ssoToken);
            EntityUtils.debug.message("EntityObjectImpl.getAMEntity(): Obtained AMSToreConnection object for SSOToken: " + ssoToken);
        }
    }

    private int getIntTypeFromStr(String entityType) {
        int type = 0;
        Set supportedTypes = this.amsc.getEntityTypes();
        Iterator iter = supportedTypes.iterator();
        while (iter.hasNext()) {
            AMEntityType amEntityType = (AMEntityType)iter.next();
            if (!amEntityType.getName().equalsIgnoreCase(entityType)) continue;
            type = amEntityType.getType();
            break;
        }
        return type;
    }

    private String getEntityDN(String entityName, int entityType, String entityLocation) throws EntityException, SSOException {
        String entDN = null;
        try {
            Set entityResults = this.entity.searchEntities(entityType, "*", 2, new HashMap());
            Iterator iter = entityResults.iterator();
            while (iter.hasNext() && (entDN = (String)iter.next()).indexOf(entityName) < 0) {
            }
        }
        catch (AMException amex) {
            EntityUtils.debug.error("EntityObjectImpl.getEntityDN() : Unable to get DN for the Entity " + amex);
            throw EntityUtils.convertException(amex);
        }
        return entDN;
    }

    static {
        lock = new Object();
    }
}

