/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.session.model;

import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.SearchResults;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.session.model.SMProfileModel;
import com.sun.identity.console.session.model.SMSessionCache;
import com.sun.identity.sm.SMSException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SMProfileModelImpl
extends AMModelBase
implements SMProfileModel {
    private static final String SERVER_LIST = "iplanet-am-platform-server-list";
    private static final String PLATFORM_SERVICE = "iPlanetAMPlatformService";
    private static final int DEFAULT_PAGE_SIZE = 25;
    public static final String USER_ID = "UserId";
    private SMSessionCache sessionCache;
    private static String DELIMITER = "|";
    private Map serverNamesMap = null;
    private String serverName = null;
    private boolean validSession = true;

    public SMProfileModelImpl(HttpServletRequest request, Map map) {
        super(request, map);
    }

    public void setProfileServerName(String value) {
        this.serverName = value;
    }

    private void initSessionsList(String pattern) throws AMConsoleException {
        pattern = pattern.toLowerCase();
        String[] params = new String[]{this.serverName, pattern};
        this.logEvent("ATTEMPT_GET_CURRENT_SESSIONS", params);
        try {
            Session session = Session.getSession(new SessionID(((Object)this.getUserSSOToken().getTokenID()).toString()));
            SearchResults result = session.getValidSessions(this.serverName, pattern);
            Hashtable sessions = (Hashtable)result.getResultAttributes();
            String errorMessage = AMAdminUtils.getSearchResultWarningMessage(result, this);
            this.sessionCache = new SMSessionCache(sessions.values(), errorMessage, this);
            this.logEvent("SUCCEED_GET_CURRENT_SESSIONS", params);
        }
        catch (SessionException se) {
            String strError = this.getErrorString((Throwable)((Object)se));
            String[] paramsEx = new String[]{this.serverName, pattern, strError};
            this.logEvent("SESSION_EXCEPTION_GET_CURRENT_SESSIONS", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private Session getCurrentSession() throws AMConsoleException {
        Session session = null;
        try {
            session = Session.getSession(new SessionID(((Object)this.getUserSSOToken().getTokenID()).toString()));
        }
        catch (SessionException se) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)se)));
        }
        return session;
    }

    private Map getValidSessions(Session session, String pattern) throws AMConsoleException {
        HashMap<String, Session> sessions = Collections.EMPTY_MAP;
        try {
            SearchResults result = session.getValidSessions(this.serverName, pattern);
            Hashtable validSessions = (Hashtable)result.getResultAttributes();
            if (validSessions != null && !validSessions.isEmpty()) {
                sessions = new HashMap<String, Session>(validSessions.size());
                Iterator iter = validSessions.values().iterator();
                while (iter.hasNext()) {
                    Session s = (Session)((Object)iter.next());
                    if (s == null) continue;
                    sessions.put(s.getID().toString(), s);
                }
            }
        }
        catch (SessionException se) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)se)));
        }
        return sessions;
    }

    public List invalidateSessions(List list, String pattern) throws AMConsoleException {
        ArrayList<String> failList = Collections.EMPTY_LIST;
        if (list != null && !list.isEmpty()) {
            Session session = this.getCurrentSession();
            Map validSessions = this.getValidSessions(session, pattern);
            list.retainAll(validSessions.keySet());
            if (!list.isEmpty()) {
                String currentSessionHandler = null;
                try {
                    currentSessionHandler = session.getProperty("SessionHandle");
                }
                catch (SessionException se) {
                    throw new AMConsoleException(this.getErrorString((Throwable)((Object)se)));
                }
                String[] params = new String[2];
                params[0] = this.serverName;
                String curSessionId = null;
                failList = new ArrayList<String>(list.size());
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String sessionId = (String)iter.next();
                    Session s = (Session)((Object)validSessions.get(sessionId));
                    params[1] = sessionId;
                    boolean isCurrentSession = false;
                    try {
                        isCurrentSession = currentSessionHandler.equals(s.getProperty("SessionHandle"));
                    }
                    catch (SessionException se) {
                        this.logEvent("SESSION_EXCEPTION_INVALIDATE_SESSIONS", params);
                        throw new AMConsoleException(this.getErrorString((Throwable)((Object)se)));
                    }
                    if (isCurrentSession) {
                        curSessionId = sessionId;
                        this.validSession = false;
                        continue;
                    }
                    try {
                        this.logEvent("ATTEMPT_INVALIDATE_SESSIONS", params);
                        session.destroySession(s);
                        this.logEvent("SUCCEED_INVALIDATE_SESSIONS", params);
                    }
                    catch (SessionException se) {
                        String[] paramsEx = new String[]{this.serverName, sessionId, this.getErrorString((Throwable)((Object)se))};
                        this.logEvent("SESSION_EXCEPTION_INVALIDATE_SESSIONS", paramsEx);
                        try {
                            failList.add(s.getProperty(USER_ID));
                        }
                        catch (SessionException e) {
                            debug.error("SMProfileModelImpl.invalidateSessions", (Throwable)((Object)e));
                        }
                        debug.error("SMProfileModelImpl.invalidateSessions", (Throwable)((Object)se));
                    }
                }
                if (!this.validSession) {
                    params[1] = curSessionId;
                    this.logEvent("ATTEMPT_INVALIDATE_SESSIONS", params);
                    try {
                        session.destroySession(session);
                        this.logEvent("SUCCEED_INVALIDATE_SESSIONS", params);
                    }
                    catch (SessionException se) {
                        String[] paramsEx = new String[]{this.serverName, curSessionId, this.getErrorString((Throwable)((Object)se))};
                        this.logEvent("SESSION_EXCEPTION_INVALIDATE_SESSIONS", paramsEx);
                    }
                }
            }
        }
        return failList;
    }

    public boolean isSessionValid() {
        return this.validSession;
    }

    private boolean isSessionsEquals(Session session, Session sess) {
        boolean isCurrentSession = false;
        try {
            String currentSessionHandler = session.getProperty("SessionHandle");
            isCurrentSession = currentSessionHandler.equals(sess.getProperty("SessionHandle"));
        }
        catch (SessionException se) {
            debug.error("Could not determined if the sessions are same ", (Throwable)((Object)se));
        }
        return isCurrentSession;
    }

    public SMSessionCache getSessionCache(String pattern) throws AMConsoleException {
        if (this.sessionCache == null) {
            this.initSessionsList(pattern);
        }
        return this.sessionCache;
    }

    public void setSessionCache(SMSessionCache cache) {
        this.sessionCache = cache;
    }

    public Map getServerNames() {
        if (this.serverNamesMap == null || this.serverNamesMap.isEmpty()) {
            try {
                Set names = ServerConfiguration.getServerInfo(this.getUserSSOToken());
                names = this.parseServerNames(names);
                this.serverNamesMap = this.getMapValues(names);
            }
            catch (SSOException e) {
                debug.error("SMProfileModelImpl.getServerNames", (Throwable)((Object)e));
            }
            catch (SMSException e) {
                debug.error("SMProfileModelImpl.getServerNames", (Throwable)e);
            }
        }
        return this.serverNamesMap;
    }

    private Set parseServerNames(Set servers) {
        HashSet<String> serverList = new HashSet<String>();
        Iterator iter = servers.iterator();
        while (iter.hasNext()) {
            String serverEntry = (String)iter.next();
            int index = serverEntry.indexOf(DELIMITER);
            if (index != -1) {
                String server = serverEntry.substring(0, index);
                serverList.add(server);
                continue;
            }
            if (!debug.warningEnabled()) continue;
            debug.warning("SMProfileModelImpl.parseServerNames:This server entry is not proper, ignoring:" + serverEntry);
        }
        return serverList;
    }

    private Map getMapValues(Set set) {
        HashMap<String, String> map = Collections.EMPTY_MAP;
        if (set != null && !set.isEmpty()) {
            Iterator iter = set.iterator();
            map = new HashMap<String, String>(set.size() * 2);
            while (iter.hasNext()) {
                String url = (String)iter.next();
                try {
                    URL u = new URL(url);
                    String host = u.getHost();
                    int port = u.getPort();
                    if (port == -1) {
                        map.put(host, url);
                        continue;
                    }
                    String server = host + ":" + port;
                    map.put(server, url);
                }
                catch (MalformedURLException e) {
                    debug.error("SMProfileModelImpl.getMapValues", (Throwable)e);
                }
            }
        }
        return map;
    }
}

