/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.service.model.SCConfigModel;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SCConfigModelImpl
extends AMModelBase
implements SCConfigModel {
    private static String[] sectionNames = new String[]{"Authentication", "Console", "Global", "System"};
    private static ResourceBundle rbServiceTable = ResourceBundle.getBundle("amServiceTable");
    private Map mapSectionNameToServiceNames = new HashMap(sectionNames.length * 2);
    private Map mapServiceNameToLocalizedName = new HashMap();

    public SCConfigModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
        this.getServiceNames();
        this.getL10NServiceNames();
        this.sortServiceNames();
    }

    public String getServicePropertiesViewBeanURL(String serviceName) {
        if ("iPlanetAMPolicyConfigService".equals(serviceName)) {
            return "../service/SCPolicy";
        }
        return super.getServicePropertiesViewBeanURL(serviceName);
    }

    public List getServiceNames(String sectionName) {
        return (List)this.mapSectionNameToServiceNames.get(sectionName);
    }

    public String getLocalizedServiceName(String serviceName) {
        return (String)this.mapServiceNameToLocalizedName.get(serviceName);
    }

    private void getServiceNames() {
        block7: {
            try {
                ServiceManager sm = new ServiceManager(this.getUserSSOToken());
                Set serviceNames = sm.getServiceNames();
                Set authServices = AMAuthenticationManager.getAuthenticationServiceNames();
                if (serviceNames == null) break block7;
                Iterator i = serviceNames.iterator();
                while (i.hasNext()) {
                    String svcName = (String)i.next();
                    String sectionName = null;
                    try {
                        sectionName = rbServiceTable.getString(svcName);
                    }
                    catch (MissingResourceException e) {
                        sectionName = authServices.contains(svcName) ? "Authentication" : "Global";
                    }
                    if (sectionName.equals(".")) continue;
                    ArrayList<String> list = (ArrayList<String>)this.mapSectionNameToServiceNames.get(sectionName);
                    if (list == null) {
                        list = new ArrayList<String>(20);
                        this.mapSectionNameToServiceNames.put(sectionName, list);
                    }
                    list.add(svcName);
                }
            }
            catch (SSOException ssoe) {
                debug.error("SCConfigModelImpl.getServiceNames", (Throwable)((Object)ssoe));
            }
            catch (SMSException smse) {
                debug.error("SCConfigModelImpl.getServiceNames", (Throwable)smse);
            }
        }
    }

    private void getL10NServiceNames() {
        Iterator i = this.mapSectionNameToServiceNames.keySet().iterator();
        while (i.hasNext()) {
            String sectionName = (String)i.next();
            List list = (List)this.mapSectionNameToServiceNames.get(sectionName);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String svcName = (String)iter.next();
                String i18nName = super.getLocalizedServiceName(svcName, null);
                if (i18nName != null) {
                    this.mapServiceNameToLocalizedName.put(svcName, i18nName);
                    continue;
                }
                iter.remove();
            }
        }
    }

    private void sortServiceNames() {
        Iterator i = this.mapSectionNameToServiceNames.keySet().iterator();
        while (i.hasNext()) {
            String sectionName = (String)i.next();
            List list = (List)this.mapSectionNameToServiceNames.get(sectionName);
            HashMap<String, String> map = new HashMap<String, String>(list.size() * 2);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String svcName = (String)iter.next();
                map.put(this.getLocalizedServiceName(svcName), svcName);
            }
            List sorted = AMFormatUtils.sortKeyInMap(map, this.getUserLocale());
            ArrayList sortedList = new ArrayList(list.size());
            Iterator iter2 = sorted.iterator();
            while (iter2.hasNext()) {
                String localizedName = (String)iter2.next();
                sortedList.add(map.get(localizedName));
            }
            this.mapSectionNameToServiceNames.put(sectionName, sortedList);
        }
    }

    public boolean hasConfigAttributes(String serviceName) {
        Set o = AMAdminUtils.getDisplayableAttributeNames(serviceName, SchemaType.ORGANIZATION);
        Set d = AMAdminUtils.getDisplayableAttributeNames(serviceName, SchemaType.DYNAMIC);
        Set g = AMAdminUtils.getDisplayableAttributeNames(serviceName, SchemaType.GLOBAL);
        return !o.isEmpty() || !d.isEmpty() || !g.isEmpty();
    }
}

