/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.DefaultClientTypesManager;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AMResBundleCacher;
import com.sun.identity.console.service.model.MAPModel;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.util.DN;

public abstract class MAPModelBase
extends AMModelBase
implements MAPModel {
    private static char[] invalidCharacters = new char[DN.ESCAPED_CHAR.length + 5];
    DefaultClientTypesManager clientTypesManager = (DefaultClientTypesManager)AMClientDetector.getClientTypesManagerInstance();
    String mapServiceName;
    private AMClientCapData clientCapDataIntInstance = null;
    private AMClientCapData clientCapDataExtInstance = null;
    private ResourceBundle serviceResourceBundle = null;

    MAPModelBase(HttpServletRequest req, Map map) {
        super(req, map);
        this.initClientCapDataInstance();
        this.getServiceResourceBundle();
    }

    private void initClientCapDataInstance() {
        try {
            this.clientCapDataExtInstance = AMClientCapData.getExternalInstance();
            this.clientCapDataIntInstance = AMClientCapData.getInternalInstance();
            this.mapServiceName = this.clientCapDataIntInstance.getServiceName();
        }
        catch (AMClientCapException e) {
            debug.error("MAPModelBase.initClientCapDataInstance", (Throwable)e);
        }
    }

    private void getServiceResourceBundle() {
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(this.mapServiceName, this.getUserSSOToken());
            String name = scm.getI18NFileName();
            if (name != null && name.length() > 0) {
                this.serviceResourceBundle = AMResBundleCacher.getBundle(name, this.getUserLocale());
            }
        }
        catch (SMSException e) {
            debug.warning("MAPModelBase.getServiceResourceBundle", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("MAPModelBase.getServiceResourceBundle", (Throwable)((Object)e));
        }
    }

    protected static String canonicalize(String str) {
        for (int i = 0; i < invalidCharacters.length; ++i) {
            str = str.replace(invalidCharacters[i], '_');
        }
        return str;
    }

    protected static boolean isClientTypeValid(String userAgent) {
        boolean valid = true;
        for (int i = 0; i < invalidCharacters.length && valid; ++i) {
            valid = userAgent.indexOf(invalidCharacters[i]) == -1;
        }
        return valid;
    }

    protected AMClientCapData getClientCapDataIntInstance() {
        return this.clientCapDataIntInstance;
    }

    protected AMClientCapData getClientCapDataExtInstance() {
        return this.clientCapDataExtInstance;
    }

    protected AMClientCapData getClientCapDataInstance(String clientType) {
        Map temp = this.clientCapDataIntInstance.getProperties(clientType);
        return temp != null ? this.clientCapDataIntInstance : this.clientCapDataExtInstance;
    }

    public Set getStyleNames(String name) {
        return this.clientTypesManager != null ? this.clientTypesManager.getStyles(name) : Collections.EMPTY_SET;
    }

    protected String getL10NStrFromSvcResourceBundle(String key) {
        return this.serviceResourceBundle != null ? Locale.getString((ResourceBundle)this.serviceResourceBundle, (String)key, (Debug)debug) : key;
    }

    protected AttributeSchema getDeviceAttributeSchema(String name) {
        AttributeSchema as = null;
        if (this.clientCapDataIntInstance != null && this.clientCapDataExtInstance != null) {
            String i18nKey;
            as = this.clientCapDataIntInstance.getAttributeSchema(name);
            if (as == null) {
                as = this.clientCapDataExtInstance.getAttributeSchema(name);
            }
            if (as != null && ((i18nKey = as.getI18NKey()) == null || i18nKey.length() == 0)) {
                as = null;
            }
        }
        return as;
    }

    protected Set getAdditionalPropertyValues(String clientType) {
        Set values = Collections.EMPTY_SET;
        Client client = this.clientTypesManager.getClientInstance(clientType);
        if (client != null) {
            values = client.getAdditionalProperties();
        }
        return values;
    }

    protected boolean isUserAgentSet(String clientType) {
        boolean isSet = true;
        AMClientCapData ccd = this.getClientCapDataInstance(clientType);
        Map map = ccd.getProperties(clientType);
        if (map != null) {
            isSet = map.get("userAgent") != null;
        }
        return isSet;
    }

    public boolean isCustomizable(String clientType) {
        return this.clientCapDataExtInstance.isClientPresent(clientType);
    }

    public boolean hasDefaultSetting(String clientType) {
        return this.clientCapDataExtInstance.isClientPresent(clientType) && this.clientCapDataIntInstance.isClientPresent(clientType);
    }

    public boolean canBeDeleted(String clientType) {
        return !this.clientCapDataIntInstance.isClientPresent(clientType);
    }

    public String getDeviceUserAgent(String clientType) {
        String value = null;
        AMClientCapData ccd = this.getClientCapDataInstance(clientType);
        Map map = ccd.getProperties(clientType);
        if (map != null) {
            value = (String)AMAdminUtils.getValue((Set)map.get("userAgent"));
        }
        return value;
    }

    public String getClientTypePrefix() {
        return this.getLocalizedString("mapCloneClient.prefix");
    }

    public String getDeviceNamePrefix() {
        return this.getLocalizedString("mapCloneClient.name");
    }

    static {
        for (int i = 0; i < DN.ESCAPED_CHAR.length; ++i) {
            MAPModelBase.invalidCharacters[i] = DN.ESCAPED_CHAR[i];
        }
        MAPModelBase.invalidCharacters[i++] = 32;
        MAPModelBase.invalidCharacters[i++] = 47;
        MAPModelBase.invalidCharacters[i++] = 58;
        MAPModelBase.invalidCharacters[i++] = 61;
        MAPModelBase.invalidCharacters[i] = 92;
    }
}

