/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service.model;

import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.console.service.model.MAPDeviceProfileModel;
import com.sun.identity.console.service.model.MAPModelBase;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPDeviceProfileModelImpl
extends MAPModelBase
implements MAPDeviceProfileModel {
    private Set createDeviceReqAttrs = null;
    private Map createDeviceDefaultValues = null;

    public MAPDeviceProfileModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public String[] getAttributeClassification(String clientType) {
        AMClientCapData ccd = this.getClientCapDataInstance(clientType);
        return ccd != null ? ccd.getClassifications() : null;
    }

    public Map getLocalizedClassificationLabels(String[] classifications) {
        HashMap<String, String> map = new HashMap<String, String>(classifications.length * 2);
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(this.mapServiceName, this.getUserSSOToken());
            ServiceSchema schema = mgr.getSchema(SchemaType.GLOBAL);
            for (int i = 0; i < classifications.length; ++i) {
                String name = classifications[i];
                AttributeSchema as = schema.getAttributeSchema(name);
                String i18nKey = as.getI18NKey();
                if (i18nKey != null && i18nKey.trim().length() > 0) {
                    map.put(name, this.getL10NStrFromSvcResourceBundle(i18nKey));
                    continue;
                }
                map.put(name, name);
            }
        }
        catch (SSOException e) {
            debug.warning("MAPDeviceProfileModelImpl.getLocalizedClassificationLabels", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("MAPDeviceProfileModelImpl.getLocalizedClassificationLabels", (Throwable)e);
        }
        return map;
    }

    public String getProfilePropertyXML(String clientType, String classification) throws AMConsoleException {
        String xml = "";
        Set attributeNames = this.getAttributeNames(clientType, classification);
        Set attributeSchemas = this.getAttributeSchemas(attributeNames);
        try {
            PropertyXMLBuilder builder = new PropertyXMLBuilder(this.mapServiceName, (AMModel)this, attributeSchemas);
            xml = builder.getXML(this.getReadOnlyAttributeNames(clientType, attributeNames));
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        return xml;
    }

    public Set getReadOnlyAttributeNames(String clientType, Set attributeNames) {
        boolean readOnlyProfile;
        HashSet<String> readonly = new HashSet<String>(attributeNames.size() * 2);
        Map temp = this.getClientCapDataIntInstance().getProperties(clientType);
        boolean bl = readOnlyProfile = temp != null && !this.isUserAgentSet(clientType);
        if (readOnlyProfile) {
            readonly.addAll(attributeNames);
        } else {
            Iterator iter = attributeNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (!name.equals("clientType") && !name.equals("userAgent")) continue;
                readonly.add(name);
            }
        }
        return readonly;
    }

    private Set getAttributeNames(String clientType, String classification) {
        Set names = null;
        AMClientCapData ccd = this.getClientCapDataInstance(clientType);
        if (ccd != null) {
            names = ccd.getPropertyNames(classification);
        }
        return names == null ? Collections.EMPTY_SET : names;
    }

    private Set getAttributeSchemas(Set names) {
        HashSet<AttributeSchema> results = new HashSet<AttributeSchema>(names.size() * 2);
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            AttributeSchema as = this.getDeviceAttributeSchema(name);
            if (as == null) continue;
            results.add(as);
        }
        return results;
    }

    public Map getAttributeValues(String clientType, String classification) {
        String[] params = new String[]{clientType, classification};
        this.logEvent("ATTEMPT_CLIENT_DETECTION_GET_CLIENT_PROFILE", params);
        Set attributeNames = this.getAttributeNames(clientType, classification);
        HashMap attributeValues = new HashMap(attributeNames.size() * 2);
        if (classification.equals("additionalPropertiesNames")) {
            HashSet<String> values = this.getAdditionalPropertyValues(clientType);
            if (values == null || values.isEmpty()) {
                values = new HashSet<String>(1);
                values.add("");
            }
            String attrName = (String)attributeNames.iterator().next();
            attributeValues = new HashMap(2);
            attributeValues.put(attrName, values);
        } else {
            Client client = this.clientTypesManager.getClientInstance(clientType);
            if (client != null) {
                Iterator i = attributeNames.iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    HashSet<String> values = client.getProperties(name);
                    if (values == null || values.isEmpty()) {
                        values = Collections.EMPTY_SET;
                        AttributeSchema as = this.getDeviceAttributeSchema(name);
                        if (as.getSyntax().equals(AttributeSchema.Syntax.BOOLEAN)) {
                            values = new HashSet<String>(2);
                            values.add("false");
                        }
                    }
                    attributeValues.put(name, values);
                }
            }
        }
        this.logEvent("SUCCEED_CLIENT_DETECTION_GET_CLIENT_PROFILE", params);
        return attributeValues != null ? attributeValues : Collections.EMPTY_MAP;
    }

    public void modifyProfile(String clientType, Map attributeValues) throws AMConsoleException {
        String[] param = new String[]{clientType};
        this.logEvent("ATTEMPT_CLIENT_DETECTION_MODIFY_CLIENT_PROFILE", param);
        Set readonly = this.getReadOnlyAttributeNames(clientType, attributeValues.keySet());
        HashMap values = new HashMap(attributeValues.size());
        Iterator i = attributeValues.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (readonly.contains(name)) continue;
            values.put(name, attributeValues.get(name));
        }
        if (!values.isEmpty()) {
            HashSet<String> set = new HashSet<String>(2);
            set.add(clientType);
            values.put("clientType", set);
            try {
                this.clientTypesManager.modifyClientExternal(this.getUserSSOToken(), values);
                this.logEvent("SUCCEED_CLIENT_DETECTION_MODIFY_CLIENT_PROFILE", param);
            }
            catch (AMClientCapException e) {
                String strError = this.getErrorString(e);
                String[] paramsEx = new String[]{clientType, strError};
                this.logEvent("CLIENT_SDK_EXCEPTION_CLIENT_DETECTION_CREATE_CLIENT", paramsEx);
                debug.warning("MAPDeviceProfileModelImpl.modifyProfile", (Throwable)e);
                throw new AMConsoleException(strError);
            }
        }
    }
}

