/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.service.ServerEditViewBeanBase;
import com.sun.identity.console.service.ServerSiteViewBean;
import com.sun.identity.console.service.model.ServerSiteModel;
import com.sun.identity.console.service.model.ServerSiteModelImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import com.sun.web.ui.view.tabs.CCTabs;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class ServerEditAdvancedViewBean
extends AMPrimaryMastHeadViewBean {
    private static final String DEFAULT_DISPLAY_URL = "/console/service/ServerEditAdvanced.jsp";
    private static final String PROPERTIES = "properties";
    private static final String TBL_PROPERTIES = "tblAdvancedProperties";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_COL_VALUE = "tblColValue";
    private static final String TBL_DATA_VALUE = "tblDataValue";
    private static final String PGTITLE_THREE_BTNS = "pgtitleThreeBtns";
    private static Set dealtWithProperties;
    private static Set hiddenProperties;
    private CCPageTitleModel ptModel;
    private CCActionTableModel tblModel;
    private boolean submitCycle;
    private Set properties;
    static /* synthetic */ Class class$com$sun$identity$console$service$ServerEditAdvancedViewBean;

    public ServerEditAdvancedViewBean() {
        super("ServerEditAdvanced");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String serverName;
        if (!this.initialized && (serverName = (String)this.getPageSessionAttribute("pgAttrServerName")) != null) {
            super.initialize();
            this.createPageTitleModel();
            this.createTabModel(serverName);
            this.createTableModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PROPERTIES, CCTextField.class);
        this.registerChild(PGTITLE_THREE_BTNS, CCPageTitle.class);
        this.registerChild(TBL_PROPERTIES, CCActionTable.class);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_THREE_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTIES) ? new CCTextField((ContainerView)this, name, (Object)"") : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : (name.equals(TBL_PROPERTIES) ? new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name) : super.createChild(name)))));
        return view;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new ServerSiteModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        this.ptModel.setPageTitleText(model.getEditServerPageTitle(serverName));
        this.getProperties();
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    protected void createTabModel() {
        if (this.tabModel == null) {
            AMViewConfig amconfig = AMViewConfig.getInstance();
            this.tabModel = amconfig.getTabsModel("cscGeneral", "/", this.getRequestContext().getRequest());
            this.registerChild("tabCommon", CCTabs.class);
        }
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblServerConfigAdvanced.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"table.serverconfig.advanced.properties.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_DELETE, (Object)"table.serverconfig.advanced.properties.button.delete");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.serverconfig.advanced.properties.name.column.name");
        this.tblModel.setActionValue(TBL_COL_VALUE, (Object)"table.serverconfig.advanced.properties.value.column.name");
    }

    protected void createTabModel(String serverName) {
        AMViewConfig amconfig = AMViewConfig.getInstance();
        this.tabModel = amconfig.getTabsModel("cscGeneral", "/", this.getRequestContext().getRequest());
        if (serverName.equals("server-default")) {
            CCNavNode node = (CCNavNode)this.tabModel.getNodeById(425);
            this.tabModel.removeNode((CCNavNodeInterface)node);
        }
        this.registerChild("tabCommon", CCTabs.class);
    }

    private void getProperties() {
        if (!this.submitCycle) {
            try {
                ServerSiteModel model = (ServerSiteModel)this.getModel();
                String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
                this.properties = new TreeSet();
                Map map = model.getServerConfiguration(serverName);
                this.discardDealtWithProperties(map);
                this.discardHiddenProperties(map);
                Iterator i = map.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    this.properties.add((String)entry.getKey() + "=" + (String)entry.getValue());
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        this.populateTableModel(this.properties);
    }

    private void discardDealtWithProperties(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!dealtWithProperties.contains(entry.getKey())) continue;
            i.remove();
        }
    }

    private void discardHiddenProperties(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!hiddenProperties.contains(entry.getKey())) continue;
            i.remove();
        }
    }

    private void populateTableModel(Set properties) {
        this.tblModel.clearAll();
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        if (properties == null || properties.isEmpty()) {
            properties = new HashSet<String>(2);
            properties.add("=");
        }
        int counter = 0;
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            if (counter > 0) {
                this.tblModel.appendRow();
            }
            String t = (String)iter.next();
            int idx = t.indexOf(61);
            String name = t.substring(0, idx).trim();
            String value = t.substring(idx + 1).trim();
            this.tblModel.setValue(TBL_DATA_NAME, (Object)name);
            this.tblModel.setValue(TBL_DATA_VALUE, (Object)value);
            this.tblModel.setSelectionVisible(counter, true);
            ++counter;
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) throws ModelControlException {
        this.returnToHomePage();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        String valProperties = (String)this.getDisplayFieldValue(PROPERTIES);
        this.properties = new HashSet();
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(valProperties, "\n");
        while (st.hasMoreElements()) {
            String t = st.nextToken();
            t = t.replaceAll("\r", "");
            int idx = t.indexOf(61);
            String name = t.substring(0, idx).trim();
            String value = t.substring(idx + 1).trim();
            this.properties.add(t);
            map.put(name, value);
        }
        ServerSiteModel model = (ServerSiteModel)this.getModel();
        String serverName = (String)this.getPageSessionAttribute("pgAttrServerName");
        try {
            Map origValues = model.getServerConfiguration(serverName);
            this.discardDealtWithProperties(origValues);
            String unkownPropertyMessage = null;
            try {
                model.modifyServer(serverName, null, map);
            }
            catch (UnknownPropertyNameException ex) {
                unkownPropertyMessage = ex.getL10NMessage(model.getUserLocale());
            }
            Iterator i = origValues.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!map.containsKey(key)) continue;
                i.remove();
            }
            if (!origValues.isEmpty()) {
                model.updateServerConfigInheritance(serverName, origValues.keySet(), null);
            }
            if (unkownPropertyMessage != null) {
                Object[] args = new Object[]{unkownPropertyMessage};
                this.setInlineAlertMessage("warning", "message.warning", MessageFormat.format(model.getLocalizedString("serverconfig.updated.with.invalid.properties"), args));
            } else {
                this.setInlineAlertMessage("info", "message.information", "serverconfig.updated");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    private void returnToHomePage() {
        this.backTrail();
        ServerSiteViewBean vb = (ServerSiteViewBean)this.getViewBean(ServerSiteViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.editserver";
    }

    protected boolean startPageTrail() {
        return false;
    }

    protected String getBackButtonLabel() {
        return this.getBackButtonLabel("page.title.serversite.config");
    }

    public void nodeClicked(RequestInvocationEvent event, int nodeID) {
        AMViewConfig amconfig = AMViewConfig.getInstance();
        try {
            AMViewBeanBase vb = this.getTabNodeAssociatedViewBean("cscGeneral", nodeID);
            this.unlockPageTrailForSwapping();
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            debug.error("ServerEditGeneralViewBean.nodeClicked", (Throwable)e);
            this.forwardTo();
        }
    }

    protected String getTrackingTabIDName() {
        return "CCTabs.serverConfig";
    }

    private static void getHiddenProperties() {
        hiddenProperties = new HashSet();
        ResourceBundle rb = ResourceBundle.getBundle("hiddenserverconfig");
        String hidden = rb.getString("hidden");
        StringTokenizer st = new StringTokenizer(hidden, " ");
        while (st.hasMoreTokens()) {
            hiddenProperties.add(st.nextToken().trim());
        }
    }

    private static void getDealtWithProperties(Set uiXML) {
        dealtWithProperties = new HashSet();
        Iterator i = uiXML.iterator();
        while (i.hasNext()) {
            String xml = (String)i.next();
            String is = AMAdminUtils.getStringFromInputStream((class$com$sun$identity$console$service$ServerEditAdvancedViewBean == null ? ServerEditAdvancedViewBean.class$("com.sun.identity.console.service.ServerEditAdvancedViewBean") : class$com$sun$identity$console$service$ServerEditAdvancedViewBean).getClassLoader().getResourceAsStream("com/sun/identity/console/" + xml));
            Set set = ServerEditViewBeanBase.getAllConfigUINames(is);
            Iterator j = set.iterator();
            while (j.hasNext()) {
                dealtWithProperties.add(ServerEditViewBeanBase.getActualPropertyName((String)j.next()));
            }
        }
    }

    static {
        HashSet<String> set = new HashSet<String>(12);
        set.add("propertyServerEditSecurity.xml");
        set.add("propertyServerEditSession.xml");
        set.add("propertyServerEditAdvanced.xml");
        set.add("propertyServerEditSDK.xml");
        set.add("propertyServerEditGeneral.xml");
        ServerEditAdvancedViewBean.getDealtWithProperties(set);
        ServerEditAdvancedViewBean.getHiddenProperties();
    }
}

