/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.service;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.service.MAPClientManagerViewBean;
import com.sun.identity.console.service.model.MAPDeviceProfileModel;
import com.sun.identity.console.service.model.MAPDeviceProfileModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.masthead.CCSecondaryMasthead;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class MAPDeviceProfileViewBean
extends AMViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/service/MAPDeviceProfile.jsp";
    private static final String SEC_MH_COMMON = "secMhCommon";
    private static final String PGTITLE = "pgtitle";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String SINGLECHOICE_CLASSIFICATION = "singleChoiceClassification";
    private static final String BTN_CLASSIFICATION = "btnClassification";
    private static final String TF_CLASSIFICATION = "tfClassification";
    static final String TF_DEVICE_NAME = "tfDeviceName";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;
    private boolean submitCycle = false;
    String deviceName;

    public MAPDeviceProfileViewBean() {
        super("MAPDeviceProfile");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        if (!this.initialized) {
            this.initialized = this.createPropertyModel();
            if (this.initialized) {
                super.initialize();
                this.createPageTitleModel();
                this.registerChildren();
            }
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE, CCPageTitle.class);
        this.registerChild(SEC_MH_COMMON, CCSecondaryMasthead.class);
        this.registerChild(TF_DEVICE_NAME, CCTextField.class);
        this.registerChild(TF_CLASSIFICATION, CCTextField.class);
        this.registerChild(SINGLECHOICE_CLASSIFICATION, CCDropDownMenu.class);
        this.registerChild(BTN_CLASSIFICATION, CCButton.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(SEC_MH_COMMON) ? new CCSecondaryMasthead((ContainerView)this, name) : (name.equals(PGTITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name)))));
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    private boolean createPropertyModel() {
        boolean init;
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        if (this.deviceName == null || this.deviceName.trim().length() == 0) {
            this.deviceName = req.getParameter("MAPDeviceProfile.tfDeviceName");
        }
        boolean bl = init = this.deviceName != null && this.deviceName.trim().length() > 0;
        if (init) {
            String classification = req.getParameter("MAPDeviceProfile.tfClassification");
            if (classification == null || classification.trim().length() == 0) {
                classification = "generalPropertyNames";
            }
            this.createPropertyModel(this.deviceName, classification);
        }
        return init;
    }

    private void createPropertyModel(String deviceName, String classification) {
        MAPDeviceProfileModel model = (MAPDeviceProfileModel)this.getModel();
        try {
            this.propertySheetModel = new AMPropertySheetModel(model.getProfilePropertyXML(deviceName, classification));
            this.propertySheetModel.clear();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.setDisplayFieldValue(TF_DEVICE_NAME, this.deviceName);
        this.ptModel.setPageTitleText(this.deviceName);
        this.initializedClassificationDropDownList();
        MAPDeviceProfileModel model = (MAPDeviceProfileModel)this.getModel();
        Map attributeValues = model.getAttributeValues(this.deviceName, (String)this.getDisplayFieldValue(TF_CLASSIFICATION));
        Set attributeNames = !this.submitCycle ? attributeValues.keySet() : model.getReadOnlyAttributeNames(this.deviceName, attributeValues.keySet());
        Iterator iter = attributeNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.propertySheetModel.setValues(name, ((Set)attributeValues.get(name)).toArray(), model);
        }
    }

    private void initializedClassificationDropDownList() {
        MAPDeviceProfileModel model = (MAPDeviceProfileModel)this.getModel();
        String[] classification = model.getAttributeClassification(this.deviceName);
        if (classification != null) {
            Map localizedLabels = model.getLocalizedClassificationLabels(classification);
            OptionList optList = new OptionList();
            for (int i = 0; i < classification.length; ++i) {
                String c = classification[i];
                String label = (String)localizedLabels.get(c);
                if (label == null || label.trim().length() == 0) {
                    label = c;
                }
                optList.add(label, c);
            }
            CCDropDownMenu cb = (CCDropDownMenu)this.getChild(SINGLECHOICE_CLASSIFICATION);
            cb.setOptions(optList);
            String value = (String)cb.getValue();
            if (value == null || value.length() == 0) {
                cb.setValue((Object)classification[0]);
                this.setDisplayFieldValue(TF_CLASSIFICATION, classification[0]);
            } else {
                this.setDisplayFieldValue(TF_CLASSIFICATION, value);
            }
        }
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new MAPDeviceProfileModelImpl(req, this.getPageSessionAttributes());
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.propertySheetModel.clear();
        this.forwardTo();
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.returnToMainPage();
    }

    private void returnToMainPage() {
        MAPClientManagerViewBean vb = (MAPClientManagerViewBean)this.getViewBean(MAPClientManagerViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleBtnClassificationRequest(RequestInvocationEvent event) {
        this.setDisplayFieldValue(SINGLECHOICE_CLASSIFICATION, this.getDisplayFieldValue(TF_CLASSIFICATION));
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
        MAPDeviceProfileModel model = (MAPDeviceProfileModel)this.getModel();
        this.deviceName = (String)this.getDisplayFieldValue(TF_DEVICE_NAME);
        Map orig = model.getAttributeValues(this.deviceName, (String)this.getDisplayFieldValue(TF_CLASSIFICATION));
        try {
            Map values = ps.getAttributeValues(orig, true, model);
            model.modifyProfile(this.deviceName, values);
            this.setInlineAlertMessage("info", "message.information", "message.updated");
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }
}

