/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.components.view.html.SerializedField;
import com.sun.identity.console.realm.HasEntitiesTabs;
import com.sun.identity.console.realm.RMRealmAddViewBean;
import com.sun.identity.console.realm.RMRealmViewBeanBase;
import com.sun.identity.console.realm.model.RMRealmModel;
import com.sun.identity.console.realm.model.RMRealmModelImpl;
import com.sun.identity.sm.SMSSchema;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class RMRealmViewBean
extends RMRealmViewBeanBase
implements HasEntitiesTabs {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/RMRealm.jsp";
    private static final String TBL_SEARCH = "tblSearch";
    private static final String TF_FILTER = "tfFilter";
    private static final String BTN_SEARCH = "btnSearch";
    private static final String TBL_BUTTON_ADD = "tblButtonAdd";
    private static final String TBL_BUTTON_DELETE = "tblButtonDelete";
    private static final String TBL_COL_NAME = "tblColName";
    private static final String TBL_DATA_ACTION_HREF = "tblDataActionHref";
    private static final String TBL_DATA_NAME = "tblDataName";
    private static final String TBL_COL_PATH = "tblColPath";
    private static final String TBL_DATA_PATH = "tblDataPath";
    private static final String PAGETITLE = "pgtitle";
    private CCActionTableModel tblModel = null;
    private CCPageTitleModel ptModel;

    public RMRealmViewBean() {
        super("RMRealm");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createTableModel();
        this.ptModel = new CCPageTitleModel(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/simplePageTitle.xml"));
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(TF_FILTER, CCTextField.class);
        this.registerChild(BTN_SEARCH, CCButton.class);
        this.registerChild(PAGETITLE, CCPageTitle.class);
        this.registerChild(TBL_SEARCH, CCActionTable.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.tblModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(TBL_SEARCH)) {
            SerializedField szCache = (SerializedField)this.getChild("szCache");
            this.populateTableModel((List)szCache.getSerializedObj());
            view = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.tblModel, name);
        } else {
            view = name.equals(PAGETITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (this.tblModel.isChildSupported(name) ? this.tblModel.createChild((View)this, name) : super.createChild(name));
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetButtonState(TBL_BUTTON_DELETE);
        this.getRealmNames();
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new RMRealmModelImpl(req, this.getPageSessionAttributes());
    }

    private void createTableModel() {
        this.tblModel = new CCActionTableModel(this.getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/tblRMRealm.xml"));
        this.tblModel.setTitleLabel("label.items");
        this.tblModel.setActionValue(TBL_BUTTON_ADD, (Object)"table.realm.button.new");
        this.tblModel.setActionValue(TBL_BUTTON_DELETE, (Object)"table.realm.button.delete");
        this.tblModel.setActionValue(TBL_COL_NAME, (Object)"table.realm.name.column.name");
        this.tblModel.setActionValue(TBL_COL_PATH, (Object)"table.realm.path.column.name");
    }

    private void getRealmNames() {
        RMRealmModel model = (RMRealmModel)this.getModel();
        String filter = (String)this.getDisplayFieldValue(TF_FILTER);
        if (filter == null || filter.length() == 0) {
            filter = "*";
            this.setDisplayFieldValue(TF_FILTER, "*");
        } else {
            filter = filter.trim();
        }
        try {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            this.populateTableModel(model.getRealmNames(curRealm, filter));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void populateTableModel(Collection realmNames) {
        this.tblModel.clearAll();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        RMRealmModel model = (RMRealmModel)this.getModel();
        this.tblModel.setMaxRows(model.getPageSize());
        if (realmNames != null && !realmNames.isEmpty()) {
            String curRealm = (String)this.getPageSessionAttribute("currentRealm");
            ArrayList<String> cache = new ArrayList<String>(realmNames.size());
            boolean firstEntry = true;
            String startDN = model.getStartDN();
            int counter = 0;
            Iterator iter = realmNames.iterator();
            while (iter.hasNext()) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    this.tblModel.appendRow();
                }
                String name = (String)iter.next();
                String fqName = null;
                String displayName = null;
                if (name.equals(startDN)) {
                    this.tblModel.setSelectionVisible(counter, false);
                    fqName = name;
                    displayName = AMFormatUtils.DNToName(model, model.getStartDSDN());
                } else {
                    int idx = name.lastIndexOf(47);
                    displayName = idx == -1 ? name : name.substring(idx + 1);
                    this.tblModel.setSelectionVisible(counter, true);
                    fqName = name;
                }
                this.tblModel.setValue(TBL_DATA_ACTION_HREF, (Object)fqName);
                this.tblModel.setValue(TBL_DATA_NAME, (Object)SMSSchema.unescapeName(displayName));
                this.tblModel.setValue(TBL_DATA_PATH, (Object)this.getPath(name));
                cache.add(name);
                ++counter;
            }
            szCache.setValue(cache);
        } else {
            szCache.setValue(null);
        }
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.forwardTo();
    }

    public void handleTblButtonAddRequest(RequestInvocationEvent event) {
        RMRealmAddViewBean vb = (RMRealmAddViewBean)this.getViewBean(RMRealmAddViewBean.class);
        this.unlockPageTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleTblButtonDeleteRequest(RequestInvocationEvent event) throws ModelControlException {
        CCActionTable table = (CCActionTable)this.getChild(TBL_SEARCH);
        table.restoreStateData();
        String curRealm = (String)this.getPageSessionAttribute("currentRealm");
        Integer[] selected = this.tblModel.getSelectedRows();
        SerializedField szCache = (SerializedField)this.getChild("szCache");
        List list = (List)szCache.getSerializedObj();
        HashSet<String> names = new HashSet<String>(selected.length * 2);
        for (int i = 0; i < selected.length; ++i) {
            String name = (String)list.get(selected[i]);
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            names.add(name);
        }
        try {
            RMRealmModel model = (RMRealmModel)this.getModel();
            model.deleteSubRealms(curRealm, names);
            if (selected.length == 1) {
                this.setInlineAlertMessage("info", "message.information", "realm.message.deleted");
            } else {
                this.setInlineAlertMessage("info", "message.information", "realm.message.deleted.pural");
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleTblDataActionHrefRequest(RequestInvocationEvent event) throws ModelControlException {
        String prevRealm = (String)this.getPageSessionAttribute("currentRealm");
        this.setPageSessionAttribute("previousRealm", (Serializable)((Object)prevRealm));
        String newRealm = (String)this.getDisplayFieldValue(TBL_DATA_ACTION_HREF);
        this.setPageSessionAttribute("currentRealm", (Serializable)((Object)newRealm));
        this.setCurrentLocation(newRealm);
        String tmp = (String)this.getPageSessionAttribute(this.getTrackingTabIDName());
        this.setPageSessionAttribute("PreviousTabID", (Serializable)((Object)tmp));
        AMViewConfig config = AMViewConfig.getInstance();
        RMRealmModel model = (RMRealmModel)this.getModel();
        this.unlockPageTrail();
        try {
            AMViewBeanBase vb = config.getTabViewBean(this, newRealm, model, "realms", -1, -1);
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
        catch (AMConsoleException e) {
            this.setPageSessionAttribute("currentRealm", (Serializable)((Object)prevRealm));
            this.removePageSessionAttribute("PreviousTabID");
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.realms";
    }
}

