/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.realm.IDRepoOpViewBeanBase;
import com.sun.identity.console.realm.IDRepoSelectTypeViewBean;
import com.sun.identity.console.realm.model.IDRepoModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Map;

public class IDRepoAddViewBean
extends IDRepoOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/IDRepoAdd.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";

    IDRepoAddViewBean(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    public IDRepoAddViewBean() {
        super("IDRepoAdd", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.finish");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        IDRepoModel model = (IDRepoModel)this.getModel();
        String i18nName = (String)this.propertySheetModel.getValue("tfIdRepoTypeName");
        String title = model.getLocalizedString("page.title.realm.idrepo.create");
        String[] param = new String[]{i18nName};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
    }

    protected void setDefaultValues(String type) {
        IDRepoModel model = (IDRepoModel)this.getModel();
        Map defaultValues = model.getDefaultAttributeValues(type);
        AMPropertySheet ps = (AMPropertySheet)this.getChild("propertyAttributes");
        ps.setAttributeValues(defaultValues, model);
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        IDRepoSelectTypeViewBean vb = (IDRepoSelectTypeViewBean)this.getViewBean(IDRepoSelectTypeViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        IDRepoModel model = (IDRepoModel)this.getModel();
        AMPropertySheet prop = (AMPropertySheet)this.getChild("propertyAttributes");
        String idRepoType = (String)this.propertySheetModel.getValue("idRepoTypeName");
        String idRepoName = (String)this.propertySheetModel.getValue("tfIdRepoName");
        Map defaultValues = model.getDefaultAttributeValues(idRepoType);
        if (idRepoName.trim().length() > 0) {
            try {
                Map values = prop.getAttributeValues(defaultValues.keySet());
                String realmName = (String)this.getPageSessionAttribute("currentRealm");
                model.createIDRepo(realmName, idRepoName, idRepoType, values);
                this.forwardToIDRepoViewBean();
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            this.setInlineAlertMessage("error", "message.error", "idrepo.missing.idRepoName");
            this.forwardTo();
        }
    }

    protected boolean isCreateViewBean() {
        return true;
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.realm.idrepo.addIdRepo";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

