/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.property;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.PropertyTemplate;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class PrivilegeXMLBuilder
implements PropertyTemplate {
    private static PrivilegeXMLBuilder instance = new PrivilegeXMLBuilder();
    private SSOToken adminSSOToken = AMAdminUtils.getSuperAdminSSOToken();
    private static final String PRIVILEGE_SECTION_TAG = "<section name=\"privileges\" defaultValue=\"delegation.section.privileges\">";
    private static final String PRIVILEGE_PROPERTY_TAG = "<property><cc name=\"{0}\" tagclass=\"com.sun.web.ui.taglib.html.CCCheckBoxTag\"><attribute name=\"label\" value=\"delegation.{1}\" /></cc></property>";

    private PrivilegeXMLBuilder() {
    }

    public static PrivilegeXMLBuilder getInstance() {
        return instance;
    }

    public Set getAllPrivileges(String realm, AMModel model) {
        Set privileges = null;
        if (realm == null) {
            realm = model.getStartDN();
        }
        try {
            DelegationManager mgr = new DelegationManager(this.adminSSOToken, realm);
            privileges = mgr.getConfiguredPrivilegeNames();
        }
        catch (SSOException e) {
            PropertyXMLBuilderBase.debug.error("PrivilegeXMLBuilder.getAllPrivileges", (Throwable)((Object)e));
        }
        catch (DelegationException e) {
            PropertyXMLBuilderBase.debug.error("PrivilegeXMLBuilder.getAllPrivileges", (Throwable)e);
        }
        return privileges != null ? privileges : Collections.EMPTY_SET;
    }

    public String getXML(String realm, AMModel model) {
        StringBuffer xml = new StringBuffer(1000);
        if (realm == null) {
            realm = model.getStartDN();
        }
        try {
            DelegationManager mgr = new DelegationManager(this.adminSSOToken, realm);
            Set privileges = mgr.getConfiguredPrivilegeNames();
            if (privileges != null && !privileges.isEmpty()) {
                xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(PRIVILEGE_SECTION_TAG);
                Iterator iter = privileges.iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    Object[] params = new String[]{name, name};
                    xml.append(MessageFormat.format(PRIVILEGE_PROPERTY_TAG, params));
                }
                xml.append("</section>\n").append("</propertysheet>\n");
            }
        }
        catch (SSOException e) {
            PropertyXMLBuilderBase.debug.error("PrivilegeXMLBuilder.getXML", (Throwable)((Object)e));
        }
        catch (DelegationException e) {
            PropertyXMLBuilderBase.debug.error("PrivilegeXMLBuilder.getXML", (Throwable)e);
        }
        return xml.toString();
    }
}

