/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.property;

import com.sun.identity.console.base.model.AMDisplayType;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;

public abstract class PolicyPropertyXMLBuilderBase
extends PropertyXMLBuilderBase {
    protected AMModel model;

    public String getXML(String prefix) {
        StringBuffer xml = new StringBuffer(1000);
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!DOCTYPE propertysheet SYSTEM \"propertysheet.dtd\">\n").append("<propertysheet>\n").append(prefix);
        List propertyNames = this.getPropertyNames();
        if (propertyNames != null && !propertyNames.isEmpty()) {
            Object[] params = new Object[]{"values", this.model.getLocalizedString(this.getSectionLabel())};
            xml.append(MessageFormat.format("<section name=\"{0}\" defaultValue=\"{1}\">\n", params));
            Iterator iter = propertyNames.iterator();
            while (iter.hasNext()) {
                this.buildXML((String)iter.next(), xml);
            }
            xml.append("</section>\n");
        }
        xml.append("</propertysheet>\n");
        return xml.toString();
    }

    private void buildXML(String name, StringBuffer xml) {
        Syntax syntax = this.getPropertySyntax(name);
        String tagClassName = PolicyPropertyXMLBuilderBase.getTagClassName(syntax);
        if (tagClassName != null) {
            xml.append("<property >\n");
            Object[] params = new String[3];
            params[0] = name;
            params[2] = name;
            try {
                params[1] = this.getDisplayName(name, this.model.getUserLocale());
            }
            catch (PolicyException e) {
                debug.warning("PropertyXMLBuilderBase.buildXML", (Throwable)e);
                params[1] = name;
            }
            xml.append(MessageFormat.format("<label name=\"lbl{0}\" defaultValue=\"{1}\" labelFor=\"{2}\" />\n", params));
            if (this.allAttributesReadonly) {
                Object[] param = new Object[]{name, "com.sun.web.ui.taglib.html.CCStaticTextFieldTag"};
                xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"{1}\">\n", param));
            } else {
                Object[] param = new Object[]{name, tagClassName};
                xml.append(MessageFormat.format("<cc name=\"{0}\" tagclass=\"{1}\">\n", param));
                if (tagClassName.equals("com.sun.web.ui.taglib.html.CCTextAreaTag")) {
                    xml.append("<attribute name=\"localizeDisplayFieldValue\" value=\"false\" />\n");
                } else if (tagClassName.equals("com.sun.web.ui.taglib.html.CCTextFieldTag")) {
                    Object[] pSize = new Object[]{this.getStringFieldSize(syntax)};
                    xml.append(MessageFormat.format("<attribute name=\"size\" value=\"{0}\" />\n", pSize));
                    xml.append("<attribute name=\"localizeDisplayFieldValue\" value=\"false\" />\n");
                } else if (tagClassName.equals("com.sun.web.ui.taglib.html.CCSelectableListTag")) {
                    xml.append("<attribute name=\"multiple\" value=\"true\" />\n").append("<attribute name=\"size\" value=\"8\" />\n");
                }
                this.appendChoiceValues(name, syntax, xml);
            }
            xml.append("</cc>\n");
            xml.append("</property>\n");
        }
    }

    private String getStringFieldSize(Syntax syntax) {
        String size;
        block3: {
            size = "50";
            try {
                int type = AMDisplayType.getDisplaySyntax(syntax);
                if (type == 2) {
                    size = properties.getString("policy.textfield");
                }
            }
            catch (MissingResourceException e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("PolicyXMLBuilderBase: no size defined for " + syntax);
            }
        }
        return size;
    }

    private void appendChoiceValues(String name, Syntax syntax, StringBuffer xml) {
        int syn = AMDisplayType.getDisplaySyntax(syntax);
        switch (syn) {
            case 10: 
            case 11: {
                try {
                    Set validValues = this.getValidValues(name);
                    if (validValues == null || validValues.isEmpty()) break;
                    TreeSet sorted = new TreeSet(validValues);
                    Iterator iter = sorted.iterator();
                    while (iter.hasNext()) {
                        String val = (String)iter.next();
                        Object[] params = new Object[]{val, val};
                        xml.append(MessageFormat.format("<option label=\"{0}\" value=\"{1}\" />\n", params));
                    }
                    break;
                }
                catch (PolicyException e) {
                    debug.warning("PolicyPropertyXMLBuilderBase.appendChoiceValues", (Throwable)e);
                }
            }
        }
    }

    private static String getTagClassName(Syntax syntax) {
        String tagClassName = "com.sun.web.ui.taglib.html.CCTextFieldTag";
        int syn = AMDisplayType.getDisplaySyntax(syntax);
        switch (syn) {
            case 2: {
                tagClassName = "com.sun.web.ui.taglib.html.CCTextFieldTag";
                break;
            }
            case 10: {
                tagClassName = "com.sun.web.ui.taglib.html.CCDropDownMenuTag";
                break;
            }
            case 11: {
                tagClassName = "com.sun.web.ui.taglib.html.CCSelectableListTag";
                break;
            }
            case 12: {
                tagClassName = "com.sun.web.ui.taglib.editablelist.CCEditableListTag";
            }
        }
        return tagClassName;
    }

    protected abstract List getPropertyNames();

    protected abstract String getSectionLabel();

    protected abstract Syntax getPropertySyntax(String var1);

    protected abstract String getDisplayName(String var1, Locale var2) throws PolicyException;

    protected abstract Set getValidValues(String var1) throws PolicyException;
}

