/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy.model;

import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.policy.model.PolicyModelImpl;
import com.sun.identity.console.policy.model.SelectRealmModel;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SelectRealmModelImpl
extends AMModelBase
implements SelectRealmModel {
    public SelectRealmModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Set getRealmNames(String base, String filter) throws AMConsoleException {
        if (base == null || base.length() == 0) {
            base = this.getStartDN();
        }
        String[] param = new String[]{base};
        this.logEvent("ATTEMPT_GET_REALM_NAMES", param);
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), base);
            this.logEvent("SUCCEED_GET_REALM_NAMES", param);
            return PolicyModelImpl.appendBaseDN(base, orgMgr.getSubOrganizationNames(filter, true), filter, this);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{base, strError};
            this.logEvent("SMS_EXCEPTION_GET_REALM_NAMES", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public Set getAuthenticationInstances(String realmName) throws AMConsoleException {
        HashSet<String> names = Collections.EMPTY_SET;
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), realmName);
            Set instances = mgr.getAuthenticationInstances();
            if (instances != null && !instances.isEmpty()) {
                names = new HashSet<String>(instances.size());
                Iterator i = instances.iterator();
                while (i.hasNext()) {
                    names.add(((AMAuthenticationInstance)i.next()).getName());
                }
            }
        }
        catch (AMConfigurationException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        return names;
    }
}

