/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.util.HtmlUtil;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SessionPropertyConditionHelper {
    static String PG_SESSION_PROPERTY_VALUES = "pgSessionPropertyValues";
    static String PG_SESSION_PROPERTY_NAME = "pgSessionPropertyName";
    static String ATTR_VALUES = "Values";
    static String CB_CASE = "cbCaseInsensitive";
    static String TBL_DATA_NAME = "tblPolicySessionDataName";
    static String TBL_DATA_ACTION = "tblPolicySessionHrefAction";
    static String TBL_DATA_VALUES = "tblPolicySessionValues";
    private static SessionPropertyConditionHelper instance = new SessionPropertyConditionHelper();

    private SessionPropertyConditionHelper() {
    }

    public static SessionPropertyConditionHelper getInstance() {
        return instance;
    }

    public String getConditionXML(boolean bCreate, boolean readonly) {
        String xml = null;
        xml = bCreate ? "com/sun/identity/console/propertyPMConditionSessionProperty.xml" : (readonly ? "com/sun/identity/console/propertyPMConditionSessionProperty_Readonly.xml" : "com/sun/identity/console/propertyPMConditionSessionProperty.xml");
        return AMAdminUtils.getStringFromInputStream(this.getClass().getClassLoader().getResourceAsStream(xml));
    }

    public String getMissingValuesMessage() {
        return "policy.condition.missing.session.property.message";
    }

    public void populateTable(Map values, AMPropertySheetModel propertySheetModel) {
        if (values != null && !values.isEmpty()) {
            CCActionTableModel tblModel = (CCActionTableModel)propertySheetModel.getModel(ATTR_VALUES);
            tblModel.clear();
            boolean first = true;
            Iterator i = values.keySet().iterator();
            while (i.hasNext()) {
                String propName = (String)i.next();
                if (propName.equals("valueCaseInsensitive")) continue;
                Set val = (Set)values.get(propName);
                if (first) {
                    first = false;
                } else {
                    tblModel.appendRow();
                }
                tblModel.setValue(TBL_DATA_NAME, (Object)propName);
                tblModel.setValue(TBL_DATA_ACTION, (Object)propName);
                tblModel.setValue(TBL_DATA_VALUES, (Object)this.formatValues(val));
            }
        }
    }

    private String formatValues(Set values) {
        StringBuffer buff = new StringBuffer();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            String val = (String)i.next();
            buff.append(HtmlUtil.escape((String)val));
            buff.append("<br />");
        }
        return buff.toString();
    }
}

