/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.policy.model.PolicyModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthLevelHelper {
    public static final String ATTR_FILTER = "tfSearch";
    public static final String ATTR_REALM = "Realm";
    public static final String ATTR_AUTH_LEVEL = "AuthLevel";
    private static AuthLevelHelper instance = new AuthLevelHelper();

    private AuthLevelHelper() {
    }

    public static AuthLevelHelper getInstance() {
        return instance;
    }

    public void setPropertiesValues(Map values, AMPropertySheetModel propertySheetModel) {
        String propName;
        Set val;
        if (values != null && !values.isEmpty() && (val = (Set)values.get(propName = (String)values.keySet().iterator().next())) != null && !val.isEmpty() && propName.equals(ATTR_AUTH_LEVEL)) {
            String str = (String)val.iterator().next();
            propertySheetModel.setValue(ATTR_REALM, AMAuthUtils.getRealmFromRealmQualifiedData(str));
            propertySheetModel.setValue(ATTR_AUTH_LEVEL, AMAuthUtils.getDataFromRealmQualifiedData(str));
        }
    }

    public Map getConditionValues(PolicyModel model, AMPropertySheetModel propertySheetModel) throws AMConsoleException {
        String realmValue = (String)propertySheetModel.getValue(ATTR_REALM);
        realmValue = realmValue.trim();
        String levelValue = (String)propertySheetModel.getValue(ATTR_AUTH_LEVEL);
        if ((levelValue = levelValue.trim()).length() == 0) {
            throw new AMConsoleException(model.getLocalizedString("policy.condition.missing.auth.level"));
        }
        HashSet<String> set = new HashSet<String>(2);
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>(2);
        set.add(AMAuthUtils.toRealmQualifiedAuthnData(realmValue, levelValue));
        map.put(ATTR_AUTH_LEVEL, set);
        return map;
    }

    public Set getRealmNames(String filter, PolicyModel model) throws AMConsoleException {
        filter = filter == null || filter.length() == 0 ? (filter = "*") : filter.trim();
        return model.getRealmNames("/", filter);
    }
}

