/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.jato.NavigationException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.idm.ServiceViewBeanBase;
import com.sun.identity.console.idm.ServicesSelectViewBean;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import com.sun.web.ui.model.CCPageTitleModel;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;

public class ServicesAddViewBean
extends ServiceViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/idm/ServicesAdd.jsp";

    public ServicesAddViewBean() {
        super("ServicesAdd", DEFAULT_DISPLAY_URL, null);
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        if (serviceName != null) {
            this.initialize(serviceName);
        }
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.finish");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    public void forwardTo(RequestContext reqContext) throws NavigationException {
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        this.initialize(serviceName);
        super.forwardTo(reqContext);
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.forwardToServicesViewBean();
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        ServicesSelectViewBean vb = (ServicesSelectViewBean)this.getViewBean(ServicesSelectViewBean.class);
        this.unlockPageTrailForSwapping();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        EntitiesModel model = (EntitiesModel)this.getModel();
        try {
            Map values = this.getValues();
            String universalId = (String)this.getPageSessionAttribute("universalId");
            String serviceName = (String)this.getPageSessionAttribute("serviceName");
            model.assignService(universalId, serviceName, values);
            this.forwardToServicesViewBean();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    protected Map getAttributeValues() throws ModelControlException, AMConsoleException {
        EntitiesModel model = (EntitiesModel)this.getModel();
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        String universalId = (String)this.getPageSessionAttribute("universalId");
        try {
            AMIdentity amid = IdUtils.getIdentity(model.getUserSSOToken(), universalId);
            return model.getDefaultValues(amid.getType().getName(), serviceName);
        }
        catch (IdRepoException e) {
            return Collections.EMPTY_MAP;
        }
    }

    protected String getPageTitle() {
        EntitiesModel model = (EntitiesModel)this.getModel();
        String serviceName = model.getLocalizedServiceName((String)this.getPageSessionAttribute("serviceName"));
        Object[] param = new String[]{serviceName};
        return MessageFormat.format(model.getLocalizedString("page.title.entities.addservice"), param);
    }

    protected boolean isCreateViewBean() {
        return true;
    }

    protected Map getValues() throws ModelControlException, AMConsoleException {
        Object values = null;
        EntitiesModel model = (EntitiesModel)this.getModel();
        String serviceName = (String)this.getPageSessionAttribute("serviceName");
        String universalId = (String)this.getPageSessionAttribute("universalId");
        Map defaultValues = null;
        try {
            defaultValues = model.getServiceAttributeValues(universalId, serviceName);
            if (defaultValues.isEmpty()) {
                defaultValues = this.getDefaultValuesForIdentity(universalId, model);
            }
        }
        catch (AMConsoleException e) {
            defaultValues = this.getDefaultValuesForIdentity(universalId, model);
        }
        AMPropertySheet ps = (AMPropertySheet)this.getChild("propertyAttributes");
        return ps.getAttributeValues(defaultValues, model);
    }

    private Map getDefaultValuesForIdentity(String universalId, EntitiesModel model) {
        Map defaultValues = null;
        try {
            AMIdentity amid = IdUtils.getIdentity(model.getUserSSOToken(), universalId);
            defaultValues = model.getDefaultValues(amid.getType().getName(), this.serviceName);
            AMAdminUtils.makeMapValuesEmpty(defaultValues);
        }
        catch (AMConsoleException e) {
            defaultValues = Collections.EMPTY_MAP;
        }
        catch (IdRepoException e) {
            defaultValues = Collections.EMPTY_MAP;
        }
        return defaultValues;
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.editentities.addservice";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

