/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.dm.RoleViewBean;
import com.sun.identity.console.dm.model.RoleModel;
import com.sun.identity.console.dm.model.RoleModelImpl;
import com.sun.identity.console.realm.RMRealmOpViewBeanBase;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NewRoleViewBean
extends RMRealmOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/NewRole.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String ROLE_TYPE_CB = "iplanet-am-role-type";
    private static final String PERMISSION_LIST = "iplanet-am-role-aci-list";
    private int roleType = -1;
    private AMPropertySheetModel propertySheetModel;
    private RoleModel model = null;

    public NewRoleViewBean() {
        super("NewRole");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String role;
        if (!this.initialized && (role = (String)this.getPageSessionAttribute("role-page-type")) != null) {
            super.initialize();
            this.roleType = Integer.parseInt(role);
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name) : super.createChild(name)));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.setAccessPermissions();
        this.setRoleTypes();
        if (this.roleType == 6) {
            this.ptModel.setPageTitleText(this.model.getLocalizedString("page.title.create.role"));
        } else {
            this.ptModel.setPageTitleText(this.model.getLocalizedString("page.title.create.filtered.role"));
        }
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    protected void setAccessPermissions() {
        Set aciList = this.model.getDefaultPermissions();
        OptionList permList = new OptionList();
        if (aciList != null && aciList.size() > 0) {
            Iterator it = aciList.iterator();
            while (it.hasNext()) {
                String type = (String)it.next();
                permList.add(this.model.getOptionString(type), type);
            }
            CCDropDownMenu cb = (CCDropDownMenu)this.getChild(PERMISSION_LIST);
            cb.setOptions(permList);
        }
    }

    protected void setRoleTypes() {
        Map roleTypes = this.model.getDefaultTypes();
        if (roleTypes != null) {
            OptionList typeList = new OptionList();
            String defaultValue = null;
            Iterator it = roleTypes.keySet().iterator();
            while (it.hasNext()) {
                String type = (String)it.next();
                String value = (String)roleTypes.get(type);
                if (defaultValue == null) {
                    defaultValue = value;
                }
                typeList.add(type, value);
            }
            CCDropDownMenu cb = (CCDropDownMenu)this.getChild(ROLE_TYPE_CB);
            cb.setOptions(typeList);
            if (defaultValue != null) {
                this.setDisplayFieldValue(ROLE_TYPE_CB, defaultValue);
            }
        }
    }

    private void createPropertyModel() {
        this.model = (RoleModel)this.getModel();
        this.propertySheetModel = new AMPropertySheetModel(this.model.getRoleCreateXML(this.roleType));
        this.propertySheetModel.clear();
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        this.model = new RoleModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        return this.model;
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        RoleModel model = (RoleModel)this.getModel();
        String location = (String)this.getPageSessionAttribute("currentOrganization");
        if (location == null || location.length() == 0) {
            location = model.getStartDSDN();
        }
        try {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
            HashMap<String, String> values = ps.getAttributeValues(model.getDataMap(this.roleType), false, model);
            if (values == null) {
                values = new HashMap<String, String>();
            }
            values.put("role-page-type", (String)this.getPageSessionAttribute("role-page-type"));
            model.createRole(location, values);
            this.forwardToRoleView(event);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
        this.setInlineAlertMessage("info", "message.information", "TBD");
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardToRoleView(event);
    }

    private void forwardToRoleView(RequestInvocationEvent event) {
        RoleViewBean vb = (RoleViewBean)this.getViewBean(RoleViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.directorymanager.role.add";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

