/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.sun.identity.console.base.model.AMConsoleException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PageTrail
implements Serializable {
    private List trail = new ArrayList();

    public PageTrail() {
    }

    public PageTrail(String displayName, String viewBeanClassName, Map pageSessionAttributeValues) {
        this.add(displayName, viewBeanClassName, pageSessionAttributeValues);
    }

    public void set(String displayName, String viewBeanClassName, Map pageSessionAttributeValues) {
        this.trail.clear();
        this.add(displayName, viewBeanClassName, pageSessionAttributeValues);
    }

    public void swap(String displayName, String viewBeanClassName, Map pageSessionAttributeValues) {
        this.trail.remove(this.trail.size() - 1);
        this.trail.add(new Marker(displayName, viewBeanClassName, pageSessionAttributeValues));
    }

    public void add(String displayName, String viewBeanClassName, Map pageSessionAttributeValues) {
        Marker lastMarker;
        if (!this.trail.isEmpty() && (lastMarker = (Marker)this.trail.get(this.trail.size() - 1)).getViewBeanClassName().equals(viewBeanClassName)) {
            this.trail.remove(this.trail.size() - 1);
        }
        this.trail.add(new Marker(displayName, viewBeanClassName, pageSessionAttributeValues));
    }

    public Marker pop() {
        try {
            int idx = this.trail.size() - 2;
            return idx < 0 ? this.backTo(0) : this.backTo(idx);
        }
        catch (AMConsoleException e) {
            return null;
        }
    }

    public Marker backTo(int idx) throws AMConsoleException {
        int size = this.trail.size();
        if (idx >= size) {
            throw new AMConsoleException("cannot be discard items in page trail");
        }
        for (int i = size - 1; i > idx; --i) {
            this.trail.remove(i);
        }
        return (Marker)this.trail.get(idx);
    }

    public List getMarkers() {
        return this.trail;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        Iterator iter = this.trail.iterator();
        while (iter.hasNext()) {
            Marker m = (Marker)iter.next();
            buff.append(m.toString());
        }
        return buff.toString();
    }

    public class Marker
    implements Serializable {
        private String displayName;
        private String viewBeanClassName;
        private Map pageSessionAttributeValues;

        public Marker() {
        }

        public Marker(String displayName, String viewBeanClassName, Map pageSessionAttributeValues) {
            if (displayName.startsWith("//")) {
                displayName = displayName.substring(1);
            }
            this.displayName = displayName;
            this.viewBeanClassName = viewBeanClassName;
            this.pageSessionAttributeValues = pageSessionAttributeValues;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getViewBeanClassName() {
            return this.viewBeanClassName;
        }

        public Map getPageSessionAttributeValues() {
            return this.pageSessionAttributeValues;
        }

        public String toString() {
            return "\ndisplayName=" + this.displayName + "\nviewBeanClassName=" + this.viewBeanClassName + "\npageSessionAttributeValues=" + this.pageSessionAttributeValues;
        }
    }
}

