/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base;

import com.iplanet.jato.RequestManager;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HelpConfig {
    public static Debug debug = Debug.getInstance((String)"amConsole");
    private static final String HELP_SET_FILE = "/html/en/help/app.hs";
    private static final String ELEM_MAPREF = "mapref";
    private static final String ELEM_SUBHELPSET = "subhelpset";
    private static final String ELEM_MAPID = "mapID";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_URL = "url";
    private static HelpConfig instance = new HelpConfig();
    private static EntityResolver ignoreDtdResolver = new DefaultHandler(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            if (systemId != null && ((systemId = systemId.trim()).endsWith(".dtd") || systemId.endsWith(".DTD"))) {
                return new InputSource(new StringReader(""));
            }
            try {
                return super.resolveEntity(publicId, systemId);
            }
            catch (Exception e) {
                if (!(e instanceof SAXException)) {
                    throw new SAXException(e);
                }
                throw (SAXException)e;
            }
        }
    };
    private Map helpFileNameMap = new HashMap();
    private Map helpAnchorMap = new HashMap();
    private String title = "";
    private DocumentBuilder builder;

    private HelpConfig() {
        this.init();
    }

    private void init() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            this.builder = factory.newDocumentBuilder();
            this.builder.setEntityResolver(ignoreDtdResolver);
        }
        catch (ParserConfigurationException pce) {
            debug.error("HelpConfig.init : ", (Throwable)pce);
            return;
        }
        catch (IllegalArgumentException iae) {
            debug.error("HelpConfig.init : ", (Throwable)iae);
            return;
        }
        catch (Exception e) {
            debug.error("HelpConfig.init : ", (Throwable)e);
            return;
        }
        ServletContext context = RequestManager.getRequestContext().getServletContext();
        URL hs = null;
        try {
            hs = context.getResource(HELP_SET_FILE);
        }
        catch (MalformedURLException muex) {
            debug.error("HelpConfig.init ServletContext path in incorrect form: /html/en/help/app.hs");
            return;
        }
        if (hs == null) {
            debug.error("HelpConfig.init Cannot find HelpSet file on context path: /html/en/help/app.hs");
            return;
        }
        this.parseHelpSetFile(hs);
    }

    private void parseHelpSetFile(URL hs) {
        NodeList subhelpsets;
        Document hsDoc;
        try {
            InputStream hsIn = hs.openStream();
            hsDoc = this.builder.parse(hsIn);
        }
        catch (IOException ioe) {
            debug.error("HelpConfig.parseHelpSetFile URL=" + hs, (Throwable)ioe);
            return;
        }
        catch (SAXException saxe) {
            debug.error("HelpConfig.parseHelpSetFile URL=" + hs, (Throwable)saxe);
            return;
        }
        catch (IllegalArgumentException iae) {
            debug.error("HelpConfig.parseHelpSetFile URL=" + hs, (Throwable)iae);
            return;
        }
        NodeList maprefs = hsDoc.getElementsByTagName(ELEM_MAPREF);
        if (maprefs != null) {
            for (int i = 0; i < maprefs.getLength(); ++i) {
                Node node = maprefs.item(i);
                if (node instanceof Element) {
                    String mapref = ((Element)node).getAttribute(ATTR_LOCATION);
                    try {
                        URL jhm = new URL(hs, mapref);
                        this.parseHelpMap(jhm);
                    }
                    catch (MalformedURLException mue) {
                        debug.warning("HelpConfig.parseHelpSetFile Invalid mapref, " + mapref, (Throwable)mue);
                    }
                    continue;
                }
                debug.warning("HelpConfig.parseHelpSetFile HS file format error, mapref should be element.");
            }
        }
        if ((subhelpsets = hsDoc.getElementsByTagName(ELEM_SUBHELPSET)) != null) {
            for (int i = 0; i < subhelpsets.getLength(); ++i) {
                Node node = subhelpsets.item(i);
                if (node instanceof Element) {
                    String subhelpset = ((Element)node).getAttribute(ATTR_LOCATION);
                    try {
                        URL subhs = new URL(hs, subhelpset);
                        this.parseHelpSetFile(subhs);
                    }
                    catch (MalformedURLException mue) {
                        debug.warning("HelpConfig.parseHelpSetFile Invalid subhelpset, " + subhelpset, (Throwable)mue);
                    }
                    continue;
                }
                debug.warning("HelpConfig.parseHelpSetFile HS file format error, subhelpset should be element.");
            }
        }
    }

    private void parseHelpMap(URL jhm) {
        Document jhmDoc;
        try {
            InputStream jhmIn = jhm.openStream();
            jhmDoc = this.builder.parse(jhmIn);
        }
        catch (IOException ioe) {
            debug.error("HelpConfig.parseHelpMap", (Throwable)ioe);
            return;
        }
        catch (SAXException saxe) {
            debug.error("HelpConfig.parseHelpMap", (Throwable)saxe);
            return;
        }
        catch (IllegalArgumentException iae) {
            debug.error("HelpConfig.parseHelpMap", (Throwable)iae);
            return;
        }
        NodeList mapIDs = jhmDoc.getElementsByTagName(ELEM_MAPID);
        if (mapIDs != null) {
            for (int i = 0; i < mapIDs.getLength(); ++i) {
                Node node = mapIDs.item(i);
                if (node instanceof Element) {
                    Element mapID = (Element)node;
                    String target = mapID.getAttribute(ATTR_TARGET);
                    String url = mapID.getAttribute(ATTR_URL);
                    int hash = url.indexOf(35);
                    if (hash == -1) {
                        this.helpFileNameMap.put(target, url);
                        continue;
                    }
                    this.helpFileNameMap.put(target, url.substring(0, hash));
                    if (hash >= url.length() - 1) continue;
                    this.helpAnchorMap.put(target, url.substring(hash + 1));
                    continue;
                }
                debug.error("HelpConfig.parseHelpMap HelpMap file format error, mapID should be element.");
            }
        }
    }

    public static HelpConfig getInstance() {
        return instance;
    }

    public String getHelpFileName(String helpID) {
        return (String)this.helpFileNameMap.get(helpID);
    }

    public String getHelpAnchor(String helpID) {
        return (String)this.helpAnchorMap.get(helpID);
    }
}

