/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.authentication.AuthPropertiesViewBean;
import com.sun.identity.console.authentication.model.AuthPropertiesModel;
import com.sun.identity.console.authentication.model.AuthPropertiesModelImpl;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.Map;

public class NewAuthInstanceViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/authentication/NewAuthInstance.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String INSTANCE_TYPE = "instanceType";
    private static final String INSTANCE_NAME = "instanceName";
    private AMPropertySheetModel propertySheetModel;
    private CCPageTitleModel ptModel;

    public NewAuthInstanceViewBean() {
        super("NewAuthInstance");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createPropertyModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.ptModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        if (name.equals(PGTITLE_TWO_BTNS)) {
            view = new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name);
        } else if (name.equals(PROPERTY_ATTRIBUTE)) {
            view = new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name);
        } else if (this.propertySheetModel.isChildSupported(name)) {
            view = this.propertySheetModel.createChild((View)this, name, this.getModel());
            if (name.equals(INSTANCE_TYPE)) {
                CCRadioButton radio = (CCRadioButton)view;
                radio.setOptions(this.createAuthTypeOptionList());
            }
        } else {
            view = this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name);
        }
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        String name = (String)this.getDisplayFieldValue(INSTANCE_NAME);
        String type = (String)this.getDisplayFieldValue(INSTANCE_TYPE);
        if (name == null || name.length() < 1) {
            this.setInlineAlertMessage("error", "message.error", "authentication.missing.instance.name");
            this.forwardTo();
        } else if (type == null || type.length() < 1) {
            this.setInlineAlertMessage("error", "message.error", "authentication.missing.instance.type");
            this.forwardTo();
        } else {
            AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
            try {
                model.createAuthInstance(name, type);
                this.forwardToProperties(event);
            }
            catch (AMConsoleException ae) {
                this.setInlineAlertMessage("error", "message.error", ae.getMessage());
                this.forwardTo();
            }
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.forwardToProperties(event);
    }

    private void forwardToProperties(RequestInvocationEvent event) throws ModelControlException {
        AuthPropertiesViewBean vb = (AuthPropertiesViewBean)this.getViewBean(AuthPropertiesViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    private OptionList createAuthTypeOptionList() {
        AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
        Map types = model.getAuthTypes();
        return this.createOptionList(types);
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    protected AMModel getModelInternal() {
        RequestContext rc = RequestManager.getRequestContext();
        return new AuthPropertiesModelImpl(rc.getRequest(), this.getPageSessionAttributes());
    }

    private void createPropertyModel() {
        AuthPropertiesModel model = (AuthPropertiesModel)this.getModel();
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyNewAuthInstance.xml"));
        this.propertySheetModel.clear();
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.auth.newInstance";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

