/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.agentconfig.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.console.agentconfig.model.AgentsModel;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.sm.SMSException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;

public class AgentsModelImpl
extends AMModelBase
implements AgentsModel {
    public AgentsModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public int getAgentNames(String realmName, Set setTypes, String pattern, Set results) throws AMConsoleException {
        int sizeLimit = this.getSearchResultLimit();
        int timeLimit = this.getSearchTimeOutLimit();
        String[] params = new String[]{realmName, setTypes.toString(), pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit)};
        try {
            IdSearchControl idsc = new IdSearchControl();
            idsc.setMaxResults(sizeLimit);
            idsc.setTimeOut(timeLimit);
            idsc.setAllReturnAttributes(false);
            this.logEvent("ATTEMPT_SEARCH_AGENT", params);
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            IdSearchResults isr = repo.searchIdentities(IdType.AGENTONLY, pattern, idsc);
            Set res = isr.getSearchResults();
            if (res != null && !res.isEmpty()) {
                Iterator i = res.iterator();
                while (i.hasNext()) {
                    AMIdentity amid = (AMIdentity)i.next();
                    if (!this.matchType(amid, setTypes)) continue;
                    results.add(amid);
                }
            }
            this.logEvent("SUCCEED_SEARCH_AGENT", params);
            return isr.getErrorCode();
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, setTypes.toString(), pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), this.getErrorString(e)};
            this.logEvent("EXCEPTION_SEARCH_AGENT", paramsEx);
            if (debug.warningEnabled()) {
                debug.warning("AgentsModelImpl.getAgentNames " + this.getErrorString(e));
            }
            throw new AMConsoleException("no.properties");
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, setTypes.toString(), pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_SEARCH_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.getAgentNames ", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    public int getAgentGroupNames(String realmName, Set setTypes, String pattern, Set results) throws AMConsoleException {
        int sizeLimit = this.getSearchResultLimit();
        int timeLimit = this.getSearchTimeOutLimit();
        String[] params = new String[]{realmName, setTypes.toString(), pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit)};
        try {
            IdSearchControl idsc = new IdSearchControl();
            idsc.setMaxResults(sizeLimit);
            idsc.setTimeOut(timeLimit);
            idsc.setAllReturnAttributes(false);
            this.logEvent("ATTEMPT_SEARCH_AGENT_GROUP", params);
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            IdSearchResults isr = repo.searchIdentities(IdType.AGENTGROUP, pattern, idsc);
            Set res = isr.getSearchResults();
            if (res != null && !res.isEmpty()) {
                Iterator i = res.iterator();
                while (i.hasNext()) {
                    AMIdentity amid = (AMIdentity)i.next();
                    if (!this.matchType(amid, setTypes)) continue;
                    results.add(amid);
                }
            }
            this.logEvent("SUCCEED_SEARCH_AGENT_GROUP", params);
            return isr.getErrorCode();
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, setTypes.toString(), pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), this.getErrorString(e)};
            this.logEvent("EXCEPTION_SEARCH_AGENT_GROUP", paramsEx);
            if (debug.warningEnabled()) {
                debug.warning("AgentsModelImpl.getAgentGroupNames " + this.getErrorString(e));
            }
            throw new AMConsoleException("no.properties");
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, setTypes.toString(), pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_SEARCH_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.getAgentGroupNames ", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
    }

    private boolean matchType(AMIdentity amid, Set setTypes) throws AMConsoleException {
        return setTypes.contains(this.getAgentType(amid));
    }

    public String getAgentType(AMIdentity amid) throws AMConsoleException {
        try {
            Map attrValues = amid.getAttributes();
            Set set = (Set)attrValues.get("AgentType");
            return set != null && !set.isEmpty() ? (String)set.iterator().next() : "";
        }
        catch (IdRepoException ex) {
            throw new AMConsoleException(ex.getMessage());
        }
        catch (SSOException ex) {
            throw new AMConsoleException(ex.getMessage());
        }
    }

    public void createAgent(String realmName, String name, String type, String password, String choice) throws AMConsoleException {
        String[] params = new String[]{realmName, name, type};
        try {
            this.logEvent("ATTEMPT_CREATE_AGENT", params);
            Map map = AgentConfiguration.getDefaultValues(type, false);
            HashSet<String> set = new HashSet<String>(2);
            map.put("userpassword", set);
            set.add(password);
            if (choice != null && choice.equalsIgnoreCase("local")) {
                HashSet<String> newset = new HashSet<String>(2);
                newset.add("local");
                map.put("com.sun.identity.agents.config.repository.location", newset);
            }
            AgentConfiguration.createAgent(this.getUserSSOToken(), realmName, name, type, map);
            this.logEvent("SUCCEED_CREATE_AGENT", params);
        }
        catch (ConfigurationException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void createAgent(String realmName, String name, String type, String password, String serverURL, String agentURL) throws AMConsoleException {
        String[] params = new String[]{realmName, name, type};
        try {
            this.logEvent("ATTEMPT_CREATE_AGENT", params);
            Map map = AgentConfiguration.getDefaultValues(type, false);
            HashSet<String> set = new HashSet<String>(2);
            map.put("userpassword", set);
            set.add(password);
            AgentConfiguration.createAgent(this.getUserSSOToken(), realmName, name, type, map, serverURL, agentURL);
            this.logEvent("SUCCEED_CREATE_AGENT", params);
        }
        catch (ConfigurationException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (MalformedURLException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT", paramsEx);
            debug.warning("AgentsModelImpl.createAgent", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void createAgentGroup(String realmName, String name, String type, String serverURL, String agentURL) throws AMConsoleException {
        String[] params = new String[]{realmName, name, type};
        try {
            this.logEvent("ATTEMPT_CREATE_AGENT_GROUP", params);
            AgentConfiguration.createAgentGroup(this.getUserSSOToken(), realmName, name, type, AgentConfiguration.getDefaultValues(type, true), serverURL, agentURL);
            this.logEvent("SUCCEED_CREATE_AGENT_GROUP", params);
        }
        catch (MalformedURLException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (ConfigurationException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void createAgentGroup(String realmName, String name, String type) throws AMConsoleException {
        String[] params = new String[]{realmName, name, type};
        try {
            this.logEvent("ATTEMPT_CREATE_AGENT_GROUP", params);
            AgentConfiguration.createAgentGroup(this.getUserSSOToken(), realmName, name, type, AgentConfiguration.getDefaultValues(type, true));
            this.logEvent("SUCCEED_CREATE_AGENT_GROUP", params);
        }
        catch (ConfigurationException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)((Object)e));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{realmName, name, type, this.getErrorString(e)};
            this.logEvent("EXCEPTION_CREATE_AGENT_GROUP", paramsEx);
            debug.warning("AgentsModelImpl.createAgentGroup", (Throwable)e);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void deleteAgents(String realmName, Set agents) throws AMConsoleException {
        if (agents != null && !agents.isEmpty()) {
            String idNames = AMFormatUtils.toCommaSeparatedFormat(agents);
            String[] params = new String[]{realmName, idNames};
            this.logEvent("ATTEMPT_DELETE_AGENT", params);
            try {
                AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
                repo.deleteIdentities(this.getAMIdentity(agents));
                this.logEvent("SUCCEED_DELETE_AGENT", params);
            }
            catch (IdRepoException e) {
                String[] paramsEx = new String[]{realmName, idNames, this.getErrorString(e)};
                this.logEvent("EXCEPTION_DELETE_AGENT", paramsEx);
                throw new AMConsoleException(this.getErrorString(e));
            }
            catch (SSOException e) {
                String[] paramsEx = new String[]{realmName, idNames, this.getErrorString((Throwable)((Object)e))};
                this.logEvent("EXCEPTION_DELETE_AGENT", paramsEx);
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
            }
        }
    }

    public void deleteAgentGroups(String realmName, Set agentGroups) throws AMConsoleException {
        if (agentGroups != null && !agentGroups.isEmpty()) {
            String idNames = AMFormatUtils.toCommaSeparatedFormat(agentGroups);
            String[] params = new String[]{realmName, idNames};
            this.logEvent("ATTEMPT_DELETE_AGENT_GROUP", params);
            try {
                AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
                repo.deleteIdentities(this.getAMIdentity(agentGroups));
                this.logEvent("SUCCEED_DELETE_AGENT_GROUP", params);
            }
            catch (IdRepoException e) {
                String[] paramsEx = new String[]{realmName, idNames, this.getErrorString(e)};
                this.logEvent("EXCEPTION_DELETE_AGENT_GROUP", paramsEx);
                throw new AMConsoleException(this.getErrorString(e));
            }
            catch (SSOException e) {
                String[] paramsEx = new String[]{realmName, idNames, this.getErrorString((Throwable)((Object)e))};
                this.logEvent("EXCEPTION_DELETE_AGENT_GROUP", paramsEx);
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
            }
        }
    }

    private Set getAMIdentity(Set names) throws IdRepoException {
        HashSet<AMIdentity> identities = new HashSet<AMIdentity>(names.size() * 2);
        SSOToken ssoToken = this.getUserSSOToken();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            identities.add(IdUtils.getIdentity(ssoToken, (String)iter.next()));
        }
        return identities;
    }

    public String getAgentGroupId(String realmName, String universalId) throws AMConsoleException {
        String groupName = this.getAgentGroup(realmName, universalId);
        if (groupName != null) {
            AMIdentity amid = new AMIdentity(this.getUserSSOToken(), groupName, IdType.AGENTGROUP, realmName, null);
            return amid.getUniversalId();
        }
        return null;
    }

    public String getAgentGroup(String realmName, String universalId) throws AMConsoleException {
        String[] param = new String[]{universalId};
        this.logEvent("ATTEMPT_GET_AGENT_ATTRIBUTE_VALUES", param);
        String groupName = null;
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Set groups = amid.getMemberships(IdType.AGENTGROUP);
            if (groups != null && !groups.isEmpty()) {
                AMIdentity group = (AMIdentity)groups.iterator().next();
                groupName = group.getName();
            }
            this.logEvent("SUCCEED_GET_AGENT_ATTRIBUTE_VALUES", param);
            return groupName;
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString(e)};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Map getAttributeValues(String realmName, String universalId, boolean withInheritValues) throws AMConsoleException {
        String[] param = new String[]{universalId};
        this.logEvent("ATTEMPT_GET_AGENT_ATTRIBUTE_VALUES", param);
        try {
            String groupId;
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Map values = AgentConfiguration.getAgentAttributes(amid, false);
            if (withInheritValues && (groupId = this.getAgentGroupId(realmName, universalId)) != null && groupId.trim().length() > 0) {
                AMIdentity group = IdUtils.getIdentity(this.getUserSSOToken(), groupId);
                if (!group.isExists()) {
                    Object[] arg = new Object[]{group.getName()};
                    throw new AMConsoleException(MessageFormat.format(this.getLocalizedString("agent.group.does.not.exist"), arg));
                }
                Map groupValues = AgentConfiguration.getAgentAttributes(group, false);
                groupValues.putAll(values);
                values = groupValues;
            }
            this.logEvent("SUCCEED_GET_AGENT_ATTRIBUTE_VALUES", param);
            return values;
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString(e)};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString(e)};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Map getGroupAttributeValues(String realmName, String groupName) throws AMConsoleException {
        String[] param = new String[]{groupName};
        this.logEvent("ATTEMPT_GET_AGENT_ATTRIBUTE_VALUES", param);
        try {
            AMIdentity amid = new AMIdentity(this.getUserSSOToken(), groupName, IdType.AGENTGROUP, realmName, null);
            Map values = AgentConfiguration.getAgentAttributes(amid, false);
            this.logEvent("SUCCEED_GET_AGENT_ATTRIBUTE_VALUES", param);
            return values;
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{groupName, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            String[] paramsEx = new String[]{groupName, this.getErrorString(e)};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{groupName, this.getErrorString(e)};
            this.logEvent("EXCEPTION_GET_AGENT_ATTRIBUTE_VALUES", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public void setAttributeValues(String universalId, Map values) throws AMConsoleException {
        String[] param = new String[]{universalId};
        this.logEvent("ATTEMPT_SET_AGENT_ATTRIBUTE_VALUE", param);
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            values.remove("AgentType");
            amid.setAttributes(values);
            amid.store();
            this.logEvent("SUCCEED_SET_AGENT_ATTRIBUTE_VALUE", param);
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_SET_AGENT_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{universalId, this.getErrorString(e)};
            this.logEvent("EXCEPTION_SET_AGENT_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public boolean setGroup(String realmName, String universalId, String groupName) throws AMConsoleException {
        String[] param = new String[]{realmName, universalId};
        this.logEvent("ATTEMPT_SET_AGENT_ATTRIBUTE_VALUE", param);
        try {
            boolean bSet = false;
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            Set groups = amid.getMemberships(IdType.AGENTGROUP);
            if (groupName != null && groupName.length() > 0) {
                AMIdentity group = new AMIdentity(this.getUserSSOToken(), groupName, IdType.AGENTGROUP, realmName, null);
                if (!groups.contains(group.getDN())) {
                    group.addMember(amid);
                    bSet = true;
                }
            } else if (groups != null && !groups.isEmpty()) {
                AMIdentity group = (AMIdentity)groups.iterator().next();
                group.removeMember(amid);
                bSet = true;
            }
            this.logEvent("SUCCEED_SET_AGENT_ATTRIBUTE_VALUE", param);
            return bSet;
        }
        catch (SSOException e) {
            String[] paramsEx = new String[]{realmName, universalId, this.getErrorString((Throwable)((Object)e))};
            this.logEvent("EXCEPTION_SET_AGENT_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            String[] paramsEx = new String[]{realmName, universalId, this.getErrorString(e)};
            this.logEvent("EXCEPTION_SET_AGENT_ATTRIBUTE_VALUE", paramsEx);
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Set getAuthenticationChains() throws AMConsoleException {
        try {
            TreeSet chains = new TreeSet();
            chains.addAll(AgentConfiguration.getChoiceValues("authenticationChain", "WSPAgent").keySet());
            return chains;
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Map getSecurityMechanisms(String agentType) {
        try {
            return AgentConfiguration.getChoiceValues("SecurityMech", agentType);
        }
        catch (SSOException e) {
            debug.error("AgentModelImpl.getSecurityMechanisms", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("AgentModelImpl.getSecurityMechanisms", (Throwable)e);
        }
        return Collections.EMPTY_MAP;
    }

    public Set getSTSConfigurations() {
        try {
            Map map = AgentConfiguration.getChoiceValues("STS", "WSCAgent");
            if (map != null && !map.isEmpty()) {
                return map.keySet();
            }
        }
        catch (SSOException e) {
            debug.error("AgentModelImpl.getSTSConfigurations", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("AgentModelImpl.getSTSConfigurations", (Throwable)e);
        }
        return Collections.EMPTY_SET;
    }

    public Set getDiscoveryConfigurations() {
        try {
            Map map = AgentConfiguration.getChoiceValues("Discovery", "WSCAgent");
            if (map != null && !map.isEmpty()) {
                return map.keySet();
            }
        }
        catch (SSOException e) {
            debug.error("AgentModelImpl.getDiscoveryConfigurations", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("AgentModelImpl.getDiscoveryConfigurations", (Throwable)e);
        }
        return Collections.EMPTY_SET;
    }

    public String getDisplayName(String universalId) throws AMConsoleException {
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            return amid.getName();
        }
        catch (IdRepoException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public boolean isAgentGroup(String universalId) {
        boolean isGroup = false;
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            isGroup = amid.getType().equals(IdType.AGENTGROUP);
        }
        catch (IdRepoException e) {
            debug.error("AgentModelImpl.getSecurityMechanisms", (Throwable)e);
        }
        return isGroup;
    }

    public Set getInheritedPropertyNames(String realmName, String universalId) {
        Set names = null;
        try {
            if (this.getAgentGroup(realmName, universalId) != null) {
                AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
                names = AgentConfiguration.getInheritedAttributeNames(amid);
            }
        }
        catch (AMConsoleException e) {
            debug.error("AgentModelImpl.getInheritedPropertyNames", (Throwable)e);
        }
        catch (SMSException e) {
            debug.error("AgentModelImpl.getInheritedPropertyNames", (Throwable)e);
        }
        catch (IdRepoException e) {
            debug.error("AgentModelImpl.getInheritedPropertyNames", (Throwable)e);
        }
        catch (SSOException e) {
            debug.error("AgentModelImpl.getInheritedPropertyNames", (Throwable)((Object)e));
        }
        return names != null ? names : Collections.EMPTY_SET;
    }

    public Map getAttributeSchemas(String agentType, Collection attributeNames) {
        Map map = null;
        try {
            map = AgentConfiguration.getAttributeSchemas(agentType, attributeNames);
        }
        catch (SSOException e) {
            debug.error("AgentModelImpl.getLocalizedNames", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("AgentModelImpl.getLocalizedNames", (Throwable)e);
        }
        return map != null ? map : Collections.EMPTY_MAP;
    }

    public void updateAgentConfigInheritance(String universalId, Map inherit) throws AMConsoleException {
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), universalId);
            AgentConfiguration.updateInheritance(amid, inherit);
        }
        catch (SMSException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }

    public Map getAgentGroupValues(String realmName, String agentId, Set attrNames) throws AMConsoleException {
        if (attrNames.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        String groupId = this.getAgentGroupId(realmName, agentId);
        if (groupId != null && groupId.length() != 0) {
            try {
                AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), groupId);
                return amid.getAttributes(attrNames);
            }
            catch (SSOException e) {
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
            }
            catch (IdRepoException e) {
                throw new AMConsoleException(this.getErrorString(e));
            }
        }
        return Collections.EMPTY_MAP;
    }

    public Set getAgentGroupMembers(String agentId) throws AMConsoleException {
        try {
            AMIdentity amid = IdUtils.getIdentity(this.getUserSSOToken(), agentId);
            return amid.getMembers(IdType.AGENTONLY);
        }
        catch (SSOException e) {
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)e)));
        }
        catch (IdRepoException e) {
            throw new AMConsoleException(this.getErrorString(e));
        }
    }
}

