/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.agentconfig;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.agentconfig.AgentsViewBean;
import com.sun.identity.console.agentconfig.model.AgentsModel;
import com.sun.identity.console.agentconfig.model.AgentsModelImpl;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import javax.servlet.http.HttpServletRequest;

public class AgentAddViewBean
extends AMPrimaryMastHeadViewBean {
    private static final String DEFAULT_DISPLAY_URL = "/console/agentconfig/AgentAdd.jsp";
    private static final String TF_NAME = "tfName";
    private static final String TF_PASSWORD = "tfPassword";
    private static final String TF_PASSWORD_CONFIRM = "tfPasswordConfirm";
    private static final String TF_SERVER_URL = "tfServerURL";
    private static final String TF_AGENT_URL = "tfAgentURL";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String RADIO_CHOICE = "radioChoice";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;

    public AgentAddViewBean() {
        super("AgentAdd");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String agentType;
        if (!this.initialized && (agentType = this.getAgentType()) != null) {
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.registerChild(TF_NAME, CCTextField.class);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.create");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        String agentType = this.getAgentType();
        String xml = agentType.equals("J2EEAgent") ? "com/sun/identity/console/propertyAgentAddJ2EE.xml" : (agentType.equals("WebAgent") ? "com/sun/identity/console/propertyAgentAddWeb.xml" : "com/sun/identity/console/propertyAgentAdd.xml");
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xml));
        this.propertySheetModel.clear();
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new AgentsModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent e) {
        String value = (String)this.getDisplayFieldValue(RADIO_CHOICE);
        if (value == null || value.equals("")) {
            this.setDisplayFieldValue(RADIO_CHOICE, "centralized");
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) {
        AgentsModel model = (AgentsModel)this.getModel();
        String agentType = this.getAgentType();
        AMPropertySheet prop = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
        String agentName = (String)this.propertySheetModel.getValue(TF_NAME);
        agentName = agentName.trim();
        String password = (String)this.propertySheetModel.getValue(TF_PASSWORD);
        String passwordConfirm = (String)this.propertySheetModel.getValue(TF_PASSWORD_CONFIRM);
        password = password.trim();
        passwordConfirm = passwordConfirm.trim();
        String choice = (String)this.propertySheetModel.getValue(RADIO_CHOICE);
        if (password.length() > 0) {
            if (password.equals(passwordConfirm)) {
                try {
                    String curRealm = (String)this.getPageSessionAttribute("currentRealm");
                    if (agentType.equals("J2EEAgent") || agentType.equals("WebAgent")) {
                        if (choice.equals("local")) {
                            model.createAgent(curRealm, agentName, agentType, password, choice);
                        } else {
                            String serverURL = (String)this.propertySheetModel.getValue(TF_SERVER_URL);
                            serverURL = serverURL.trim();
                            String agentURL = (String)this.propertySheetModel.getValue(TF_AGENT_URL);
                            agentURL = agentURL.trim();
                            model.createAgent(curRealm, agentName, agentType, password, serverURL, agentURL);
                        }
                    } else {
                        model.createAgent(curRealm, agentName, agentType, password, choice);
                    }
                    this.forwardToAgentsViewBean();
                }
                catch (AMConsoleException e) {
                    this.setInlineAlertMessage("error", "message.error", e.getMessage());
                    this.forwardTo();
                }
            } else {
                this.setInlineAlertMessage("error", "message.error", model.getLocalizedString("agents.passwords.not.match"));
                this.forwardTo();
            }
        } else {
            this.setInlineAlertMessage("error", "message.error", model.getLocalizedString("agents.password.blank"));
            this.forwardTo();
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardToAgentsViewBean();
    }

    private void forwardToAgentsViewBean() {
        AgentsViewBean vb = (AgentsViewBean)this.getViewBean(AgentsViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    protected boolean startPageTrail() {
        return false;
    }

    private String getAgentType() {
        return (String)this.getPageSessionAttribute("superagenttype");
    }
}

