/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.validation;

import com.sun.identity.common.validation.ValidatorBase;
import com.sun.identity.shared.validation.ValidationException;

public class XSDurationValidator
extends ValidatorBase {
    private static XSDurationValidator instance = new XSDurationValidator();
    private static boolean debug = false;

    private XSDurationValidator() {
    }

    public static XSDurationValidator getInstance() {
        return instance;
    }

    protected void performValidation(String strData) throws ValidationException {
        if (strData == null || strData.trim().length() == 0 || strData.trim().length() < 3) {
            throw new ValidationException("amValidation", "errorCode4");
        }
        if (strData.charAt(0) != 'P') {
            throw new ValidationException("amValidation", "errorCode4");
        }
        String timeStr = null;
        String dateStr = null;
        if (strData.indexOf(84) != -1) {
            if (strData.charAt(strData.length() - 1) == 'T') {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int strIndex = strData.indexOf("T");
            timeStr = strData.substring(strIndex + 1, strData.length());
            dateStr = strData.substring(1, strIndex);
        } else {
            if (strData.indexOf("H") != -1 || strData.indexOf("S") != -1) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            dateStr = strData.substring(1);
        }
        boolean start = false;
        this.processTimeStr(timeStr);
        this.processDateStr(dateStr);
    }

    private int getIntegerValue(String strData, int start, int end) throws ValidationException {
        int value = 0;
        String str = strData.substring(start, end);
        try {
            value = Integer.parseInt(str);
            if (value < 0) {
                throw new ValidationException("amValidation", "errorCode4");
            }
        }
        catch (NumberFormatException e) {
            throw new ValidationException("amValidation", "errorCode4");
        }
        return value;
    }

    private double getDoubleValue(String strData, int start, int end) throws ValidationException {
        double value = 0.0;
        String str = strData.substring(start, end);
        try {
            value = Double.parseDouble(str);
            if (value < 0.0) {
                throw new ValidationException("amValidation", "errorCode4");
            }
        }
        catch (NumberFormatException e) {
            throw new ValidationException("amValidation", "errorCode4");
        }
        return value;
    }

    private void processTimeStr(String timeStr) throws ValidationException {
        if (timeStr != null) {
            if (timeStr.indexOf("Y") != -1 || timeStr.indexOf("D") != -1) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int idxH = timeStr.indexOf(72);
            int idxM = timeStr.indexOf(77);
            int idxS = timeStr.indexOf(83);
            if (idxH != -1 && (idxM != -1 && idxM < idxH || idxS != -1 && idxS < idxH)) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            if (idxM != -1 && idxS != -1 && idxS < idxM) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int start = 0;
            if (idxH != -1) {
                int a = this.getIntegerValue(timeStr, start, idxH);
                idxM = timeStr.indexOf(77, idxH + 1);
                start = idxH + 1;
            }
            if (idxM != -1) {
                int b = this.getIntegerValue(timeStr, start, idxM);
                idxS = timeStr.indexOf(83, idxM + 1);
                start = idxM + 1;
            }
            if (idxS != -1) {
                if (timeStr.charAt(idxS - 1) == '.') {
                    throw new ValidationException("amValidation", "errorCode4");
                }
                this.getDoubleValue(timeStr, start, idxS);
            }
        }
    }

    private void processDateStr(String dateStr) throws ValidationException {
        if (dateStr != null) {
            if (dateStr.indexOf("H") != 1 && dateStr.indexOf("S") != -1) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int idxY = dateStr.indexOf(89);
            int idxM = dateStr.indexOf(77);
            int idxD = dateStr.indexOf(68);
            if (idxY != -1 && (idxM != -1 && idxM < idxY || idxD != -1 && idxD < idxY)) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            if (idxM != -1 && idxD != -1 && idxD < idxM) {
                throw new ValidationException("amValidation", "errorCode4");
            }
            int start = 0;
            if (idxY != -1) {
                this.getIntegerValue(dateStr, start, idxY);
                idxM = dateStr.indexOf(77, idxY + 1);
                start = idxY + 1;
            }
            if (idxM != -1) {
                this.getIntegerValue(dateStr, start, idxM);
                idxD = dateStr.indexOf(68, idxM + 1);
                start = idxM + 1;
            }
            if (idxD != -1) {
                this.getIntegerValue(dateStr, start, idxD);
            }
        }
    }

    public static void main(String[] args) {
        if (args[0] != null) {
            debug = Boolean.valueOf(args[0]);
        }
        XSDurationValidator inst = XSDurationValidator.getInstance();
        try {
            inst.validate("P1Y2M4D");
            inst.validate("PT9H8M1.1S");
            inst.validate("PT9H");
            inst.validate("PT9M");
            inst.validate("PT9S");
            inst.validate("PT9H8M111S");
            inst.validate("P1Y2M4DT9H8M20S");
            inst.validate("P1Y2M4D");
            inst.validate("P1Y2MD");
            inst.validate("P1Y2M4DT");
            inst.validate("P1Y2M4DT1.S");
            inst.validate("1Y2M4DT9H8MS");
            inst.validate("P1Y2M4DT9H8M20S");
            inst.validate("P1Y2M4DT9H8MS");
        }
        catch (ValidationException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception ee) {
            System.out.println("Error " + ee.getMessage());
        }
    }
}

