/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ServerConfigXML
implements Serializable {
    private ServerGroup defaultServerGroup;
    private ServerGroup smsServerGroup;

    public ServerConfigXML(String xml) throws Exception {
        Document doc = XMLUtils.getXMLDocument((InputStream)AMAdminUtils.getInputStreamFromString(xml));
        Node root = XMLUtils.getRootNode((Document)doc, (String)"iPlanetDataAccessLayer");
        this.defaultServerGroup = new ServerGroup(XMLUtils.getNamedChildNode((Node)root, (String)"ServerGroup", (String)"name", (String)"default"));
        this.smsServerGroup = new ServerGroup(XMLUtils.getNamedChildNode((Node)root, (String)"ServerGroup", (String)"name", (String)"sms"));
    }

    public ServerGroup getDefaultServerGroup() {
        return this.defaultServerGroup;
    }

    public ServerGroup getSMSServerGroup() {
        return this.smsServerGroup;
    }

    public String toXML() {
        StringBuffer buff = new StringBuffer();
        buff.append("<").append("iPlanetDataAccessLayer").append(">\n");
        buff.append(this.defaultServerGroup.toXML("default"));
        buff.append(this.smsServerGroup.toXML("sms"));
        buff.append("</").append("iPlanetDataAccessLayer").append(">\n");
        return buff.toString();
    }

    public class DirUserObject
    implements Serializable {
        public String name;
        public String type;
        public String dn;
        public String password;

        public DirUserObject(Node node) {
            Element elm = (Element)node;
            this.name = elm.getAttribute("name");
            this.type = elm.getAttribute("type");
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (n.getNodeName().equalsIgnoreCase("DirDN")) {
                    this.dn = ((Text)n.getFirstChild()).getNodeValue();
                    continue;
                }
                if (!n.getNodeName().equalsIgnoreCase("DirPassword")) continue;
                this.password = ((Text)n.getFirstChild()).getNodeValue();
            }
        }

        public String toXML() {
            StringBuffer buff = new StringBuffer();
            buff.append("<").append("User").append(" ").append("name").append("=\"").append(this.name).append("\"").append(" ").append("type").append("=\"").append(this.type).append("\"").append(">\n");
            buff.append("<").append("DirDN").append(">");
            buff.append(this.dn);
            buff.append("</").append("DirDN").append(">\n");
            buff.append("<").append("DirPassword").append(">");
            buff.append(this.password);
            buff.append("</").append("DirPassword").append(">\n");
            buff.append("</User>\n");
            return buff.toString();
        }
    }

    public class ServerObject
    implements Serializable {
        public String name;
        public String host;
        public String port;
        public String type;

        public ServerObject() {
        }

        public ServerObject(Node node) {
            Element elm = (Element)node;
            this.name = elm.getAttribute("name");
            this.host = elm.getAttribute("host");
            this.port = elm.getAttribute("port");
            this.type = elm.getAttribute("type");
        }

        public String toXML() {
            StringBuffer buff = new StringBuffer();
            buff.append("<").append("Server").append(" ").append("name").append("=\"").append(this.name).append("\"").append(" ").append("host").append("=\"").append(this.host).append("\"").append(" ").append("port").append("=\"").append(this.port).append("\"").append(" ").append("type").append("=\"").append(this.type).append("\"").append(" />\n");
            return buff.toString();
        }
    }

    public class ServerGroup
    implements Serializable {
        public int minPool;
        public int maxPool;
        public List hosts = new ArrayList();
        public List dsUsers = new ArrayList();
        public String dsBaseDN;

        public ServerGroup(Node node) {
            Element elm = (Element)node;
            this.minPool = Integer.parseInt(elm.getAttribute("minConnPool"));
            this.maxPool = Integer.parseInt(elm.getAttribute("maxConnPool"));
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node n = children.item(i);
                if (n.getNodeName().equalsIgnoreCase("Server")) {
                    this.hosts.add(new ServerObject(n));
                    continue;
                }
                if (n.getNodeName().equals("User")) {
                    this.dsUsers.add(new DirUserObject(n));
                    continue;
                }
                if (!n.getNodeName().equals("BaseDN")) continue;
                this.dsBaseDN = ((Text)n.getFirstChild()).getNodeValue();
            }
        }

        public void addHost(String name, String host, String port, String type) throws ConfigurationException {
            Iterator i = this.hosts.iterator();
            while (i.hasNext()) {
                ServerObject test = (ServerObject)i.next();
                if (!test.name.equals(name)) continue;
                Object[] param = new String[]{name};
                throw new ConfigurationException("exception.serverconfig.xml.server.name.exist", param);
            }
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                Object[] param = new String[]{port};
                throw new ConfigurationException("exception.serverconfig.xml.port.number.no.integer", param);
            }
            ServerObject obj = new ServerObject();
            obj.name = name;
            obj.host = host;
            obj.port = port;
            obj.type = type;
            this.hosts.add(obj);
        }

        public String toXML(String groupName) {
            Serializable s;
            StringBuffer buff = new StringBuffer();
            buff.append("<").append("ServerGroup").append(" ").append("name").append("=\"").append(groupName).append("\"").append(" ").append("minConnPool").append("=\"").append(Integer.toString(this.minPool)).append("\"").append(" ").append("maxConnPool").append("=\"").append(Integer.toString(this.maxPool)).append("\"").append(">\n");
            Iterator i = this.hosts.iterator();
            while (i.hasNext()) {
                s = (ServerObject)i.next();
                buff.append(((ServerObject)s).toXML());
            }
            i = this.dsUsers.iterator();
            while (i.hasNext()) {
                s = (DirUserObject)i.next();
                buff.append(((DirUserObject)s).toXML());
            }
            buff.append("<").append("BaseDN").append(">");
            buff.append(this.dsBaseDN);
            buff.append("</").append("BaseDN").append(">\n");
            buff.append("</").append("ServerGroup").append(">\n");
            return buff.toString();
        }
    }
}

