/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.event.EventService;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.LDAPConnPoolUtils;
import com.sun.identity.common.LDAPConnectionPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class FallBackManager
extends GeneralTaskRunnable {
    public static Debug debug = Debug.getInstance("LDAPConnectionPool");
    private static final long DEFAULT_SERVER_CHECK_INTERVAL = 15L;
    private long sleepTime;
    private volatile long runPeriod;

    public FallBackManager() {
        block5: {
            this.sleepTime = 15L;
            String sleepTimeStr = SystemProperties.get("com.sun.am.ldap.fallback.sleep.minutes");
            if (debug.messageEnabled()) {
                debug.message("FallBackManager:constructor().sleepTime in minutes." + sleepTimeStr);
            }
            if (sleepTimeStr != null && sleepTimeStr.length() > 0) {
                try {
                    this.sleepTime = Long.parseLong(sleepTimeStr);
                }
                catch (NumberFormatException nex) {
                    if (!debug.messageEnabled()) break block5;
                    debug.message("Server Check Interval is not set\nfor fallback. Setting it to default value 15 min");
                }
            }
        }
        this.sleepTime *= 60000L;
        if (debug.messageEnabled()) {
            debug.message("FallBackManager:constructor().sleepTime in seconds." + this.sleepTime);
        }
    }

    public long getRunPeriod() {
        return this.runPeriod;
    }

    public boolean addElement(Object obj) {
        return false;
    }

    public boolean removeElement(Object obj) {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean foundDown;
        block14: {
            foundDown = false;
            try {
                if (LDAPConnPoolUtils.connectionPoolsStatus == null || LDAPConnPoolUtils.connectionPoolsStatus.isEmpty()) break block14;
                HashMap hashMap = LDAPConnPoolUtils.connectionPoolsStatus;
                synchronized (hashMap) {
                    Set keyset1 = LDAPConnPoolUtils.connectionPoolsStatus.keySet();
                    Iterator iter1 = keyset1.iterator();
                    while (iter1.hasNext()) {
                        String key = (String)iter1.next();
                        LDAPConnectionPool fbConn = (LDAPConnectionPool)LDAPConnPoolUtils.connectionPoolsStatus.get(key);
                        foundDown = true;
                        StringTokenizer st = new StringTokenizer(key, ":");
                        String downName = st.nextToken();
                        String downHost = st.nextToken();
                        String downPort = st.nextToken();
                        if (debug.messageEnabled()) {
                            debug.message("FallBackManager:Checking for server:- " + key);
                            debug.message("FallBackManager:downHost " + downHost);
                            debug.message("FallBackManager:downPort " + downPort);
                        }
                        if (downHost == null || downHost.length() == 0 || downPort == null || downPort.length() == 0) continue;
                        int intPort = Integer.valueOf(downPort);
                        try {
                            LDAPConnection ldapConn = new LDAPConnection();
                            ldapConn.connect(downHost, intPort);
                            if (ldapConn.isConnected()) {
                                fbConn.fallBack(ldapConn);
                                try {
                                    EventService.getEventService().resetAllSearches(false);
                                }
                                catch (Exception ee) {
                                    debug.error("FallBackManager: Error while interrupting the eventservice.", ee);
                                }
                            }
                            ldapConn.disconnect();
                        }
                        catch (LDAPException e) {}
                    }
                }
            }
            catch (Exception exp) {
                debug.error("FallBackManager:Error in FallBack Manager Thread", exp);
            }
        }
        if (!foundDown) {
            this.runPeriod = -1L;
            this.setHeadTask(null);
            debug.message("Returning back from FallBackManager thread." + foundDown);
            debug.message("exiting FallBackManager thread..");
        } else {
            this.runPeriod = this.sleepTime;
        }
    }
}

