/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class CaseInsensitiveTreeSet
extends TreeSet {
    public CaseInsensitiveTreeSet() {
        super(String.CASE_INSENSITIVE_ORDER);
    }

    public CaseInsensitiveTreeSet(boolean ascendingOrder) {
        super(ascendingOrder ? String.CASE_INSENSITIVE_ORDER : new DescendingComparator());
    }

    public CaseInsensitiveTreeSet(Collection c) {
        this(true, c);
    }

    public CaseInsensitiveTreeSet(boolean ascendingOrder, Collection c) {
        this(ascendingOrder);
        if (c != null) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
        }
    }

    public CaseInsensitiveTreeSet(SortedSet set) {
        this(true, set);
    }

    public CaseInsensitiveTreeSet(boolean ascendingOrder, SortedSet set) {
        this(ascendingOrder);
        if (set != null) {
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
        }
    }

    private static class DescendingComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof String ? (String)o1 : String.valueOf(o1);
            String s2 = o2 instanceof String ? (String)o2 : String.valueOf(o2);
            return String.CASE_INSENSITIVE_ORDER.compare(s2, s1);
        }

        public boolean equals(Object o) {
            return ((Object)String.CASE_INSENSITIVE_ORDER).equals(o);
        }
    }
}

