/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMInvalidDNException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMUserPasswordValidation;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMUserPasswordValidationPlugin
extends AMUserPasswordValidation
implements AMConstants {
    static Debug debug = Debug.getInstance((String)"amProfile_ldap");
    private static String SEPERATOR = "|";

    public void validateUserID(String userID, Map envParams) throws AMException {
        StringBuffer errorString = new StringBuffer(10);
        SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        String orgDN = (String)envParams.get("organization_name");
        String regEx = this.getOrgUserInvalidChars(orgDN, token);
        if (userID == null || userID.length() == 0) {
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : Source string is null or empty" + userID);
            throw new AMInvalidDNException(AMSDKBundle.getString("157"), "157");
        }
        if (regEx == null || regEx.length() == 0) {
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : List of invalid characters is null or empty" + regEx);
            throw new AMInvalidDNException(AMSDKBundle.getString("157"), "157");
        }
        StringTokenizer st = new StringTokenizer(regEx, SEPERATOR);
        while (st.hasMoreTokens()) {
            String obj = st.nextToken();
            if (userID.indexOf(obj) <= -1) continue;
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : Detected invalid chars ...");
            debug.error("AMUserPasswordValidationPlugin.validateUserID() : User Name validation Failed:" + obj);
            errorString.append(obj).append(" ");
        }
        Object[] args = new Object[]{userID, errorString.toString()};
        if (errorString.length() != 0) {
            throw new AMException(AMSDKBundle.getString("1002", args), "1002", args);
        }
    }

    private String getOrgUserInvalidChars(String orgDN, SSOToken token) {
        try {
            ServiceConfig sc = AMServiceUtils.getOrgConfig(token, orgDN, "iPlanetAMAdminConsoleService");
            if (sc != null) {
                Map attributes = sc.getAttributes();
                Set value = (Set)attributes.get("iplanet-am-admin-console-invalid-chars");
                return value == null || value.isEmpty() ? null : (String)value.iterator().next();
            }
            return this.getGlobalUserInvalidChars(token);
        }
        catch (Exception ee) {
            return this.getGlobalUserInvalidChars(token);
        }
    }

    private String getGlobalUserInvalidChars(SSOToken token) {
        block4: {
            if (debug.messageEnabled()) {
                debug.message("AMUserPasswordValidationPlugin.getGlobalUserInvalidChars(): Organization config for service (iPlanetAMAdminConsoleService,iplanet-am-admin-console-invalid-chars) not found. Obtaining default service config values ..");
            }
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(token, "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (defaultValues != null) {
                    Set value = (Set)defaultValues.get("iplanet-am-admin-console-invalid-chars");
                    return value == null || value.isEmpty() ? null : (String)value.iterator().next();
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("AMUserPasswordValidationPlugin.getGlobalUserInvalidChars(): Unable to get UserID invalid characters", (Throwable)e);
            }
        }
        return null;
    }
}

