/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class UpdateServerConfig
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String serverName = this.getStringOptionValue("servername");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        String[] params = new String[]{serverName};
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_UPDATE_SERVER_CONFIG", params);
            if (ServerConfiguration.isServerInstanceExist(adminSSOToken, serverName)) {
                try {
                    ServerConfiguration.setServerInstance(adminSSOToken, serverName, attributeValues);
                }
                catch (UnknownPropertyNameException ex) {
                    outputWriter.printlnMessage(ex.getL10NMessage(this.getCommandManager().getLocale()));
                    outputWriter.printlnMessage("");
                }
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("update-server-config-succeeded"), params));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("update-server-config-does-not-exists"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_UPDATE_SERVER_CONFIG", params);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("UpdateServerConfig.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_SERVER_CONFIG", args);
            throw new CLIException(e, 127);
        }
        catch (IOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("UpdateServerConfig.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_SERVER_CONFIG", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("UpdateServerConfig.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_SERVER_CONFIG", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("UpdateServerConfig.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UPDATE_SERVER_CONFIG", args);
            throw new CLIException(e, 127);
        }
    }
}

