/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class ShowSite
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String siteName = this.getStringOptionValue("sitename");
        String[] params = new String[]{siteName};
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_SHOW_SITE", params);
            if (SiteConfiguration.isSiteExist(adminSSOToken, siteName)) {
                String primaryURL = SiteConfiguration.getSitePrimaryURL(adminSSOToken, siteName);
                Set failoverURLs = SiteConfiguration.getSiteSecondaryURLs(adminSSOToken, siteName);
                Object[] args = new Object[]{primaryURL};
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("show-site-primaryURL"), args));
                if (failoverURLs != null && !failoverURLs.isEmpty()) {
                    outputWriter.printlnMessage(this.getResourceString("show-site-secondaryURL"));
                    Iterator i = failoverURLs.iterator();
                    while (i.hasNext()) {
                        outputWriter.printlnMessage((String)i.next());
                    }
                } else {
                    outputWriter.printlnMessage(this.getResourceString("show-site-no-secondaryURL"));
                }
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("show-site-no-exists"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SHOW_SITE", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("ShowSite.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SHOW_SITE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("ShowSite.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SHOW_SITE", args);
            throw new CLIException(e, 127);
        }
    }
}

