/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class ListServers
extends AuthenticatedCommand {
    private static final String SERVER_CONFIG_XML_FILE = "serverconfigxml";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{};
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_LIST_SERVERS", params);
            Set servers = ServerConfiguration.getServers(adminSSOToken);
            if (servers != null && !servers.isEmpty()) {
                Iterator i = servers.iterator();
                while (i.hasNext()) {
                    outputWriter.printlnMessage((String)i.next());
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("list-servers-no-instances"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_LIST_SERVERS", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("ListServers.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_LIST_SERVERS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("ListServers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_LIST_SERVERS", args);
            throw new CLIException(e, 127);
        }
    }
}

