/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class DeleteSite
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String siteName = this.getStringOptionValue("sitename");
        String[] params = new String[]{siteName};
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_SITE", params);
            if (SiteConfiguration.isSiteExist(adminSSOToken, siteName)) {
                SiteConfiguration.deleteSite(adminSSOToken, siteName);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-site-succeeded"), params));
            } else {
                outputWriter.printlnMessage(this.getResourceString("delete-site-no-exists"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_SITE", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("DeleteSite.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SITE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("DeleteSite.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_SITE", args);
            throw new CLIException(e, 127);
        }
    }
}

