/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class RemoveAttributeSchemas
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        List attributeSchemaNames = rc.getOption("attributeschema");
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        String attributeSchemaName = null;
        try {
            Iterator i = attributeSchemaNames.iterator();
            while (i.hasNext()) {
                attributeSchemaName = (String)i.next();
                String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName};
                this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_ATTRIBUTE_SCHEMA", params);
                ss.removeAttributeSchema(attributeSchemaName);
                this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_ATTRIBUTE_SCHEMA", params);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("remove-attribute-schema-succeed"), params));
            }
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, e.getMessage()};
            this.debugError("RemoveAttributeSchemas.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_ATTRIBUTE_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeSchemaName, e.getMessage()};
            this.debugError("RemoveAttributeSchemas.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_ATTRIBUTE_SCHEMA", args);
            throw new CLIException(e, 127);
        }
    }
}

