/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class RemoveAttributeSchemaChoiceValues
extends SchemaCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String schemaType = this.getStringOptionValue("schematype");
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String attributeName = this.getStringOptionValue("attributename");
        List choiceValues = rc.getOption("choicevalues");
        ServiceSchema ss = this.getServiceSchema();
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{serviceName, schemaType, subSchemaName, attributeName};
        this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_ATTRIBUTE_SCHEMA_CHOICE_VALUE", params);
        try {
            AttributeSchema attrSchema = ss.getAttributeSchema(attributeName);
            Iterator i = choiceValues.iterator();
            while (i.hasNext()) {
                String choiceValue = (String)i.next();
                attrSchema.removeChoiceValue(choiceValue);
            }
            this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_ATTRIBUTE_SCHEMA_CHOICE_VALUE", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("attribute-schema-remove-choice-value-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("RemoveAttributeSchemaChoiceValues.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_ATTRIBUTE_SCHEMA_CHOICE_VALUE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, subSchemaName, attributeName, e.getMessage()};
            this.debugError("RemoveAttributeSchemaChoiceValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_ATTRIBUTE_SCHEMA_CHOICE_VALUE", args);
            throw new CLIException(e, 127);
        }
    }
}

