/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class AddPluginInterface
extends SchemaCommand {
    static final String ARGUMENT_I18N_KEY = "i18nkey";
    static final String ARGUMENT_PLUGIN_NAME = "pluginname";
    static final String ARGUMENT_INTERFACE_NAME = "interfacename";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        String serviceName = this.getStringOptionValue("servicename");
        String i18nKey = this.getStringOptionValue(ARGUMENT_I18N_KEY);
        String interfaceName = this.getStringOptionValue(ARGUMENT_INTERFACE_NAME);
        String pluginName = this.getStringOptionValue(ARGUMENT_PLUGIN_NAME);
        ServiceSchemaManager ssm = this.getServiceSchemaManager();
        IOutput outputWriter = this.getOutputWriter();
        try {
            String[] params = new String[]{serviceName, pluginName};
            this.writeLog(0, Level.INFO, "ATTEMPT_ADD_PLUGIN_INTERFACE", params);
            ssm.addPluginInterface(pluginName, interfaceName, i18nKey);
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_PLUGIN_INTERFACE", params);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-plugin-interface-succeed"), params));
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, pluginName, e.getMessage()};
            this.debugError("AddPluginInterface.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_PLUGIN_INTERFACE", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, pluginName, e.getMessage()};
            this.debugError("AddPluginInterface.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_PLUGIN_INTERFACE", args);
            throw new CLIException(e, 127);
        }
    }
}

