/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.Debugger;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.schema.SchemaCommand;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class AddAttributeSchema
extends SchemaCommand {
    static final String ARGUMENT_SCHEMA_FILES = "attributeschemafile";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        List listContinues = rc.getOption("continue");
        boolean continueFlag = listContinues != null;
        IOutput outputWriter = this.getOutputWriter();
        List fileNames = rc.getOption(ARGUMENT_SCHEMA_FILES);
        String serviceName = this.getStringOptionValue("servicename");
        String schemaType = this.getStringOptionValue("schematype");
        ServiceSchema ss = this.getServiceSchema();
        CommandManager mgr = this.getCommandManager();
        String url = mgr.getWebEnabledURL();
        if (url != null && url.length() > 0) {
            String[] param = new String[]{"web-input"};
            this.writeLog(0, Level.INFO, "ATTEMPT_ADD_ATTRIBUTE_SCHEMA", param);
            this.addAttributeSchemaXML(ss, serviceName, schemaType, (String)fileNames.iterator().next());
            outputWriter.printlnMessage(this.getResourceString("attribute-schema-added"));
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_ATTRIBUTE_SCHEMA", param);
        } else {
            Iterator i = fileNames.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String[] param = new String[]{serviceName, schemaType, name};
                try {
                    this.writeLog(0, Level.INFO, "ATTEMPT_ADD_ATTRIBUTE_SCHEMA", param);
                    this.addAttributeSchema(ss, serviceName, schemaType, name);
                    outputWriter.printlnMessage(this.getResourceString("attribute-schema-added"));
                    this.writeLog(0, Level.INFO, "SUCCEED_ADD_ATTRIBUTE_SCHEMA", param);
                }
                catch (CLIException e) {
                    if (continueFlag) {
                        outputWriter.printlnError(this.getResourceString("add-attribute-schema-failed") + e.getMessage());
                        if (!this.isVerbose()) continue;
                        outputWriter.printlnError(Debugger.getStackTrace(e));
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    private void addAttributeSchemaXML(ServiceSchema ss, String serviceName, String schemaType, String xml) throws CLIException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(xml.getBytes());
            ss.addAttributeSchema(bis);
        }
        catch (SSOException e) {
            String[] args = new String[]{"web-input", schemaType, xml, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_ATTRIBUTE_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{"web-input", schemaType, xml, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_ATTRIBUTE_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ie) {}
            }
        }
    }

    private void addAttributeSchema(ServiceSchema ss, String serviceName, String schemaType, String fileName) throws CLIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            ss.addAttributeSchema(fis);
        }
        catch (IOException e) {
            String[] args = new String[]{serviceName, schemaType, fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_ATTRIBUTE_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serviceName, schemaType, fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_ATTRIBUTE_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serviceName, schemaType, fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_ADD_ATTRIBUTE_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ie) {}
            }
        }
    }
}

