/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;

public class RealmUnassignService
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        IOutput outputWriter = this.getOutputWriter();
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            Set assignedServices = ocm.getAssignedServices();
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            AMIdentity ai = amir.getRealmIdentity();
            Set dynAssignedServices = ai.getAssignedServices();
            String[] params = new String[]{realm, serviceName};
            boolean unassigned = false;
            if (assignedServices.contains(serviceName)) {
                this.writeLog(0, Level.INFO, "ATTEMPT_UNASSIGN_SERVICE_FROM_REALM", params);
                ocm.unassignService(serviceName);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("unassign-service-from-realm-succeed"), params));
                this.writeLog(0, Level.INFO, "SUCCEED_UNASSIGN_SERVICE_FROM_REALM", params);
                unassigned = true;
            }
            if (dynAssignedServices.contains(serviceName)) {
                this.writeLog(0, Level.INFO, "ATTEMPT_UNASSIGN_SERVICE_FROM_REALM", params);
                ai.unassignService(serviceName);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("unassign-service-from-realm-succeed"), params));
                this.writeLog(0, Level.INFO, "SUCCEED_UNASSIGN_SERVICE_FROM_REALM", params);
                unassigned = true;
            }
            if (!unassigned) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("unassign-service-from-realm-service-not-assigned"), params));
            }
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmUnassignService.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_UNASSIGN_SERVICE_FROM_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmUnassignService.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UNASSIGN_SERVICE_FROM_REALM", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmUnassignService.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_UNASSIGN_SERVICE_FROM_REALM", args);
            throw new CLIException(e, 127);
        }
    }
}

