/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RealmSetAttributeValues
extends AuthenticatedCommand {
    private static final String OPT_APPEND = "append";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        boolean bAppend = this.isOptionSet(OPT_APPEND);
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            if (bAppend) {
                Iterator i = attributeValues.keySet().iterator();
                while (i.hasNext()) {
                    String attributeName = (String)i.next();
                    String[] params = new String[]{realm, serviceName, attributeName};
                    Set values = (Set)attributeValues.get(attributeName);
                    this.writeLog(0, Level.INFO, "ATTEMPT_ADD_ATTR_VALUES_REALM", params);
                    ocm.addAttributeValues(serviceName, attributeName, values);
                    this.writeLog(0, Level.INFO, "SUCCEED_ADD_ATTR_VALUES_REALM", params);
                    outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("add-attribute-values-realm-succeed"), params));
                }
            } else {
                String[] params = new String[]{realm, serviceName};
                this.writeLog(0, Level.INFO, "ATTEMPT_SET_ATTR_VALUES_REALM", params);
                ocm.setAttributes(serviceName, attributeValues);
                this.writeLog(0, Level.INFO, "SUCCEED_SET_ATTR_VALUES_REALM", params);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("set-attribute-values-realm-succeed"), params));
            }
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmSetAttributeValues.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_ATTR_VALUES_REALM", args);
            throw new CLIException(e, 127);
        }
    }
}

