/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class DeleteIdentities
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        List idNames = rc.getOption("idnames");
        String type = this.getStringOptionValue("idtype");
        String displayableIdNames = this.tokenize(idNames);
        String[] params = new String[]{realm, type, displayableIdNames};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_IDENTITY", params);
        try {
            new OrganizationConfigManager(adminSSOToken, realm);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, type, displayableIdNames, e.getMessage()};
            this.debugError("DeleteIdentities.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_IDENTITY", args);
            Object[] msgArg = new Object[]{realm};
            throw new CLIException(MessageFormat.format(this.getResourceString("realm-does-not-exist"), msgArg), 127);
        }
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            IdType idType = this.convert2IdType(type);
            HashSet<AMIdentity> setDelete = new HashSet<AMIdentity>();
            Iterator i = idNames.iterator();
            while (i.hasNext()) {
                String idName = (String)i.next();
                AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
                setDelete.add(amid);
            }
            amir.deleteIdentities(setDelete);
            IOutput outputWriter = this.getOutputWriter();
            Object[] objects = new Object[]{realm, type};
            if (idNames.size() > 1) {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-identities-succeed"), objects));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("delete-identity-succeed"), objects));
            }
            Iterator i2 = idNames.iterator();
            while (i2.hasNext()) {
                outputWriter.printlnMessage("    " + (String)i2.next());
            }
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_IDENTITY", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, displayableIdNames, e.getMessage()};
            this.debugError("DeleteIdentities.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_IDENTITY", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, displayableIdNames, e.getMessage()};
            this.debugError("DeleteIdentities.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_DELETE_IDENTITY", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

