/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.datastore;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.Map;
import java.util.Set;

public class ShowDataStore
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String name = this.getStringOptionValue("name");
        String[] params = new String[]{realm, name};
        this.writeLog(0, Level.INFO, "ATTEMPT_SHOW_DATASTORE", params);
        try {
            ServiceConfigManager svcCfgMgr = new ServiceConfigManager("sunIdentityRepositoryService", adminSSOToken);
            ServiceConfig cfg = svcCfgMgr.getOrganizationConfig(realm, null);
            if (cfg != null) {
                ServiceConfig ss = cfg.getSubConfig(name);
                if (ss != null) {
                    Set passwords = CLIUtil.getPasswordFields("sunIdentityRepositoryService", SchemaType.ORGANIZATION, ss.getSchemaID());
                    Map attributesValues = ss.getAttributes();
                    this.getOutputWriter().printlnMessage(FormatUtils.printAttributeValues("{0}={1}", attributesValues, passwords));
                } else {
                    this.getOutputWriter().printlnMessage(this.getResourceString("datastore-show-datastore-not-found"));
                }
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("datastore-show-datastore-not-found"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_SHOW_DATASTORE", params);
        }
        catch (SMSException e) {
            String[] p = new String[]{realm, name, e.getMessage()};
            this.debugError("ShowDataStore.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_SHOW_DATASTORE", p);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] p = new String[]{realm, name, e.getMessage()};
            this.debugError("ShowDataStore.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_SHOW_DATASTORE", p);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

