/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMAuthenticationSchema;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.FormatUtils;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import com.sun.identity.sm.SMSException;
import java.util.Map;

public class GetAuthInstance
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String instanceName = this.getStringOptionValue("name");
        String[] params = new String[]{realm, instanceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_AUTH_INSTANCE", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realm);
            AMAuthenticationInstance ai = mgr.getAuthenticationInstance(instanceName);
            if (ai != null) {
                IOutput outputWriter = this.getOutputWriter();
                Map attributeValues = ai.getAttributeValues();
                if (attributeValues != null && !attributeValues.isEmpty()) {
                    AMAuthenticationSchema schema = mgr.getAuthenticationSchema(ai.getType());
                    String serviceName = schema.getServiceName();
                    outputWriter.printlnMessage(this.getResourceString("authentication-get-auth-instance-succeeded"));
                    outputWriter.printlnMessage(FormatUtils.printAttributeValues(this.getResourceString("authentication-get-auth-instance-result"), attributeValues, CLIUtil.getPasswordFields(serviceName)));
                } else {
                    outputWriter.printlnMessage(this.getResourceString("authentication-get-auth-instance-no-values"));
                }
            } else {
                this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_INSTANCE", params);
                throw new CLIException(this.getResourceString("authentication-get-auth-instance-not-found"), 127);
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_GET_AUTH_INSTANCE", params);
        }
        catch (SSOException e) {
            this.debugError("GetAuthInstance.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_INSTANCE", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            this.debugError("GetAuthInstance.handleRequest", e);
            this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_INSTANCE", params);
            throw new CLIException(e, 127);
        }
        catch (AMConfigurationException e) {
            this.debugError("GetAuthInstance.handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_GET_AUTH_INSTANCE", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

