/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.authentication;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.log.Level;
import java.util.Iterator;
import java.util.List;

public class DeleteAuthInstances
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        List names = rc.getOption("names");
        String[] params = new String[]{realm, names.toString()};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_AUTH_INSTANCES", params);
        try {
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realm);
            Iterator i = names.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                mgr.deleteAuthenticationInstance(name);
            }
            if (names.size() == 1) {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-delete-auth-instance-succeeded"));
            } else {
                this.getOutputWriter().printlnMessage(this.getResourceString("authentication-delete-auth-instances-succeeded"));
            }
            this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_AUTH_INSTANCES", params);
        }
        catch (AMConfigurationException e) {
            this.debugError("DeleteAuthInstances,handleRequest", (Throwable)((Object)e));
            this.writeLog(0, Level.INFO, "FAILED_DELETE_AUTH_INSTANCES", params);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

