/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ShowAgentGroup
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String agentGroupName = this.getStringOptionValue("agentgroupname");
        String outfile = this.getStringOptionValue("outfile");
        String[] params = new String[]{realm, agentGroupName};
        try {
            this.writeLog(0, Level.INFO, "ATTEMPT_SHOW_AGENT_GROUP", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, agentGroupName, IdType.AGENTGROUP, realm, null);
            if (!amid.isExists()) {
                String[] args = new String[]{realm, agentGroupName, "agent group did not exist"};
                this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_GROUP", args);
                Object[] p = new Object[]{agentGroupName};
                String msg = MessageFormat.format(this.getResourceString("show-agent-group-does-not-exist"), p);
                throw new CLIException(msg, 127);
            }
            Map values = AgentConfiguration.getAgentGroupAttributes(adminSSOToken, realm, agentGroupName);
            Set passwords = AgentConfiguration.getAttributesSchemaNames(amid, AttributeSchema.Syntax.PASSWORD);
            if (values != null && !values.isEmpty()) {
                StringBuffer buff = new StringBuffer();
                Iterator i = values.keySet().iterator();
                while (i.hasNext()) {
                    String attrName = (String)i.next();
                    if (passwords.contains(attrName)) {
                        buff.append(attrName).append("=********\n");
                        continue;
                    }
                    Set vals = (Set)values.get(attrName);
                    if (vals.isEmpty()) {
                        buff.append(attrName).append("=").append("\n");
                        continue;
                    }
                    Iterator j = vals.iterator();
                    while (j.hasNext()) {
                        String val = (String)j.next();
                        buff.append(attrName).append("=").append(val).append("\n");
                    }
                }
                if (outfile == null) {
                    outputWriter.printlnMessage(buff.toString());
                } else {
                    this.writeToFile(outfile, buff.toString());
                    outputWriter.printlnMessage(this.getResourceString("show-agent-group-to-file"));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("show-agent-group-no-attributes"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_SHOW_AGENT_GROUP", params);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("ShowAgentGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("ShowAgentGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentGroupName, e.getMessage()};
            this.debugError("ShowAgentGroup.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SHOW_AGENT_GROUP", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }

    private void writeToFile(String outfile, String content) throws CLIException {
        FileOutputStream fout = null;
        PrintWriter pwout = null;
        try {
            fout = new FileOutputStream(outfile, true);
            pwout = new PrintWriter(fout, true);
            pwout.write(content);
            pwout.flush();
        }
        catch (FileNotFoundException e) {
            this.debugError("ShowAgentGroup.writeToFile", e);
            throw new CLIException(e, 24);
        }
        catch (SecurityException e) {
            this.debugError("ShowAgentGroup.writeToFile", e);
            throw new CLIException(e, 24);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
                if (pwout != null) {
                    pwout.close();
                }
            }
            catch (IOException ex) {}
        }
    }
}

