/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIRequest;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.SubCommand;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class RequestContext {
    private Map mapOptions = new HashMap();
    private CommandManager commandMgr;
    private CLIRequest request;
    private ResourceBundle rb;
    private SubCommand subCommand;

    public RequestContext(CLIRequest request, CommandManager commandMgr, SubCommand subcmd) throws CLIException {
        this.commandMgr = commandMgr;
        this.request = request;
        this.rb = commandMgr.getResourceBundle();
        this.subCommand = subcmd;
        if (commandMgr.isVerbose()) {
            commandMgr.getOutputWriter().printlnMessage(this.rb.getString("verbose-constructing-request-context"));
        }
        String[] argv = request.getOptions();
        CLIRequest parentRequest = request.getParent();
        String[] parentArgv = parentRequest != null ? parentRequest.getOptions() : null;
        this.parseArgs(commandMgr.getCommandName(), subcmd, argv, parentArgv);
        if (commandMgr.isVerbose()) {
            commandMgr.getOutputWriter().printlnMessage(this.getResourceString("verbose-validate-mandatory-options"));
        }
        if (!subcmd.validateOptions(this.mapOptions, request.getSSOToken())) {
            throw this.createIncorrectOptionException(commandMgr.getCommandName(), argv);
        }
    }

    public CommandManager getCommandManager() {
        return this.commandMgr;
    }

    public CLIRequest getCLIRequest() {
        return this.request;
    }

    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    public String getResourceString(String key) {
        return this.rb.getString(key);
    }

    public List getOption(String name) {
        return (List)this.mapOptions.get(name);
    }

    public Map getOptions() {
        return this.mapOptions;
    }

    private void parseArgs(String commandName, SubCommand subcmd, String[] argv, String[] parentArgv) throws CLIException {
        if (parentArgv != null) {
            this.parseParentArgs(commandName, subcmd, parentArgv);
        }
        this.parseArgs(commandName, subcmd, argv);
    }

    private void parseParentArgs(String commandName, SubCommand subcmd, String[] argv) throws CLIException {
        ArrayList<String> values = null;
        for (int i = 1; i < argv.length; ++i) {
            int skip;
            String option;
            String arg = argv[i];
            if (arg.startsWith("--")) {
                option = arg.substring(2);
                skip = this.skipGlobalOption(option);
                if (skip > -1) {
                    i += skip;
                    values = null;
                    continue;
                }
                if (subcmd.isSupportedOption(option)) {
                    values = new ArrayList<String>();
                    this.mapOptions.put(option, values);
                    continue;
                }
                values = null;
                continue;
            }
            if (arg.startsWith("-")) {
                option = arg.substring(1);
                skip = this.skipGlobalShortOption(option);
                if (skip > -1) {
                    i += skip;
                    values = null;
                    continue;
                }
                String longOption = subcmd.getLongOptionName(option);
                if (longOption != null) {
                    values = new ArrayList();
                    this.mapOptions.put(longOption, values);
                    continue;
                }
                values = null;
                continue;
            }
            if (values == null) continue;
            values.add(arg);
        }
    }

    private void parseArgs(String commandName, SubCommand subcmd, String[] argv) throws CLIException {
        ArrayList<String> values = null;
        for (int i = 1; i < argv.length; ++i) {
            int skip;
            String option;
            String arg = argv[i];
            if (arg.startsWith("--")) {
                option = arg.substring(2);
                skip = this.skipGlobalOption(option);
                if (skip > -1) {
                    i += skip;
                    values = null;
                    continue;
                }
                if (subcmd.isSupportedOption(option)) {
                    values = new ArrayList<String>();
                    this.mapOptions.put(option, values);
                    continue;
                }
                throw this.createIncorrectOptionException(commandName, argv);
            }
            if (arg.startsWith("-")) {
                option = arg.substring(1);
                skip = this.skipGlobalShortOption(option);
                if (skip > -1) {
                    i += skip;
                    values = null;
                    continue;
                }
                String longOption = subcmd.getLongOptionName(option);
                if (longOption == null) {
                    throw this.createIncorrectOptionException(commandName, argv);
                }
                values = new ArrayList();
                this.mapOptions.put(longOption, values);
                continue;
            }
            if (values == null) {
                throw this.createIncorrectOptionException(commandName, argv);
            }
            if (arg.trim().length() <= 0) continue;
            values.add(arg);
        }
    }

    private int skipGlobalOption(String option) {
        int skip = -1;
        if (option.equals("debug") || option.equals("verbose")) {
            skip = 0;
        } else if (option.equals("locale")) {
            skip = 1;
        }
        return skip;
    }

    private int skipGlobalShortOption(String option) {
        int skip = -1;
        if (option.equals("d") || option.equals("v")) {
            skip = 0;
        } else if (option.equals("l")) {
            skip = 1;
        }
        return skip;
    }

    private CLIException createIncorrectOptionException(String commandName, String[] argv) {
        Object[] param = new Object[]{commandName + " " + CLIRequest.addAllArgs(argv)};
        return new CLIException(MessageFormat.format(this.rb.getString("error-message-incorrect-options"), param), 11, this.subCommand.getName());
    }
}

