/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class AttributeValues {
    private AttributeValues() {
    }

    public static Map parse(CommandManager mgr, String fileName, List listAttributeValues) throws CLIException {
        Map results = null;
        if (fileName != null) {
            results = AttributeValues.parse(mgr, fileName);
        }
        if (listAttributeValues != null && !listAttributeValues.isEmpty()) {
            if (results != null) {
                results.putAll(AttributeValues.parse(mgr, listAttributeValues));
            } else {
                results = AttributeValues.parse(mgr, listAttributeValues);
            }
        }
        return results == null ? new HashMap() : results;
    }

    public static Map parse(CommandManager mgr, List listAttributeValues) throws CLIException {
        HashMap<String, HashSet<String>> attrValues = new HashMap<String, HashSet<String>>();
        if (listAttributeValues != null && !listAttributeValues.isEmpty()) {
            Iterator i = listAttributeValues.iterator();
            while (i.hasNext()) {
                String s = (String)i.next();
                boolean retry = true;
                int idx = 0;
                while (retry) {
                    if ((idx = s.indexOf(61, idx + 1)) == -1) {
                        throw AttributeValues.createIncorrectFormatException(mgr, s);
                    }
                    retry = s.charAt(idx - 1) == '\\';
                }
                String attrName = s.substring(0, idx);
                String attrValue = s.substring(idx + 1);
                if (attrName.startsWith("#")) continue;
                attrName = attrName.trim();
                attrValue = attrValue.trim();
                HashSet<String> set = (HashSet<String>)attrValues.get(attrName = AttributeValues.stripEscapeChars(attrName));
                if (set == null) {
                    set = new HashSet<String>();
                    attrValues.put(attrName, set);
                }
                set.add(attrValue);
            }
        }
        return attrValues;
    }

    public static Map parse(CommandManager mgr, String fileName) throws CLIException {
        BufferedReader in = null;
        HashMap<String, HashSet<String>> attrValues = new HashMap<String, HashSet<String>>();
        try {
            in = new BufferedReader(new FileReader(fileName));
            String line = in.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    boolean retry = true;
                    int idx = 0;
                    while (retry) {
                        if ((idx = line.indexOf(61, idx + 1)) == -1) {
                            throw AttributeValues.createIncorrectFormatException(mgr, line);
                        }
                        retry = line.charAt(idx - 1) == '\\';
                    }
                    String key = line.substring(0, idx).trim();
                    String value = line.substring(idx + 1).trim();
                    HashSet<String> values = (HashSet<String>)attrValues.get(key = AttributeValues.stripEscapeChars(key));
                    if (values == null) {
                        values = new HashSet<String>();
                        attrValues.put(key, values);
                    }
                    values.add(value);
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new CLIException(e, 24);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return attrValues;
    }

    private static String stripEscapeChars(String key) {
        StringBuffer buff = new StringBuffer();
        int idx = key.indexOf(92);
        while (idx != -1) {
            buff.append(key.substring(0, idx));
            key = key.substring(idx + 1);
            idx = key.indexOf(92);
        }
        buff.append(key);
        return buff.toString();
    }

    public static List parseValues(String fileName) throws CLIException {
        BufferedReader in = null;
        ArrayList<String> values = new ArrayList<String>();
        try {
            in = new BufferedReader(new FileReader(fileName));
            String line = in.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    values.add(line);
                }
                line = in.readLine();
            }
        }
        catch (IOException e) {
            throw new CLIException(e, 24);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return values;
    }

    public static boolean mergeAttributeValues(Map map1, Map map2, boolean bAdd) {
        boolean modified = false;
        Iterator i = map2.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Set orig = (Set)map1.get(key);
            if (orig != null && !orig.isEmpty()) {
                modified = bAdd ? orig.addAll((Set)map2.get(key)) : orig.removeAll((Set)map2.get(key));
                continue;
            }
            if (!bAdd) continue;
            map1.put(key, (Set)map2.get(key));
            modified = true;
        }
        return modified;
    }

    public static CLIException createIncorrectFormatException(CommandManager mgr, String line) {
        ResourceBundle rb = mgr.getResourceBundle();
        String[] param = new String[]{line};
        String msg = MessageFormat.format(rb.getString("exception-incorrect-data-format"), param);
        return new CLIException(msg, 26);
    }
}

