/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.AMUserPasswordValidation;
import com.iplanet.am.util.Misc;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStateCallback;
import com.sun.identity.authentication.spi.AMModuleProperties;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.HttpCallback;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.MessageLoginException;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import com.sun.identity.authentication.spi.RedirectCallback;
import com.sun.identity.authentication.spi.UserIDGenerator;
import com.sun.identity.authentication.spi.UserNamePasswordValidationException;
import com.sun.identity.authentication.util.ISValidation;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AMLoginModule
implements LoginModule {
    List internal = null;
    List external = null;
    List origList = null;
    private String fileName = null;
    boolean noCallbacks = false;
    private static Callback[] EMPTY_CALLBACK = new Callback[0];
    private int stateLength = 0;
    private ResourceBundle bundle = null;
    private LoginState loginState = null;
    private CallbackHandler handler = null;
    private Subject subject = null;
    private Map sharedState = null;
    private Map options = null;
    private static Debug debug = Debug.getInstance((String)"amLoginModule");
    private int currentState = 1;
    private final String EMPTY_STRING = "";
    private String moduleName = null;
    private String moduleClass = null;
    private static final String bundleName = "amAuth";
    private Principal principal = null;
    private boolean succeeded = false;
    private boolean isSharedState = false;
    private boolean isStore = true;
    private String sharedStateBehaviorPattern = "";
    protected static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();

    private Callback[] cloneCallbacks(int index, Callback[] original) throws AuthLoginException {
        if (original == null || original.length == 0) {
            debug.error("cloneCallbacks, no callbacks in state " + (index + 1));
            throw new AuthLoginException(bundleName, "noCallbackState", new Object[]{new Integer(index + 1)});
        }
        int len = original.length;
        Callback[] copy = new Callback[len];
        ArrayList<Callback> extCallbacks = new ArrayList<Callback>();
        for (int i = 0; i < len; ++i) {
            if (original[i] instanceof NameCallback) {
                copy[i] = new NameCallback(((NameCallback)original[i]).getPrompt());
                extCallbacks.add(copy[i]);
                if (!debug.messageEnabled()) continue;
                debug.message("clone #" + i + " is NameCallback");
                continue;
            }
            if (original[i] instanceof PasswordCallback) {
                copy[i] = new PasswordCallback(((PasswordCallback)original[i]).getPrompt(), ((PasswordCallback)original[i]).isEchoOn());
                extCallbacks.add(copy[i]);
                if (!debug.messageEnabled()) continue;
                debug.message("clone #" + i + " is PasswordCallback");
                continue;
            }
            if (original[i] instanceof TextOutputCallback) {
                copy[i] = new TextOutputCallback(((TextOutputCallback)original[i]).getMessageType(), ((TextOutputCallback)original[i]).getMessage());
                extCallbacks.add(copy[i]);
                if (!debug.messageEnabled()) continue;
                debug.message("clone #" + i + " is TextOutputCallback");
                continue;
            }
            if (original[i] instanceof PagePropertiesCallback) {
                copy[i] = new PagePropertiesCallback(((PagePropertiesCallback)original[i]).getModuleName(), ((PagePropertiesCallback)original[i]).getHeader(), ((PagePropertiesCallback)original[i]).getImage(), ((PagePropertiesCallback)original[i]).getTimeOutValue(), ((PagePropertiesCallback)original[i]).getTemplateName(), ((PagePropertiesCallback)original[i]).getErrorState(), ((PagePropertiesCallback)original[i]).getPageState());
                ((PagePropertiesCallback)copy[i]).setRequire(((PagePropertiesCallback)original[i]).getRequire());
                ((PagePropertiesCallback)copy[i]).setAttribute(((PagePropertiesCallback)original[i]).getAttribute());
                if (!debug.messageEnabled()) continue;
                debug.message("clone #" + i + " is PagePropertiesCallback");
                continue;
            }
            if (original[i] instanceof ChoiceCallback) {
                int selection = ((ChoiceCallback)original[i]).getDefaultChoice();
                copy[i] = new ChoiceCallback(((ChoiceCallback)original[i]).getPrompt(), ((ChoiceCallback)original[i]).getChoices(), selection, ((ChoiceCallback)original[i]).allowMultipleSelections());
                ((ChoiceCallback)copy[i]).setSelectedIndex(selection);
                extCallbacks.add(copy[i]);
                if (!debug.messageEnabled()) continue;
                debug.message("clone #" + i + " is ChoiceCallback");
                continue;
            }
            if (original[i] instanceof ConfirmationCallback) {
                ConfirmationCallback temp = (ConfirmationCallback)original[i];
                String prompt = temp.getPrompt();
                String[] options = temp.getOptions();
                copy[i] = prompt == null ? (options == null ? new ConfirmationCallback(temp.getMessageType(), temp.getOptionType(), temp.getDefaultOption()) : new ConfirmationCallback(temp.getMessageType(), options, temp.getDefaultOption())) : (options == null ? new ConfirmationCallback(prompt, temp.getMessageType(), temp.getOptionType(), temp.getDefaultOption()) : new ConfirmationCallback(prompt, temp.getMessageType(), options, temp.getDefaultOption()));
                extCallbacks.add(copy[i]);
                if (!debug.messageEnabled()) continue;
                debug.message("clone #" + i + " is ConfirmationCallback");
                continue;
            }
            if (original[i] instanceof TextInputCallback) {
                copy[i] = new TextInputCallback(((TextInputCallback)original[i]).getPrompt());
                extCallbacks.add(copy[i]);
                if (!debug.messageEnabled()) continue;
                debug.message("clone #" + i + " is TextInputCallback");
                continue;
            }
            if (original[i] instanceof HttpCallback) {
                HttpCallback hc = (HttpCallback)original[i];
                copy[i] = new HttpCallback(hc.getAuthorizationHeader(), hc.getNegotiationHeaderName(), hc.getNegotiationHeaderValue(), hc.getNegotiationCode());
                extCallbacks.add(copy[i]);
                continue;
            }
            if (original[i] instanceof RedirectCallback) {
                RedirectCallback rc = (RedirectCallback)original[i];
                copy[i] = new RedirectCallback(rc.getRedirectUrl(), rc.getRedirectData(), rc.getMethod(), rc.getStatusParameter(), rc.getRedirectBackUrlCookieName());
                extCallbacks.add(copy[i]);
                continue;
            }
            debug.error("unknown callback " + original[i]);
        }
        Callback[] ext = new Callback[extCallbacks.size()];
        if (extCallbacks.size() != 0) {
            Iterator it = extCallbacks.iterator();
            int i = 0;
            while (it.hasNext()) {
                ext[i++] = (Callback)it.next();
            }
        }
        this.internal.set(index, copy);
        this.external.set(index, ext);
        return ext;
    }

    public SSOToken getSSOSession() throws AuthLoginException {
        SSOToken sess = AuthD.getAuth().getSSOAuthSession();
        if (sess == null) {
            throw new AuthLoginException(bundleName, "nullSess", null);
        }
        return sess;
    }

    public Callback[] getCallback(int index) throws AuthLoginException {
        if (this.noCallbacks || this.isSharedState) {
            return EMPTY_CALLBACK;
        }
        if (this.internal == null) {
            this.origList = AMModuleProperties.getModuleProperties(this.fileName);
            if (this.origList == null || this.origList.isEmpty()) {
                this.noCallbacks = true;
                return EMPTY_CALLBACK;
            }
            this.stateLength = this.origList.size();
            this.internal = new ArrayList();
            this.external = new ArrayList();
            if (debug.messageEnabled()) {
                debug.message("callback size for state " + index + "=" + this.stateLength);
            }
            for (int i = 0; i < this.stateLength; ++i) {
                this.internal.add(null);
                this.external.add(null);
            }
        }
        if (index > this.stateLength) {
            debug.error("getCallback, state " + index + " > " + this.stateLength);
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(index)});
        }
        Object temp = this.external.get(index - 1);
        if (temp != null) {
            return (Callback[])temp;
        }
        return this.cloneCallbacks(index - 1, (Callback[])this.origList.get(index - 1));
    }

    public void replaceCallback(int state, int index, Callback callback) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("ReplaceCallback : state=" + state + ", index=" + index + ", callback=" + callback);
        }
        if (state > this.stateLength) {
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(state)});
        }
        Callback[] ext = this.getCallback(state);
        if (index < 0 || index >= ext.length) {
            throw new AuthLoginException(bundleName, "invalidCallbackIndex", new Object[]{new Integer(index)});
        }
        if (callback == null) {
            throw new AuthLoginException(bundleName, "nullCallback", null);
        }
        ext[index] = callback;
        ((Callback[])this.internal.get((int)(state - 1)))[index + 1] = callback;
    }

    public void replaceHeader(int state, String header) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("ReplaceHeader : state=" + state + ", header=" + header);
        }
        if (state > this.stateLength) {
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(state)});
        }
        Callback[] ext = this.getCallback(state);
        if (ext.length <= 0) {
            throw new AuthLoginException(bundleName, "invalidCallbackIndex", null);
        }
        if (header != null && header.length() != 0) {
            PagePropertiesCallback pc = (PagePropertiesCallback)((Callback[])this.internal.get(state - 1))[0];
            String origHeader = pc.getHeader();
            int idx = origHeader.indexOf("#REPLACE#");
            if (idx != -1) {
                String newHeader = origHeader.substring(0, idx) + header;
                pc.setHeader(newHeader);
            } else {
                String newHeader = origHeader.substring(0, origHeader.indexOf("<BR></BR>")) + "<BR></BR>" + header;
                pc.setHeader(newHeader);
            }
        }
    }

    public void resetCallback(int state, int index) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("resetCallback: state=" + state + ",index=" + index);
        }
        if (state > this.stateLength) {
            throw new AuthLoginException(bundleName, "invalidState", new Object[]{new Integer(state)});
        }
        Callback[] ext = this.getCallback(state);
        if (index < 0 || index >= ext.length) {
            throw new AuthLoginException(bundleName, "invalidCallbackIndex", new Object[]{new Integer(index)});
        }
        Callback callback = ((Callback[])this.origList.get(state - 1))[index + 1];
        Callback newCallback = null;
        if (callback instanceof NameCallback) {
            newCallback = new NameCallback(((NameCallback)callback).getPrompt());
        } else if (callback instanceof PasswordCallback) {
            newCallback = new PasswordCallback(((PasswordCallback)callback).getPrompt(), ((PasswordCallback)callback).isEchoOn());
        } else if (callback instanceof ChoiceCallback) {
            int selection = ((ChoiceCallback)callback).getDefaultChoice();
            newCallback = new ChoiceCallback(((ChoiceCallback)callback).getPrompt(), ((ChoiceCallback)callback).getChoices(), selection, ((ChoiceCallback)callback).allowMultipleSelections());
            ((ChoiceCallback)newCallback).setSelectedIndex(selection);
        } else {
            debug.error("Unsupported call back instance " + callback);
            throw new AuthLoginException(bundleName, "unknownCallback", null);
        }
        if (debug.messageEnabled()) {
            debug.message("original=" + callback + ",new=" + newCallback);
        }
        ((Callback[])this.internal.get((int)(state - 1)))[index + 1] = newCallback;
        ((Callback[])this.external.get((int)(state - 1)))[index] = newCallback;
    }

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String compositeAdvice;
        this.subject = subject;
        this.handler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".");
        this.moduleClass = className.substring(index + 1);
        this.moduleName = (String)options.get("moduleInstanceName");
        this.loginState = this.getLoginState();
        this.fileName = this.loginState.getFileName(this.moduleClass + ".xml");
        this.bundle = amCache.getResBundle(bundleName, this.getLoginLocale());
        if (debug.messageEnabled()) {
            debug.message("AMLoginModule resbundle locale=" + this.getLoginLocale());
            debug.message("Login, class = " + className + ", module=" + this.moduleName + ", file=" + this.fileName);
        }
        this.isSharedState = Boolean.valueOf(CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-shared-state-enabled", (String)"false"));
        this.isStore = Boolean.valueOf(CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-store-shared-state-enabled", (String)"true"));
        this.sharedStateBehaviorPattern = Misc.getMapAttr(options, "iplanet-am-auth-shared-state-behavior-pattern", "tryFirstPass");
        if (debug.messageEnabled()) {
            debug.message("AMLoginModuleiplanet-am-auth-shared-state-behavior-pattern is set to " + this.sharedStateBehaviorPattern);
        }
        if ((compositeAdvice = this.loginState.getCompositeAdvice()) != null) {
            if (debug.messageEnabled()) {
                debug.message("AMLoginModule.initialize: Adding Composite Advice " + compositeAdvice);
            }
            sharedState.put("CompositeAdviceXML", compositeAdvice);
        }
        this.init(subject, sharedState, options);
    }

    public abstract void init(Subject var1, Map var2, Map var3);

    public abstract int process(Callback[] var1, int var2) throws LoginException;

    public abstract Principal getPrincipal();

    public void destroyModuleState() {
    }

    public void nullifyUsedVars() {
    }

    private int wrapProcess(Callback[] callbacks, int state) throws AuthLoginException {
        try {
            if (callbacks != null) {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (!(callbacks[i] instanceof NameCallback)) continue;
                    String newUser = null;
                    try {
                        newUser = IdUtils.getIdentityName(((NameCallback)callbacks[i]).getName(), this.getRequestOrg());
                    }
                    catch (IdRepoException idRepoExp) {
                        debug.message("AMLoginModule.wrapProcess: Cannot get username from idrepo. ", (Throwable)idRepoExp);
                    }
                    if (newUser == null) continue;
                    ((NameCallback)callbacks[i]).setName(newUser);
                }
            }
            return this.process(callbacks, state);
        }
        catch (LoginException e) {
            this.currentState = 0;
            this.setFailureModuleName(this.moduleName);
            if (e instanceof InvalidPasswordException) {
                throw new InvalidPasswordException(e);
            }
            throw new AuthLoginException(e);
        }
    }

    private boolean moduleHasDone() {
        return this.currentState == -1 || this.currentState == 0;
    }

    public final boolean login() throws AuthLoginException {
        if (this.moduleHasDone()) {
            debug.message("This module has already done.");
            return this.currentState == -1;
        }
        if (debug.messageEnabled()) {
            debug.message("This module is not done yet. CurrentState: " + this.currentState);
        }
        if (this.internal == null) {
            this.getCallback(1);
        }
        if (this.noCallbacks) {
            this.currentState = this.wrapProcess(EMPTY_CALLBACK, 1);
            if (this.currentState == -1) {
                this.setSuccessModuleName(this.moduleName);
                this.succeeded = true;
                this.nullifyUsedVars();
                return true;
            }
            if (this.currentState == 0) {
                this.setFailureModuleName(this.moduleName);
                this.succeeded = false;
                this.destroyModuleState();
                this.principal = null;
                return false;
            }
            this.setFailureModuleName(this.moduleName);
            this.succeeded = false;
            this.cleanup();
            throw new AuthLoginException(bundleName, "invalidCode", new Object[]{new Integer(this.currentState)});
        }
        if (this.handler == null) {
            debug.error("Handler is null");
            throw new AuthLoginException(bundleName, "nullHandler", null);
        }
        try {
            while (this.currentState != -1 && this.currentState != 0) {
                if (debug.messageEnabled()) {
                    debug.message("Login, state = " + this.currentState);
                }
                if (this.isSharedState) {
                    this.currentState = this.wrapProcess(EMPTY_CALLBACK, 1);
                    this.isSharedState = false;
                    continue;
                }
                this.getCallback(this.currentState);
                Callback[] cbks = (Callback[])this.internal.get(this.currentState - 1);
                PagePropertiesCallback callback = (PagePropertiesCallback)cbks[0];
                if (callback.getErrorState()) {
                    this.setFailureModuleName(this.moduleName);
                    String template = callback.getTemplateName();
                    String errorMessage = callback.getHeader();
                    if (template == null || template.length() == 0) {
                        throw new MessageLoginException(errorMessage);
                    }
                    this.setModuleErrorTemplate(template);
                    throw new AuthLoginException(errorMessage);
                }
                this.handler.handle(cbks);
                Callback[] cbksPrev = (Callback[])this.internal.get(this.currentState - 1);
                PagePropertiesCallback callbackPrev = (PagePropertiesCallback)cbksPrev[0];
                String pageState = callbackPrev.getPageState();
                if (pageState != null && pageState.length() != 0 && !pageState.equals(Integer.toString(this.currentState))) {
                    int loginPage = Integer.parseInt(pageState);
                    callbackPrev.setPageState(Integer.toString(this.currentState));
                    this.currentState = loginPage;
                    if (debug.messageEnabled()) {
                        debug.message("currentState from UI " + this.currentState);
                    }
                }
                this.currentState = this.wrapProcess((Callback[])this.external.get(this.currentState - 1), this.currentState);
                if (!debug.messageEnabled()) continue;
                debug.message("Login NEXT State : " + this.currentState);
            }
            if (this.currentState == -1) {
                this.setSuccessModuleName(this.moduleName);
                this.succeeded = true;
                this.nullifyUsedVars();
                return true;
            }
            this.setFailureModuleName(this.moduleName);
            this.succeeded = false;
            this.destroyModuleState();
            this.principal = null;
            return false;
        }
        catch (IOException e) {
            this.setFailureModuleName(this.moduleName);
            if (e.getMessage().equals("110")) {
                debug.message("login timed out ", (Throwable)e);
            } else {
                debug.message("login ", (Throwable)e);
            }
            throw new AuthLoginException(e);
        }
        catch (UnsupportedCallbackException e) {
            this.setFailureModuleName(this.moduleName);
            debug.message("Login", (Throwable)e);
            throw new AuthLoginException(e);
        }
    }

    public int getAuthLevel() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return 0;
            }
        }
        return this.loginState.getAuthLevel();
    }

    public boolean setAuthLevel(int auth_level) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set auth level : " + auth_level);
                return false;
            }
        }
        this.loginState.setModuleAuthLevel(auth_level);
        return true;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public HttpServletRequest getHttpServletRequest() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        return this.loginState.getHttpServletRequest();
    }

    protected LoginState getLoginState(String methodName) throws AuthLoginException {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                throw new AuthLoginException(bundleName, "wrongCall", new Object[]{methodName});
            }
        }
        return this.loginState;
    }

    protected java.util.Locale getLoginLocale() {
        try {
            String loc = this.getLocale();
            return Locale.getLocale((String)loc);
        }
        catch (AuthLoginException ex) {
            debug.message("unable to determine loginlocale ", (Throwable)ex);
            return java.util.Locale.ENGLISH;
        }
    }

    private LoginState getLoginState() {
        Callback[] callbacks = new Callback[1];
        try {
            callbacks[0] = new LoginStateCallback();
            if (this.handler == null) {
                return null;
            }
            this.handler.handle(callbacks);
            return ((LoginStateCallback)callbacks[0]).getLoginState();
        }
        catch (Exception e) {
            debug.message("Error..", (Throwable)e);
            return null;
        }
    }

    public HttpServletResponse getHttpServletResponse() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        return this.loginState.getHttpServletResponse();
    }

    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    public String getLocale() throws AuthLoginException {
        return this.getLoginState("getLocale()").getLocale();
    }

    public int getNumberOfStates() {
        return this.stateLength;
    }

    public String getRequestOrg() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        return this.loginState.getOrgDN();
    }

    public String getSessionId() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return null;
            }
        }
        return this.loginState.getSid().toString();
    }

    public Map getOrgProfile(String orgDN) throws AuthLoginException {
        Map orgMap = null;
        if (orgDN == null || orgDN.length() == 0) {
            orgDN = this.getLoginState("getOrgProfile(String)").getOrgDN();
        }
        try {
            OrganizationConfigManager orgConfigMgr = AuthD.getAuth().getOrgConfigManager(orgDN);
            orgMap = orgConfigMgr.getAttributes("sunIdentityRepositoryService");
            if (debug.messageEnabled()) {
                debug.message("orgMap is : " + orgMap);
            }
        }
        catch (Exception ex) {
            debug.message("getOrgProfile", (Throwable)ex);
            throw new AuthLoginException(ex);
        }
        return orgMap;
    }

    public Map getOrgServiceTemplate(String orgDN, String serviceName) throws AuthLoginException {
        Map orgMap = null;
        if (orgDN == null || orgDN.length() == 0) {
            orgDN = this.getLoginState("getOrgServiceTemplate(String, String)").getOrgDN();
        }
        try {
            OrganizationConfigManager orgConfigMgr = AuthD.getAuth().getOrgConfigManager(orgDN);
            orgMap = orgConfigMgr.getServiceConfig(serviceName).getAttributes();
        }
        catch (Exception ex) {
            debug.message("getOrgServiceTemplate", (Throwable)ex);
            throw new AuthLoginException(ex);
        }
        return orgMap;
    }

    public boolean getPersistentCookieOn() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return false;
            }
        }
        return this.loginState.getPersistentCookieMode();
    }

    public boolean isDynamicProfileCreationEnabled() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return false;
            }
        }
        return this.loginState.isDynamicProfileCreationEnabled();
    }

    public boolean setPersistentCookieOn() {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                return false;
            }
        }
        if (!this.loginState.getPersistentCookieMode()) {
            return false;
        }
        this.loginState.setPersistentCookieOn();
        return true;
    }

    public Map getServiceConfig(String name) throws AuthLoginException {
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(name, AuthD.getAuth().getSSOAuthSession());
            ServiceSchema sc = scm.getGlobalSchema();
            HashMap retMap = new HashMap();
            if (sc != null) {
                retMap.putAll(sc.getAttributeDefaults());
            }
            if ((sc = scm.getOrganizationSchema()) != null) {
                retMap.putAll(sc.getAttributeDefaults());
            }
            if ((sc = scm.getUserSchema()) != null) {
                retMap.putAll(sc.getAttributeDefaults());
            }
            if ((sc = scm.getPolicySchema()) != null) {
                retMap.putAll(sc.getAttributeDefaults());
            }
            return retMap;
        }
        catch (Exception ex) {
            debug.message("getServiceConfig", (Throwable)ex);
            throw new AuthLoginException(ex);
        }
    }

    public AMUser getUserProfile(String userDN) throws AuthLoginException {
        AMUser user = null;
        try {
            user = AuthD.getAuth().getSDK().getUser(userDN);
        }
        catch (Exception ex) {
            debug.message("getUserProfile", (Throwable)ex);
            throw new AuthLoginException(ex);
        }
        return user;
    }

    public String getUserSessionProperty(String name) throws AuthLoginException {
        InternalSession sess = this.getLoginState("getUserSessionProperty()").getSession();
        if (sess != null) {
            return sess.getProperty(name);
        }
        return null;
    }

    public void setUserSessionProperty(String name, String value) throws AuthLoginException {
        InternalSession sess = this.getLoginState("setUserSessionProperty()").getSession();
        if (sess == null) {
            throw new AuthLoginException(bundleName, "wrongCall", new Object[]{" setUserSessionProperty()"});
        }
        sess.putProperty(name, value);
    }

    public Set getNewUserIDs(Map attributes, int num) throws AuthLoginException {
        boolean enabled = this.getLoginState((String)"getNewUserIDs(Map, int)").userIDGeneratorEnabled;
        if (!enabled) {
            return null;
        }
        String className = this.getLoginState((String)"getNewUserIDs(Map, int)").userIDGeneratorClassName;
        String orgDN = this.getLoginState("getNewUserIDs(Map, int)").getOrgDN();
        if (className == null || className.length() == 0) {
            className = "com.sun.identity.authentication.spi.DefaultUserIDGenerator";
        }
        UserIDGenerator idGenerator = null;
        try {
            Class<?> theClass = Class.forName(className);
            idGenerator = (UserIDGenerator)theClass.newInstance();
        }
        catch (Exception e) {
            debug.message("getNewUserIDs(): unable to instantiate " + className, (Throwable)e);
            return null;
        }
        return idGenerator.generateUserIDs(orgDN, attributes, num);
    }

    public void setLoginFailureURL(String url) throws AuthLoginException {
        this.getLoginState("setLoginFailureURL()").setFailureLoginURL(url);
    }

    public void setModuleErrorTemplate(String templateName) throws AuthLoginException {
        this.getLoginState("setModuleTemplate()").setModuleErrorTemplate(templateName);
    }

    public void setLoginSuccessURL(String url) throws AuthLoginException {
        this.getLoginState("setLoginSuccessURL()").setSuccessLoginURL(url);
    }

    public void setOrg(String orgDN) throws AuthLoginException {
    }

    public boolean isRequired(int state, int index) {
        if (state > this.stateLength) {
            return false;
        }
        Callback[] callbacks = (Callback[])this.internal.get(state - 1);
        if (callbacks == null || callbacks.length == 0) {
            return false;
        }
        Callback callback = callbacks[0];
        if (callback instanceof PagePropertiesCallback) {
            List req = ((PagePropertiesCallback)callback).getRequire();
            if (req == null || req.isEmpty() || index >= req.size()) {
                return false;
            }
            String tmp = (String)req.get(index);
            return tmp.equalsIgnoreCase("true");
        }
        return false;
    }

    public String getAttribute(int state, int index) {
        if (state > this.stateLength) {
            return "";
        }
        Callback[] callbacks = (Callback[])this.internal.get(state - 1);
        if (callbacks == null || callbacks.length == 0) {
            return "";
        }
        Callback callback = callbacks[0];
        if (callback instanceof PagePropertiesCallback) {
            List req = ((PagePropertiesCallback)callback).getAttribute();
            if (req == null || req.isEmpty() || index >= req.size()) {
                return "";
            }
            return (String)req.get(index);
        }
        return "";
    }

    public final boolean abort() throws AuthLoginException {
        debug.message("ABORT return.... false");
        if (!this.succeeded) {
            return false;
        }
        this.logout();
        return true;
    }

    public final boolean commit() throws AuthLoginException {
        this.principal = this.getPrincipal();
        if (debug.messageEnabled()) {
            debug.message("AMLoginModule.commit():Succeed,principal=" + this.principal);
        }
        if (!this.succeeded || this.principal == null) {
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
            debug.message("Done added user to principal");
        }
        this.cleanup();
        return true;
    }

    public final boolean logout() throws AuthLoginException {
        if (this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().remove(this.principal);
        }
        this.succeeded = false;
        this.cleanup();
        return true;
    }

    public void setFailureID(String userID) {
        if (userID == null) {
            return;
        }
        debug.message("setFailureID : " + userID);
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set set userId : " + userID);
                return;
            }
        }
        this.loginState.setFailedUserId(userID);
    }

    public void setUserAttributes(Map attributeValuePairs) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set user attributes");
                return;
            }
        }
        this.loginState.setUserCreationAttributes(attributeValuePairs);
    }

    public void validateUserName(String userName, String regEx) throws UserNamePasswordValidationException {
        try {
            AMUserPasswordValidation plugin = this.getUPValidationInstance();
            if (plugin != null) {
                debug.message("Validating username...");
                HashMap<String, String> envMap = new HashMap<String, String>(2);
                envMap.put("organization_name", this.getRequestOrg());
                plugin.validateUserID(userName, envMap);
            } else if (regEx != null && regEx.length() != 0 && !ISValidation.validate(userName, regEx, debug)) {
                throw new UserNamePasswordValidationException(bundleName, "invalidChars", null);
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("User Name validation Failed" + ame.getMessage());
            }
            throw new UserNamePasswordValidationException(ame);
        }
        catch (Exception ex) {
            debug.message("unKnown Exception occured during username validation");
            throw new UserNamePasswordValidationException(ex);
        }
    }

    private void setSuccessModuleName(String moduleName) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set moduleName : " + moduleName);
                return;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SETTING Module name.... :" + moduleName);
        }
        this.loginState.setSuccessModuleName(moduleName);
    }

    public boolean isValidUserEntry(String userDN) {
        boolean isValidUser = false;
        try {
            isValidUser = AuthD.getAuth().getIdentity(IdType.USER, userDN, "/") != null;
        }
        catch (AuthException e) {
            debug.message("User Valid :" + isValidUser);
        }
        return isValidUser;
    }

    public boolean isSuperAdmin(String userDN) {
        boolean isSuperAdmin = AuthD.getAuth().isSuperAdmin(userDN);
        if (debug.messageEnabled()) {
            debug.message("is SuperAdmin : " + isSuperAdmin);
        }
        return isSuperAdmin;
    }

    public void validatePassword(String userPassword) throws UserNamePasswordValidationException {
        AMUserPasswordValidation plugin = this.getUPValidationInstance();
        try {
            if (plugin != null) {
                debug.message("Validating password...");
                plugin.validatePassword(userPassword);
            } else {
                debug.message("No plugin found");
            }
        }
        catch (AMException ame) {
            if (debug.messageEnabled()) {
                debug.message("Password validation Failed " + ame.getMessage());
            }
            throw new UserNamePasswordValidationException(ame);
        }
        catch (Exception ex) {
            debug.message("Unknown Exception occured during password validation");
            throw new UserNamePasswordValidationException(ex);
        }
    }

    private AMUserPasswordValidation getUPValidationInstance() {
        try {
            String orgDN = this.getRequestOrg();
            String className = orgDN != null ? this.getOrgPluginClassName(orgDN) : this.getPluginClassName();
            if (debug.messageEnabled()) {
                debug.message("UserPasswordValidation Class Name is : " + className);
            }
            if (className == null || className.length() == 0) {
                return null;
            }
            AMUserPasswordValidation userPasswordInstance = (AMUserPasswordValidation)Class.forName(className).newInstance();
            return userPasswordInstance;
        }
        catch (ClassNotFoundException ce) {
            if (debug.messageEnabled()) {
                debug.message("Class not Found :", (Throwable)ce);
            }
            return null;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("Error: ", (Throwable)e);
            }
            return null;
        }
    }

    private String getOrgPluginClassName(String orgDN) {
        try {
            Map config = this.getOrgServiceTemplate(orgDN, "iPlanetAMAdminConsoleService");
            String className = Misc.getServerMapAttr(config, "iplanet-am-admin-console-user-password-validation-class");
            if (debug.messageEnabled()) {
                debug.message("Org Plugin Class:  " + className);
            }
            return className;
        }
        catch (Exception ee) {
            debug.message("Error while getting UserPasswordValidationClass ", (Throwable)ee);
            return null;
        }
    }

    private String getPluginClassName() throws AuthLoginException {
        Map config = this.getServiceConfig("iPlanetAMAdminConsoleService");
        String className = CollectionHelper.getServerMapAttr((Map)config, (String)"iplanet-am-admin-console-user-password-validation-class");
        if (debug.messageEnabled()) {
            debug.message("Plugin Class:  " + className);
        }
        return className;
    }

    private void setFailureModuleName(String moduleName) {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to set moduleName : " + moduleName);
                return;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SETTING Failure Module name.... :" + moduleName);
        }
        this.loginState.setFailureModuleName(moduleName);
    }

    public String getUserKey() {
        return "javax.security.auth.login.name";
    }

    public String getPwdKey() {
        return "javax.security.auth.login.password";
    }

    private void cleanup() {
        this.principal = null;
        if (this.sharedState != null) {
            this.sharedState.remove("javax.security.auth.login.name");
            this.sharedState.remove("javax.security.auth.login.password");
        }
        this.sharedState = null;
        this.destroyModuleState();
    }

    public void storeUsernamePasswd(String user, String passwd) {
        if (this.isStore && this.sharedState != null) {
            this.sharedState.put("javax.security.auth.login.name", user);
            this.sharedState.put("javax.security.auth.login.password", passwd);
        }
    }

    public boolean isSharedStateEnabled() {
        return this.isSharedState;
    }

    public boolean isUseFirstPassEnabled() {
        return this.sharedStateBehaviorPattern != null && this.sharedStateBehaviorPattern.equals("useFirstPass");
    }

    public AMIdentityRepository getAMIdentityRepository(String orgDN) {
        return AuthD.getAuth().getAMIdentityRepository(orgDN);
    }

    public void createIdentity(String userName, Map userAttributes, Set userRoles) throws IdRepoException, SSOException {
        if (this.loginState == null) {
            this.loginState = this.getLoginState();
            if (this.loginState == null) {
                debug.error("Unable to create Identity: " + userName);
                return;
            }
        }
        this.loginState.createUserIdentity(userName, userAttributes, userRoles);
    }
}

