/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.config.AMConfiguration;
import com.sun.identity.authentication.jaas.LoginContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AMAccountLockout;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthLevel;
import com.sun.identity.authentication.service.AuthThreadManager;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.CompositeAdvices;
import com.sun.identity.authentication.service.DSAMECallbackHandler;
import com.sun.identity.authentication.service.JAASLoginThread;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStatus;
import com.sun.identity.authentication.service.UserPrincipal;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.MessageLoginException;
import com.sun.identity.authentication.util.AMAuthUtils;
import com.sun.identity.common.DNUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.DNMapper;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;

public class AMLoginContext {
    static final String LIST_DELIMITER = "|";
    public static AuthThreadManager authThread;
    private static final String bundleName = "amAuth";
    private static AuthD ad;
    private static Debug debug;
    String configName;
    String orgDN = null;
    javax.security.auth.login.LoginContext lc = null;
    LoginContext jlc = null;
    LoginStatus st;
    LoginState loginState;
    AuthContextLocal authContext;
    Subject subject;
    AuthContext.IndexType indexType;
    String indexName;
    String clientType;
    boolean pCookieMode = false;
    String lockoutMsg = null;
    Set moduleSet = null;
    String sid = null;
    boolean accountLocked = false;
    boolean isFailed = false;
    boolean internalAuthError = false;
    boolean processDone = false;
    private int jaasCheck;
    private Thread jaasThread = null;
    private AppConfigurationEntry[] entries = null;
    Callback[] recdCallback;
    ResourceBundle bundle;

    public void setConfigEntries(AppConfigurationEntry[] entries) {
        this.entries = entries;
    }

    public AMLoginContext(AuthContextLocal authContext) {
        if (debug.messageEnabled()) {
            debug.message("AMLoginContext:initialThread name is... :" + Thread.currentThread().getName());
        }
        this.authContext = authContext;
        this.st = new LoginStatus();
        this.st.setStatus(2);
        this.bundle = AMLoginContext.ad.bundle;
    }

    public void executeLogin(HashMap loginParamsMap) throws AuthLoginException {
        AuthContext.IndexType prevIndexType;
        boolean errorState = false;
        this.internalAuthError = false;
        this.processDone = false;
        this.isFailed = false;
        this.setLoginHash();
        if (this.loginState == null || loginParamsMap == null) {
            debug.error("Error: loginState or loginParams is null");
            this.st.setStatus(4);
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.internalAuthError = true;
            throw new AuthLoginException(bundleName, "102", null);
        }
        String llc = this.loginState.getLocale();
        java.util.Locale loc = Locale.getLocale((String)llc);
        this.bundle = AMResourceBundleCache.getInstance().getResBundle(bundleName, loc);
        if (debug.messageEnabled()) {
            debug.message("LoginState : " + this.loginState);
        }
        this.parseLoginParams(loginParamsMap);
        if (this.indexType == AuthContext.IndexType.MODULE_INSTANCE && !this.loginState.getEnableModuleBasedAuth() && !this.indexName.equals("Application")) {
            debug.error("Error: Module Based Auth is not allowed");
            this.st.setStatus(4);
            this.loginState.setErrorCode("120");
            this.setErrorMsgAndTemplate();
            throw new AuthLoginException(bundleName, "120", null);
        }
        if (this.authContext.getOrgDN() != null && this.authContext.getOrgDN().length() != 0) {
            this.orgDN = this.authContext.getOrgDN();
            this.loginState.setQualifiedOrgDN(this.orgDN);
        } else {
            this.orgDN = this.loginState.getOrgDN();
        }
        this.clientType = this.loginState.getClientType();
        if (debug.messageEnabled()) {
            debug.message("orgDN : " + this.orgDN);
            debug.message("clientType : " + this.clientType);
        }
        if ((prevIndexType = this.loginState.getIndexType()) != null && (prevIndexType == AuthContext.IndexType.LEVEL || prevIndexType == AuthContext.IndexType.COMPOSITE_ADVICE)) {
            this.loginState.setPreviousIndexType(prevIndexType);
        }
        this.loginState.setIndexType(this.indexType);
        this.loginState.setIndexName(this.indexName);
        try {
            if (this.processIndexType(this.indexType, this.indexName, this.orgDN)) {
                return;
            }
        }
        catch (AuthLoginException le) {
            debug.message("Error  : ", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            debug.message("Error : ", (Throwable)e);
            throw new AuthLoginException(e);
        }
        this.configName = this.getConfigName(this.indexType, this.indexName, this.orgDN, this.clientType);
        if (this.configName == null) {
            this.loginState.setErrorCode("105");
            debug.message("Config not found");
            this.setErrorMsgAndTemplate();
            this.internalAuthError = true;
            this.st.setStatus(4);
            this.loginState.logFailed(this.bundle.getString("noConfig"), "NOCONFIG");
            throw new AuthLoginException(bundleName, "105", null);
        }
        if (debug.messageEnabled()) {
            debug.message("Creating login context object\n\n orgDN : " + this.orgDN + "\n configName : " + this.configName);
        }
        try {
            this.jaasCheck = AuthUtils.isPureJAASModulePresent(this.configName, this);
            if (this.isPureJAAS()) {
                debug.message("Using pure jaas mode.");
                if (authThread == null) {
                    authThread = new AuthThreadManager();
                    authThread.start();
                }
            }
            DSAMECallbackHandler dsameCallbackHandler = new DSAMECallbackHandler(this);
            if (this.isPureJAAS()) {
                this.lc = this.subject != null ? new javax.security.auth.login.LoginContext(this.configName, this.subject, dsameCallbackHandler) : new javax.security.auth.login.LoginContext(this.configName, dsameCallbackHandler);
            } else {
                debug.message("Using non pure jaas mode.");
                this.jlc = this.subject != null ? new LoginContext(this.entries, this.subject, dsameCallbackHandler) : new LoginContext(this.entries, dsameCallbackHandler);
            }
        }
        catch (AuthLoginException ae) {
            debug.error("JAAS module for config: " + this.configName + ", " + ae.getMessage());
            if (debug.messageEnabled()) {
                debug.message("AuthLoginException", (Throwable)ae);
            }
            this.loginState.setErrorCode(ae.getErrorCode());
            this.setErrorMsgAndTemplate();
            this.loginState.logFailed(this.bundle.getString("loginContextCreateFailed"));
            this.internalAuthError = true;
            this.st.setStatus(4);
            throw ae;
        }
        catch (LoginException le) {
            debug.error("in creating LoginContext.");
            if (debug.messageEnabled()) {
                debug.message("Exception ", (Throwable)le);
            }
            this.loginState.setErrorCode("102");
            this.loginState.logFailed(this.bundle.getString("loginContextCreateFailed"));
            this.setErrorMsgAndTemplate();
            this.st.setStatus(4);
            this.internalAuthError = true;
            throw new AuthLoginException(bundleName, "102", null, le);
        }
        catch (SecurityException se) {
            debug.error("security in creating LoginContext.");
            if (debug.messageEnabled()) {
                debug.message("Exception ", (Throwable)se);
            }
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.loginState.logFailed(this.bundle.getString("loginContextCreateFailed"));
            this.internalAuthError = true;
            this.st.setStatus(4);
            throw new AuthLoginException(bundleName, "102", null);
        }
        catch (Exception e) {
            debug.error("Creating DSAMECallbackHandler: " + e.getMessage());
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.loginState.logFailed(this.bundle.getString("loginContextCreateFailed"));
            this.internalAuthError = true;
            this.st.setStatus(4);
            throw new AuthLoginException(bundleName, "102", null, e);
        }
        try {
            if (this.isPureJAAS()) {
                if (this.jaasThread != null) {
                    this.jaasThread.interrupt();
                    this.jaasThread = null;
                    errorState = true;
                } else {
                    this.jaasThread = new JAASLoginThread(this);
                    this.jaasThread.start();
                }
            } else {
                this.runLogin();
            }
        }
        catch (IllegalThreadStateException ite) {
            errorState = true;
        }
        catch (Exception e) {
            errorState = true;
        }
        if (errorState) {
            this.st.setStatus(7);
            this.loginState.setErrorCode("102");
            this.setErrorMsgAndTemplate();
            this.internalAuthError = true;
            throw new AuthLoginException(bundleName, "102", null);
        }
        debug.message("AMLoginContext:Thread started... returning.");
    }

    public void runLogin() {
        boolean loginSuccess;
        String logFailedError;
        String logFailedMessage;
        Thread thread;
        block37: {
            thread = Thread.currentThread();
            logFailedMessage = this.bundle.getString("loginFailed");
            logFailedError = null;
            AMAccountLockout amAccountLockout = null;
            loginSuccess = false;
            try {
                if (this.isPureJAAS()) {
                    this.lc.login();
                    this.subject = this.lc.getSubject();
                } else {
                    this.jlc.login();
                    this.subject = this.jlc.getSubject();
                }
                debug.message("user authenication successful");
                this.loginState.setSubject(this.subject);
                debug.message("searchUserProfile for Subject :");
                boolean profileState = this.loginState.searchUserProfile(this.subject, this.indexType, this.indexName);
                loginSuccess = true;
                if (!profileState) {
                    debug.error("Profile not found ");
                    logFailedMessage = this.bundle.getString("noUserProfile");
                    logFailedError = "NOUSERPROFILE";
                    this.loginState.setErrorCode("100");
                    this.isFailed = true;
                    break block37;
                }
                amAccountLockout = new AMAccountLockout(this.loginState);
                if (amAccountLockout.isLockedOut()) {
                    debug.message("User locked out!!");
                    logFailedMessage = this.bundle.getString("lockOut");
                    logFailedError = "LOCKEDOUT";
                    this.loginState.setErrorCode("112");
                    this.isFailed = true;
                    break block37;
                }
                boolean accountExpired = false;
                if (!this.loginState.ignoreProfile()) {
                    accountExpired = amAccountLockout.isAccountExpired();
                }
                if (accountExpired) {
                    debug.message("Account expired!!");
                    logFailedMessage = this.bundle.getString("accountExpired");
                    logFailedError = "ACCOUNTEXPIRED";
                    this.loginState.setErrorCode("101");
                    this.isFailed = true;
                    break block37;
                }
                if (debug.messageEnabled()) {
                    debug.message("authContext is : " + this.authContext);
                    debug.message("loginSTate is : " + this.loginState);
                }
                this.updateLoginState(this.loginState, this.indexType, this.indexName, this.configName, this.orgDN);
                Object lcInSession = null;
                lcInSession = this.isPureJAAS() ? this.lc : this.jlc;
                boolean sessionActivated = this.loginState.activateSession(this.subject, this.authContext, lcInSession);
                if (sessionActivated) {
                    this.loginState.logSuccess();
                    if (amAccountLockout.isLockoutEnabled()) {
                        amAccountLockout.resetPasswdLockout(this.loginState.getUserDN(), true);
                    }
                    this.st.setStatus(3);
                    this.loginState.updateSessionForFailover();
                    debug.message("login success");
                    break block37;
                }
                logFailedMessage = AuthUtils.getErrorVal("115", "Error_Message");
                logFailedError = "MAXSESSIONREACHED";
                throw new AuthException("115", null);
            }
            catch (InvalidPasswordException ipe) {
                debug.message("Invalid Password : ");
                if (debug.messageEnabled()) {
                    debug.message("Exception ", (Throwable)ipe);
                }
                String failedUserId = ipe.getTokenId();
                if (debug.messageEnabled()) {
                    debug.message("Invalid Password Exception " + failedUserId);
                }
                if (failedUserId != null) {
                    amAccountLockout = new AMAccountLockout(this.loginState);
                    this.accountLocked = amAccountLockout.isLockedOut(failedUserId);
                    if (!this.accountLocked && amAccountLockout.isLockoutEnabled()) {
                        amAccountLockout.invalidPasswd(failedUserId);
                        this.checkWarningCount(amAccountLockout);
                        this.accountLocked = amAccountLockout.isAccountLocked(failedUserId);
                    }
                }
                logFailedMessage = this.bundle.getString("invalidPasswd");
                logFailedError = "INVALIDPASSWORD";
                if (this.accountLocked) {
                    this.loginState.setErrorCode("104");
                } else {
                    this.loginState.setErrorCode("103");
                }
                this.isFailed = true;
                this.authContext.setLoginException(ipe);
            }
            catch (MessageLoginException me) {
                if (debug.messageEnabled()) {
                    debug.message("LOGINFAILED MessageAuthLoginException....");
                    debug.message("Exception ", (Throwable)me);
                }
                java.util.Locale locale = Locale.getLocale((String)this.loginState.getLocale());
                this.loginState.setModuleErrorMessage(me.getL10NMessage(locale));
                this.isFailed = true;
                this.authContext.setLoginException(me);
            }
            catch (AuthLoginException le) {
                if ("110".equals(le.getMessage())) {
                    debug.message("LOGINFAILED Error Timed Out....");
                } else {
                    debug.message("LOGINFAILED Error....");
                }
                if (debug.messageEnabled()) {
                    debug.message("Exception ", (Throwable)le);
                }
                this.isFailed = true;
                if (this.loginState.isTimedOut()) {
                    logFailedMessage = this.bundle.getString("loginTimeout");
                    logFailedError = "LOGINTIMEOUT";
                    this.loginState.setErrorCode("110");
                } else {
                    this.loginState.setErrorCode("107");
                }
                this.authContext.setLoginException(le);
            }
            catch (AuthException e) {
                if (debug.messageEnabled()) {
                    debug.message("Exception : " + e.getMessage());
                }
                this.isFailed = true;
                this.loginState.setErrorCode(e.getErrorCode());
                this.loginState.logFailed(this.bundle.getString("loginFailed"));
                logFailedError = null;
                this.authContext.setLoginException(new AuthLoginException(bundleName, "loginFailed", null, (Throwable)((Object)e)));
            }
            catch (Exception e) {
                debug.message("Error during login.. ");
                if (debug.messageEnabled()) {
                    debug.message("Exception ", (Throwable)e);
                }
                this.isFailed = true;
                this.loginState.setErrorCode("102");
                this.loginState.logFailed(this.bundle.getString("loginFailed"));
                logFailedError = null;
                this.authContext.setLoginException(new AuthLoginException(bundleName, "loginFailed", null, e));
            }
            catch (Error er) {
                debug.message("Caught java.lang.Error returned from DSAMEHandler");
                return;
            }
        }
        debug.message("Came to before if Failed loop");
        if (this.isFailed) {
            if (loginSuccess) {
                this.loginState.setFailureModuleList(this.getSuccessModuleString(this.orgDN));
            } else {
                this.loginState.setFailureModuleList(this.getFailureModuleList(this.orgDN));
            }
            this.loginState.logFailed(logFailedMessage, logFailedError);
            this.setErrorMsgAndTemplate();
            this.st.setStatus(4);
            if (this.indexType == AuthContext.IndexType.USER) {
                if (debug.messageEnabled()) {
                    debug.message("Set failureId in user based auth " + this.indexName);
                }
                this.loginState.setFailedUserId(this.indexName);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("finished...login notify all threads\nAMLoginContext:LoginStatus: " + this.st.getStatus());
        }
        if (this.isPureJAAS()) {
            authThread.removeFromHash(thread, "timeoutHash");
            this.loginState.setReceivedCallback(null, this);
        }
        this.isFailed = false;
        this.nullifyUsedVars();
    }

    public void logout() throws AuthLoginException {
        block8: {
            debug.message("in logout:");
            try {
                if (this.isPureJAAS()) {
                    if (this.lc != null) {
                        this.lc.logout();
                    }
                } else if (this.jlc != null) {
                    this.jlc.logout();
                }
                this.loginState.logLogout();
                this.loginState.postProcess(this.indexType, this.indexName, 3);
                this.destroySession();
                this.st.setStatus(5);
            }
            catch (AuthLoginException le) {
                debug.message("Error during logout : ");
                if (debug.messageEnabled()) {
                    debug.message("Exception ", (Throwable)le);
                }
                throw new AuthLoginException(bundleName, "failedLogout", null, le);
            }
            catch (Exception e) {
                debug.message("Error during logout : ");
                if (!debug.messageEnabled()) break block8;
                debug.message("Exception ", (Throwable)e);
            }
        }
    }

    void destroySession() {
        if (debug.messageEnabled()) {
            debug.message("AMLoginContext:destroySession: " + this.loginState);
        }
        this.loginState.destroySession();
    }

    public Callback[] getRequiredInfo() {
        if (this.st.getStatus() != 2) {
            return null;
        }
        if (this.indexType == AuthContext.IndexType.LEVEL || this.indexType == AuthContext.IndexType.COMPOSITE_ADVICE) {
            debug.message("IndexType level/composite_advice, send choice callback");
            this.indexType = null;
        } else {
            this.recdCallback = this.isPureJAAS() ? this.getRequiredInfoCallback() : this.getRequiredInfoCallback_NoThread();
        }
        if (this.recdCallback != null) {
            for (int i = 0; i < this.recdCallback.length; ++i) {
                if (!debug.messageEnabled()) continue;
                debug.message("Recd Callback in amlc.getRequiredInfo : " + this.recdCallback[i]);
            }
        } else {
            debug.message("Recd Callback in amlc.getRequiredInfo is NULL");
        }
        return this.recdCallback;
    }

    public Callback[] getRequiredInfoCallback_NoThread() {
        return this.loginState.getReceivedInfo();
    }

    public synchronized Callback[] getRequiredInfoCallback() {
        if (debug.messageEnabled()) {
            debug.message("getRequiredInfo.. " + this.st.getStatus());
        }
        if (this.isFailed || this.st.getStatus() != 2) {
            debug.message("no more requirements returning null");
            return null;
        }
        Thread thread = Thread.currentThread();
        long lastCallbackSent = this.loginState.getLastCallbackSent();
        long pageTimeOut = this.loginState.getPageTimeOut();
        if (debug.messageEnabled()) {
            debug.message("getRequiredInfo. ThreadName is.. :" + thread);
            debug.message("lastCallbackSent : " + lastCallbackSent);
            debug.message("pageTimeOut : " + pageTimeOut);
        }
        authThread.setHash(thread, pageTimeOut, lastCallbackSent);
        while (!this.isFailed && this.loginState.getReceivedInfo() == null && this.st.getStatus() == 2) {
            try {
                if (debug.messageEnabled()) {
                    debug.message(Thread.currentThread() + "Waiting.." + this.st.getStatus());
                }
                if (this.st.getStatus() != 2) {
                    return null;
                }
                if (this.isFailed || this.st.getStatus() != 2 || this.loginState.getReceivedInfo() != null) continue;
                this.wait();
            }
            catch (InterruptedException e) {
                debug.message("getRecdinfo INTERRUPTED");
                break;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Thread woke up... " + this.loginState.getReceivedInfo());
        }
        Callback[] getRequiredInfo = this.loginState.getReceivedInfo();
        if (debug.messageEnabled()) {
            debug.message("Returning getRequiredInfo... :" + getRequiredInfo);
        }
        authThread.removeFromHash(thread, "timeoutHash");
        return getRequiredInfo;
    }

    public void submitRequiredInfo(Callback[] callback) {
        if (debug.messageEnabled()) {
            debug.message("submit required info... :" + callback[0]);
        }
        if (this.isPureJAAS()) {
            this.loginState.setSubmittedCallback(callback, this);
        } else {
            this.loginState.setSubmittedCallback_NoThread(callback);
        }
        if (debug.messageEnabled()) {
            debug.message("Retunring from submitRequiredInfo");
        }
    }

    public synchronized Callback[] submitCallbackInfo() {
        if (debug.messageEnabled()) {
            debug.message("submitRequiredInfo. ThreadName is.. :" + Thread.currentThread().getName());
        }
        if (this.st.getStatus() != 2 || this.isFailed) {
            debug.message("submitReq no more requirements returning null");
            return null;
        }
        Thread thread = Thread.currentThread();
        long lastCallbackSent = this.loginState.getLastCallbackSent();
        long pageTimeOut = this.loginState.getPageTimeOut();
        if (debug.messageEnabled()) {
            debug.message("submitRequiredInfo. ThreadName is.. :" + thread);
            debug.message("lastCallbackSent : " + lastCallbackSent);
            debug.message("pageTimeOut : " + pageTimeOut);
        }
        authThread.setHash(thread, pageTimeOut, lastCallbackSent);
        while (this.loginState.getSubmittedInfo() == null && this.st.getStatus() == 2) {
            try {
                if (debug.messageEnabled()) {
                    debug.message(Thread.currentThread() + " Waiting...." + this.st.getStatus());
                }
                if (this.st.getStatus() != 2) {
                    return null;
                }
                if (this.loginState.getSubmittedInfo() != null) continue;
                this.wait();
            }
            catch (InterruptedException e) {
                debug.message("submitRequired info INTERRUPTED");
                break;
            }
        }
        debug.message("Threadwaking up go submit info...");
        authThread.removeFromHash(thread, "timeoutHash");
        Callback[] setSubmittedInfo = this.loginState.getSubmittedInfo();
        debug.message("Returning submitted info: ");
        return setSubmittedInfo;
    }

    public int getStatus() {
        int status = this.st.getStatus();
        if (this.isFailed || status == 4) {
            this.postProcessOnFail();
        } else if (status == 3) {
            this.postProcessOnSuccess();
        }
        if (debug.messageEnabled()) {
            debug.message("getStatus : status is... : " + status);
        }
        return status;
    }

    public LoginState getLoginState() {
        return AuthUtils.getLoginState(this.authContext);
    }

    public void abort() throws AuthLoginException {
        debug.message("in abort");
        try {
            this.logout();
        }
        catch (Exception ae) {
            if (debug.messageEnabled()) {
                debug.message("Error logging out.. :");
                debug.message("Exception ", (Throwable)ae);
            }
            try {
                this.destroySession();
                this.st.setStatus(5);
            }
            catch (Exception e) {
                debug.message("Error aborting");
                if (debug.messageEnabled()) {
                    debug.message("Exception ", (Throwable)e);
                }
                throw new AuthLoginException(bundleName, "abortFailed", null);
            }
        }
    }

    public Set getModuleInstanceNames() {
        try {
            LoginState loginState = AuthUtils.getLoginState(this.authContext);
            if (loginState != null) {
                this.moduleSet = loginState.getModuleInstances();
            }
            if (debug.messageEnabled()) {
                debug.message("moduleSet is : " + this.moduleSet);
            }
        }
        catch (Exception e) {
            debug.message("Error : ", (Throwable)e);
        }
        return this.moduleSet;
    }

    public String getOrganizationName() {
        return this.loginState.getQueryOrg();
    }

    public SSOToken getSSOToken() {
        try {
            return this.loginState.getSSOToken();
        }
        catch (SSOException e) {
            if (debug.messageEnabled()) {
                debug.message("error getting ssoToken : ");
                debug.message("Exception ", (Throwable)((Object)e));
            }
            return null;
        }
    }

    public String getSuccessURL() {
        try {
            return this.loginState.getSuccessLoginURL();
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("error getting successURL : " + e.toString());
            }
            return null;
        }
    }

    public String getFailureURL() {
        try {
            return this.loginState.getFailureLoginURL();
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("error getting failureURL : " + e.toString());
            }
            return null;
        }
    }

    public String getAuthIdentifier() {
        String sidString;
        block2: {
            sidString = null;
            try {
                sidString = this.loginState.getSid().toString();
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block2;
                debug.message("Error retreiving sid from LoginState : " + e.getMessage());
            }
        }
        return sidString;
    }

    public Subject getSubject() {
        try {
            return this.loginState.getSubject();
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("error getting Subject :");
                debug.message("Exception ", (Throwable)e);
            }
            return null;
        }
    }

    private void parseLoginParams(HashMap loginParamsMap) {
        block6: {
            if (debug.messageEnabled()) {
                debug.message("loginParamsMap is.. :" + loginParamsMap);
            }
            try {
                String locale;
                this.indexType = (AuthContext.IndexType)loginParamsMap.get("indexType");
                this.indexName = (String)loginParamsMap.get("indexName");
                if (debug.messageEnabled()) {
                    debug.message("indexType = " + this.indexType + "\nindexName = " + this.indexName);
                }
                this.subject = (Subject)loginParamsMap.get("subject");
                Boolean pCookieObject = (Boolean)loginParamsMap.get("pCookieMode");
                if (pCookieObject != null) {
                    this.pCookieMode = pCookieObject;
                }
                if ((locale = (String)loginParamsMap.get("locale")) != null && locale.length() > 0) {
                    this.loginState.setLocale(locale);
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block6;
                debug.message("Error parsing login Params");
                debug.message("Exception ", (Throwable)e);
            }
        }
    }

    String getConfigName(AuthContext.IndexType indexType, String indexName, String orgDN, String clientType) {
        String configName;
        block5: {
            configName = null;
            String universalID = null;
            if (indexType == null) {
                configName = AMAuthConfigUtils.getAuthConfigName(orgDN, "html");
            } else {
                universalID = indexType == AuthContext.IndexType.USER ? this.loginState.getUserUniversalId(indexName) : (indexType == AuthContext.IndexType.ROLE ? this.loginState.getRoleUniversalId(indexName) : indexName);
                try {
                    if (universalID != null) {
                        configName = AMAuthConfigUtils.getAuthConfigName(indexType, universalID, orgDN, clientType);
                    }
                }
                catch (Exception e) {
                    if (!debug.messageEnabled()) break block5;
                    debug.message("Error retrieving configName ");
                    debug.message("Exception : ", (Throwable)e);
                }
            }
        }
        return configName;
    }

    boolean processLevel(AuthContext.IndexType indexType, String indexName, String orgDN, String clientType) throws AuthException {
        indexType = AuthContext.IndexType.LEVEL;
        java.util.Locale loc = Locale.getLocale((String)this.loginState.getLocale());
        AuthLevel authLevel = new AuthLevel(indexType, indexName, orgDN, clientType, loc);
        int numberOfModules = authLevel.getNumberOfAuthModules();
        if (debug.messageEnabled()) {
            debug.message("number of Modules : " + numberOfModules);
        }
        if (numberOfModules <= 0) {
            this.loginState.logFailed(this.bundle.getString("noConfig"), "NOCONFIG");
            throw new AuthException("105", null);
        }
        if (numberOfModules == 1) {
            this.indexType = AuthContext.IndexType.MODULE_INSTANCE;
            this.loginState.setIndexType(this.indexType);
            this.indexName = authLevel.getModuleName();
            return false;
        }
        try {
            this.recdCallback = authLevel.createChoiceCallback();
            this.loginState.setPrevCallback(this.recdCallback);
            this.loginState.setModuleMap(authLevel.getModuleMap());
            return true;
        }
        catch (AuthException ae) {
            if (debug.messageEnabled()) {
                debug.message("Error creating choiceCallback");
                debug.message("Exception ", (Throwable)((Object)ae));
            }
            return false;
        }
    }

    boolean processCompositeAdvice(AuthContext.IndexType indexType, String indexName, String orgDN, String clientType) throws AuthException {
        Object moduleName = null;
        java.util.Locale loc = com.iplanet.am.util.Locale.getLocale(this.loginState.getLocale());
        CompositeAdvices compositeAdvice = new CompositeAdvices(indexName, orgDN, clientType, loc);
        int numberOfModules = compositeAdvice.getNumberOfAuthModules();
        if (debug.messageEnabled()) {
            debug.message("processCompositeAdvice:number of Modules/Services : " + numberOfModules);
        }
        this.loginState.setCompositeAdviceType(compositeAdvice.getType());
        if (numberOfModules <= 0) {
            this.loginState.logFailed(this.bundle.getString("noConfig"));
            throw new AuthException("105", null);
        }
        if (numberOfModules == 1) {
            this.indexName = AMAuthUtils.getDataFromRealmQualifiedData(compositeAdvice.getModuleName());
            String qualifiedRealm = AMAuthUtils.getRealmFromRealmQualifiedData(compositeAdvice.getModuleName());
            if (qualifiedRealm != null && qualifiedRealm.length() != 0) {
                this.orgDN = DNMapper.orgNameToDN(qualifiedRealm);
                this.loginState.setQualifiedOrgDN(this.orgDN);
            }
            if (compositeAdvice.getType() == 3) {
                this.indexType = AuthContext.IndexType.MODULE_INSTANCE;
            } else if (compositeAdvice.getType() == 2) {
                this.indexType = AuthContext.IndexType.SERVICE;
            } else if (compositeAdvice.getType() == 1) {
                this.orgDN = DNMapper.orgNameToDN(compositeAdvice.getModuleName());
                this.loginState.setQualifiedOrgDN(this.orgDN);
                this.indexName = AuthUtils.getOrgConfiguredAuthenticationChain(this.orgDN);
                this.indexType = AuthContext.IndexType.SERVICE;
            }
            this.loginState.setIndexType(this.indexType);
            this.loginState.setIndexName(this.indexName);
            if (debug.messageEnabled()) {
                debug.message("processCompositeAdvice:indexType : " + this.indexType);
                debug.message("processCompositeAdvice:indexName : " + this.indexName);
            }
            return false;
        }
        try {
            this.recdCallback = compositeAdvice.createChoiceCallback();
            this.loginState.setPrevCallback(this.recdCallback);
            this.loginState.setModuleMap(compositeAdvice.getModuleMap());
            return true;
        }
        catch (AuthException ae) {
            if (debug.messageEnabled()) {
                debug.message("Error creating choiceCallback");
                debug.message("Exception ", (Throwable)((Object)ae));
            }
            return false;
        }
    }

    void updateLoginState(LoginState loginState, AuthContext.IndexType indexType, String indexName, String configName, String orgDN) {
        String authLevel = indexType == AuthContext.IndexType.LEVEL ? indexName : this.getAuthLevel(orgDN);
        loginState.setAuthLevel(authLevel);
        String moduleName = null;
        moduleName = indexType == AuthContext.IndexType.MODULE_INSTANCE ? indexName : this.getSuccessModuleString(orgDN);
        if (debug.messageEnabled()) {
            debug.message("moduleName : " + moduleName);
        }
        loginState.setAuthModuleName(moduleName);
        if (indexType == AuthContext.IndexType.USER && this.pCookieMode) {
            loginState.setToken(indexName);
        }
    }

    boolean validateUser(String userName) {
        try {
            boolean userProfileExists = this.loginState.getUserProfile(userName, true);
            return userProfileExists && this.loginState.isUserEnabled();
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("Error retrieving profile for : " + userName);
            }
            return false;
        }
    }

    void checkWarningCount(AMAccountLockout amAccountLockout) {
        try {
            int warningCount = amAccountLockout.getWarnUserCount();
            if (warningCount == 0) {
                this.lockoutMsg = "";
            } else if (warningCount < 0) {
                this.accountLocked = true;
            } else {
                String lockoutMsgFmt = this.bundle.getString("lockOutWarning");
                Object[] params = new Object[]{new Integer(warningCount)};
                this.lockoutMsg = MessageFormat.format(lockoutMsgFmt, params);
                this.loginState.setLockoutMsg(this.lockoutMsg);
                this.accountLocked = false;
            }
            if (debug.messageEnabled()) {
                debug.message("WARNING COUNT : " + warningCount);
                debug.message("WARNING COUNT MESSAGE: " + this.lockoutMsg);
            }
        }
        catch (Exception e) {
            debug.message("Error : ", (Throwable)e);
        }
    }

    void setErrorMsgAndTemplate() {
        if (this.loginState == null) {
            return;
        }
        String errorCode = this.loginState.getErrorCode();
        if (errorCode != null) {
            String resProperty = this.bundle.getString(errorCode);
            String errorMsg = null;
            String templateName = null;
            if (debug.messageEnabled()) {
                debug.message("resProperty is.. :" + resProperty);
            }
            errorMsg = AuthUtils.getErrorVal(errorCode, "Error_Message");
            templateName = AuthUtils.getErrorVal(errorCode, "Error_Template");
            if (debug.messageEnabled()) {
                debug.message("Error Message : " + errorMsg);
                debug.message("Error Template: " + templateName);
            }
            this.loginState.setErrorMessage(errorMsg);
            this.loginState.setErrorTemplate(templateName);
        }
    }

    String getTimedOutTemplate() {
        this.loginState.setErrorCode("110");
        this.loginState.logFailed(this.bundle.getString("loginTimeout"), "LOGINTIMEOUT");
        this.loginState.setErrorMessage(AuthUtils.getErrorVal("110", "Error_Message"));
        return AuthUtils.getErrorVal("110", "Error_Template");
    }

    String getModuleErrorTemplate() {
        String moduleErrorTemplate = this.loginState.getModuleErrorTemplate();
        if (debug.messageEnabled()) {
            debug.message("Error Template is : " + moduleErrorTemplate);
        }
        return moduleErrorTemplate;
    }

    public String getErrorTemplate() {
        String errorTemplate = null;
        if (this.loginState == null) {
            errorTemplate = AuthUtils.getErrorVal("102", "Error_Template");
            return errorTemplate;
        }
        if (this.loginState.isTimedOut()) {
            errorTemplate = this.getTimedOutTemplate();
        } else {
            errorTemplate = this.loginState.getModuleErrorTemplate();
            if (errorTemplate == null || errorTemplate.equals("")) {
                errorTemplate = this.loginState.getErrorTemplate();
            }
        }
        if (debug.messageEnabled()) {
            debug.message("Error Template is : " + errorTemplate);
        }
        this.loginState.setErrorTemplate(errorTemplate);
        return errorTemplate;
    }

    public String getErrorMessage() {
        String errorMsg = null;
        if (this.loginState == null) {
            errorMsg = AuthUtils.getErrorVal("102", "Error_Message");
            return errorMsg;
        }
        errorMsg = this.loginState.getModuleErrorMessage();
        if (errorMsg == null) {
            errorMsg = this.loginState.getErrorMessage();
        }
        if (debug.messageEnabled()) {
            debug.message("Error message is : " + errorMsg);
        }
        return errorMsg;
    }

    public String getErrorCode() {
        if (this.loginState == null) {
            return "102";
        }
        String errorCode = this.loginState.getErrorCode();
        if (debug.messageEnabled()) {
            debug.message("Error Code is.. : " + errorCode);
        }
        return errorCode;
    }

    public String getLockoutMsg() {
        if (debug.messageEnabled()) {
            debug.message("lockout Msg returned  : " + this.lockoutMsg);
        }
        return this.lockoutMsg;
    }

    public boolean isLockedOut() {
        return this.accountLocked;
    }

    String getAuthLevel(String orgDN) {
        AMAuthLevelManager levelManager = AMAuthLevelManager.getInstance();
        int maxLevel = Integer.MIN_VALUE;
        if (this.moduleSet == null || this.moduleSet.isEmpty()) {
            this.moduleSet = this.getSuccessModuleSet(orgDN);
        }
        Iterator mIterator = this.moduleSet.iterator();
        while (mIterator.hasNext()) {
            String moduleName = (String)mIterator.next();
            int authLevel = levelManager.getLevelForModule(moduleName, orgDN, this.loginState.defaultAuthLevel);
            if (authLevel > maxLevel) {
                maxLevel = authLevel;
            }
            if (!debug.messageEnabled()) continue;
            debug.message("AuthLevel is : " + authLevel);
            debug.message("New AuthLevel is : " + maxLevel);
        }
        if (debug.messageEnabled()) {
            debug.message("Returning AuthLevel is : " + maxLevel);
        }
        return new Integer(maxLevel).toString();
    }

    Set getSuccessModuleSet(String orgDN) {
        try {
            Set successModuleSet = this.loginState.getSuccessModuleSet();
            this.moduleSet = this.getModuleFromAuthConfiguration(successModuleSet, orgDN);
            if (debug.messageEnabled()) {
                debug.message("ModuleSet is : " + this.moduleSet);
            }
        }
        catch (Exception e) {
            debug.message("Exception : getSuccessModuleList ", (Throwable)e);
        }
        return this.moduleSet;
    }

    String getModuleString(Set moduleSet) {
        String moduleList = "";
        if (moduleSet != null && !moduleSet.isEmpty()) {
            Iterator mIterator = moduleSet.iterator();
            StringBuffer moduleString = new StringBuffer();
            while (mIterator.hasNext()) {
                String mClassName = (String)mIterator.next();
                moduleString.append(mClassName).append(LIST_DELIMITER);
            }
            String mString = moduleString.toString();
            int i = mString.lastIndexOf(LIST_DELIMITER);
            moduleList = i != -1 ? mString.substring(0, i) : mString;
        }
        if (debug.messageEnabled()) {
            debug.message("ModuleList is : " + moduleList);
        }
        return moduleList;
    }

    boolean processIndexType(AuthContext.IndexType indexType, String indexName, String orgDN) throws AuthLoginException {
        boolean ignoreProfile = false;
        AuthContext.IndexType previousType = this.loginState.getPreviousIndexType();
        String normOrgDN = DNUtils.normalizeDN(orgDN);
        if (previousType != AuthContext.IndexType.LEVEL && previousType != AuthContext.IndexType.COMPOSITE_ADVICE || indexType != AuthContext.IndexType.MODULE_INSTANCE) {
            HttpServletRequest hreq = this.loginState.getHttpServletRequest();
            boolean isTokenValid = false;
            if (hreq != null) {
                try {
                    SSOTokenManager manager = SSOTokenManager.getInstance();
                    SSOToken ssoToken = manager.createSSOToken(hreq);
                    if (manager.isValidToken(ssoToken)) {
                        debug.message("Existing Valid session");
                        isTokenValid = true;
                    }
                }
                catch (Exception e) {
                    debug.message("ERROR processIndexType/SSOToken validation - " + e.toString());
                }
                if (!isTokenValid) {
                    debug.message("No existing valid session");
                    Hashtable requestHash = this.loginState.getRequestParamHash();
                    String orgParam = AuthUtils.getOrgParam(requestHash);
                    String queryOrg = AuthUtils.getQueryOrgName(hreq, orgParam);
                    String newOrgDN = DNUtils.normalizeDN(AuthUtils.getOrganizationDN(queryOrg, true, hreq));
                    if (debug.messageEnabled()) {
                        debug.message("orgDN from existing auth context: " + orgDN + ", orgDN from query string: " + newOrgDN);
                    }
                    if (normOrgDN != null && !normOrgDN.equals(newOrgDN)) {
                        this.st.setStatus(7);
                        this.loginState.setErrorCode("102");
                        this.setErrorMsgAndTemplate();
                        this.internalAuthError = true;
                        throw new AuthLoginException(bundleName, "102", null);
                    }
                }
            }
        }
        if (indexType == AuthContext.IndexType.COMPOSITE_ADVICE) {
            debug.message("IndexType is COMPOSITE_ADVICE");
            String compositeAdvice = URLEncDec.decode((String)indexName);
            this.loginState.setCompositeAdvice(compositeAdvice);
            try {
                if (this.processCompositeAdvice(indexType, indexName, orgDN, this.clientType)) {
                    debug.message("multiple modules found");
                    return true;
                }
                return false;
            }
            catch (AuthException ae) {
                this.loginState.setErrorCode(ae.getErrorCode());
                this.loginState.logFailed(ae.getMessage());
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException((Throwable)((Object)ae));
            }
        }
        if (indexType == AuthContext.IndexType.LEVEL) {
            debug.message("IndexType is level");
            try {
                if (this.processLevel(indexType, indexName, orgDN, this.clientType)) {
                    debug.message("multiple modules found");
                    return true;
                }
                return false;
            }
            catch (AuthException ae) {
                this.loginState.setErrorCode(ae.getErrorCode());
                this.loginState.logFailed(ae.getMessage());
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException((Throwable)((Object)ae));
            }
        }
        if (indexType == AuthContext.IndexType.USER) {
            debug.message("IndexType is user");
            boolean userValid = false;
            if (!this.loginState.ignoreProfile()) {
                userValid = this.validateUser(indexName);
            } else {
                ignoreProfile = true;
            }
            if (this.pCookieMode) {
                this.processPCookieMode(userValid);
                return true;
            }
            if (!userValid && !ignoreProfile) {
                debug.message("User is not active");
                this.loginState.logFailed(this.bundle.getString("userInactive"), "USERINACTIVE");
                this.loginState.setErrorCode("104");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "104", null);
            }
            if (ignoreProfile) {
                this.setAuthError("100", "loginDenied");
                throw new AuthLoginException(bundleName, "100", null);
            }
            return false;
        }
        if (indexType == AuthContext.IndexType.MODULE_INSTANCE) {
            debug.message("indexType is module");
            boolean instanceExists = this.loginState.getDomainAuthenticators().contains(indexName);
            if (!indexName.equals("Application") && !instanceExists) {
                debug.message("Module denied!!");
                this.loginState.setErrorCode("111");
                this.loginState.logFailed(this.bundle.getString("moduleDenied"), "MODULEDENIED");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "111", null);
            }
            return false;
        }
        if (indexType == AuthContext.IndexType.ROLE) {
            debug.message("indexType is Role");
            if (this.loginState.ignoreProfile()) {
                this.setAuthError("114", "loginDenied");
                throw new AuthLoginException(bundleName, "114", null);
            }
        }
        return false;
    }

    void processPCookieMode(boolean userValid) throws AuthLoginException {
        if (!this.loginState.ignoreProfile()) {
            if (!userValid) {
                if (debug.messageEnabled()) {
                    debug.message("user is not valid");
                }
                this.loginState.setErrorCode("104");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "104", null);
            }
            AMAccountLockout amAccountLockout = new AMAccountLockout(this.loginState);
            boolean accountLocked = amAccountLockout.isLockedOut();
            if (accountLocked) {
                this.loginState.logFailed(this.bundle.getString("lockOut"), "LOCKEDOUT");
                this.loginState.setErrorCode("112");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "112", null);
            }
            boolean accountExpired = amAccountLockout.isAccountExpired();
            if (accountExpired) {
                this.loginState.logFailed(this.bundle.getString("accountExpired"), "ACCOUNTEXPIRED");
                this.loginState.setErrorCode("101");
                this.setErrorMsgAndTemplate();
                this.st.setStatus(4);
                throw new AuthLoginException(bundleName, "101", null);
            }
        }
        if (this.loginState.ignoreProfile()) {
            try {
                this.loginState.populateDefaultUserAttributes();
            }
            catch (Exception e) {
                debug.message("Error get default attributes ", (Throwable)e);
                this.setAuthError("102", "loginFailed");
                throw new AuthLoginException(bundleName, "102", null);
            }
        }
        if (this.loginState.isSessionUpgrade()) {
            this.loginState.setPCookieUserName(this.indexName);
            return;
        }
        this.updateLoginState(this.loginState, this.indexType, this.indexName, this.configName, this.orgDN);
        Subject subject = new Subject();
        UserPrincipal userPrincipal = new UserPrincipal(this.indexName);
        subject.getPrincipals().add(userPrincipal);
        if (debug.messageEnabled()) {
            debug.message("Subject is.. :" + subject);
        }
        try {
            this.loginState.activateSession(subject, this.authContext);
            this.loginState.updateSessionForFailover();
            this.loginState.logSuccess();
        }
        catch (Exception e) {
            debug.message("Error activating session ");
            this.setAuthError("102", "loginFailed");
            throw new AuthLoginException(bundleName, "102", null);
        }
        this.st.setStatus(3);
        debug.message("login success");
    }

    void setLoginHash() {
        try {
            this.sid = AuthUtils.getSidString(this.authContext);
            this.loginState = AuthUtils.getLoginState(this.authContext);
            if (debug.messageEnabled()) {
                debug.message("sid .. " + this.sid);
                debug.message("login state is .. : " + this.loginState);
            }
        }
        catch (Exception e) {
            debug.message("executLogin exception : ", (Throwable)e);
        }
    }

    void setAuthError(String errorCode, String resString) {
        this.loginState.setErrorCode(errorCode);
        this.setErrorMsgAndTemplate();
        this.loginState.logFailed(this.bundle.getString(resString));
        this.st.setStatus(4);
    }

    public void postProcessOnFail() {
        if (!this.internalAuthError && !this.processDone) {
            if (debug.messageEnabled()) {
                debug.message("postProcessOnFail ");
            }
            this.loginState.postProcess(this.indexType, this.indexName, 2);
            this.loginState.setFailureLoginURL(this.indexType, this.indexName);
            this.processDone = true;
        }
    }

    public void postProcessOnSuccess() {
        if (!this.processDone) {
            if (debug.messageEnabled()) {
                debug.message("postProcessOnSuccess ");
            }
            this.loginState.postProcess(this.indexType, this.indexName, 1);
            this.processDone = true;
        }
    }

    private Set getModuleFromAuthConfiguration(Set moduleListSet, String orgDN) {
        Configuration config = Configuration.getConfiguration();
        if (this.configName == null) {
            this.configName = this.getConfigName(this.indexType, this.indexName, orgDN, this.loginState.getClientType());
        }
        AppConfigurationEntry[] moduleList = config.getAppConfigurationEntry(this.configName);
        if (debug.messageEnabled()) {
            debug.message("configName is : " + this.configName);
        }
        String moduleName = null;
        if (moduleList != null && moduleList.length != 0) {
            if (moduleList.length == 1) {
                moduleName = (String)moduleList[0].getOptions().get("moduleInstanceName");
                moduleListSet.add(moduleName);
            } else {
                for (int i = 0; i < moduleList.length; ++i) {
                    AppConfigurationEntry.LoginModuleControlFlag controlFlag = moduleList[i].getControlFlag();
                    moduleName = (String)moduleList[i].getOptions().get("moduleInstanceName");
                    if (!this.isControlFlagMatchFound(controlFlag)) continue;
                    moduleListSet.add(moduleName);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ModuleSet is : " + moduleListSet);
        }
        return moduleListSet;
    }

    String getFailureModuleList(String orgDN) {
        String moduleList = "";
        try {
            Set failureModuleSet = this.loginState.getFailureModuleSet();
            Set moduleSet = this.getModuleFromAuthConfiguration(failureModuleSet, orgDN);
            if (debug.messageEnabled()) {
                debug.message("ModuleSet is : " + moduleSet);
            }
            moduleList = this.getModuleString(moduleSet);
        }
        catch (Exception e) {
            debug.message("Exception : getFailureModuleList ", (Throwable)e);
        }
        if (debug.messageEnabled()) {
            debug.message("moduleList is :" + moduleList);
        }
        return moduleList;
    }

    boolean isControlFlagMatchFound(AppConfigurationEntry.LoginModuleControlFlag controlFlag) {
        boolean isFlagMatchFound = false;
        if (controlFlag != null) {
            isFlagMatchFound = controlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED || controlFlag == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        return isFlagMatchFound;
    }

    String getSuccessModuleString(String orgDN) {
        if (this.moduleSet == null || this.moduleSet.isEmpty()) {
            this.moduleSet = this.getSuccessModuleSet(orgDN);
        }
        return this.getModuleString(this.moduleSet);
    }

    public boolean isPureJAAS() {
        return this.jaasCheck == 1;
    }

    private void nullifyUsedVars() {
        this.configName = null;
        this.subject = null;
        this.clientType = null;
        this.moduleSet = null;
        this.entries = null;
        this.recdCallback = null;
        this.loginState.nullifyUsedVars();
    }

    static {
        block5: {
            Configuration defaultConfig;
            block4: {
                authThread = null;
                ad = AuthD.getAuth();
                debug = AuthD.debug;
                defaultConfig = null;
                try {
                    defaultConfig = Configuration.getConfiguration();
                }
                catch (Exception e) {
                    debug.message("Get Auth Config Error.");
                    if (!debug.messageEnabled()) break block4;
                    debug.message("Stack trace:", (Throwable)e);
                }
            }
            AMConfiguration ISConfig = new AMConfiguration(defaultConfig);
            try {
                Configuration.setConfiguration(ISConfig);
            }
            catch (Exception e) {
                debug.error("Set config error:" + e.getMessage());
                if (!debug.messageEnabled()) break block5;
                debug.message("Stack trace:", (Throwable)e);
            }
        }
        debug.message("Reset the auth Configuration !");
    }
}

