/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.radius;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.radius.RADIUSPrincipal;
import com.sun.identity.authentication.modules.radius.client.ChallengeException;
import com.sun.identity.authentication.modules.radius.client.RadiusConn;
import com.sun.identity.authentication.modules.radius.client.RejectException;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import java.io.IOException;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class RADIUS
extends AMLoginModule {
    private Map sharedState;
    private static String adminDN;
    private static String hostName;
    private String userTokenId = null;
    private String challengeID;
    private static HashSet orgHash;
    private boolean primary = true;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private RADIUSPrincipal userPrincipal = null;
    private static final int MSG_INFORMATION = 0;
    private static final int MSG_WARNING = 1;
    private static final int MSG_ERROR = 2;
    private static boolean helperConfigDone;
    private static Locale locale;
    private ResourceBundle bundle = null;
    private static Debug debug;
    private static final String DEFAULT_TIMEOUT = "5";
    private static final String DEFAULT_SERVER_PORT = "1645";
    private String server1;
    private String server2;
    private String sharedSecret;
    private int iServerPort = 1645;
    private int iTimeOut = 5;
    private RadiusConn _radiusConn = null;
    private int screenState;
    private boolean radiusSSL = false;
    private static final String amAuthRadius = "amAuthRadius";
    private boolean getCredentialsFromSharedState;

    public void init(Subject subject, Map sharedState, Map options) {
        block13: {
            try {
                this.bundle = amCache.getResBundle(amAuthRadius, this.getLoginLocale());
                if (debug.messageEnabled()) {
                    debug.message("Radius resbundle locale=" + this.getLoginLocale());
                }
                this.sharedState = sharedState;
                if (options != null) {
                    try {
                        this.server1 = Misc.getServerMapAttr(options, "iplanet-am-auth-radius-server1");
                        if (this.server1 == null) {
                            this.server1 = "localhost";
                            debug.error("Error: primary server attribute misconfigured using localhost");
                        }
                        this.server2 = Misc.getServerMapAttr(options, "iplanet-am-auth-radius-server2");
                        if (this.server1 == null) {
                            this.server1 = "localhost";
                            debug.error("Error: primary server attribute misconfigured using localhost");
                        }
                        this.sharedSecret = Misc.getMapAttr(options, "iplanet-am-auth-radius-secret");
                        String serverPort = Misc.getMapAttr(options, "iplanet-am-auth-radius-server-port", DEFAULT_SERVER_PORT);
                        this.iServerPort = Integer.parseInt(serverPort);
                        String timeOut = Misc.getMapAttr(options, "iplanet-am-auth-radius-timeout", DEFAULT_TIMEOUT);
                        this.iTimeOut = Integer.parseInt(timeOut);
                        String authLevel = Misc.getMapAttr(options, "iplanet-am-auth-radius-auth-level");
                        if (authLevel != null) {
                            try {
                                this.setAuthLevel(Integer.parseInt(authLevel));
                            }
                            catch (Exception e) {
                                debug.error("Unable to set auth level " + authLevel);
                            }
                        }
                        if (debug.messageEnabled()) {
                            debug.message("server1: " + this.server1 + " server2: " + this.server2 + " serverPort: " + serverPort + " timeOut: " + timeOut + " authLevel: " + authLevel);
                        }
                        if (this.sharedSecret == null || this.sharedSecret.length() == 0) {
                            debug.error("RADIUS initialization failure; no Shared Secret");
                        }
                        break block13;
                    }
                    catch (Exception ex) {
                        debug.error("RADIUS parameters initialization failure", ex);
                    }
                    break block13;
                }
                debug.error("options not initialized");
            }
            catch (Exception e) {
                debug.error("RADIUS init Error....", e);
            }
        }
    }

    private void setDynamicText(int state) throws AuthLoginException {
        Callback[] callbacks = this.getCallback(state);
        String prompt = ((PasswordCallback)callbacks[0]).getPrompt();
        boolean echo = ((PasswordCallback)callbacks[0]).isEchoOn();
        if (this.challengeID != null) {
            prompt = prompt + "[" + this.challengeID + "]: ";
        }
        callbacks[0] = new PasswordCallback(prompt, echo);
        this.replaceCallback(state, 0, callbacks[0]);
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        String tmp_passwd = null;
        ChallengeException cException = null;
        String username = null;
        switch (state) {
            case 1: {
                try {
                    this._radiusConn = new RadiusConn(this.server1, this.server2, this.iServerPort, this.sharedSecret, this.iTimeOut);
                }
                catch (SocketException se) {
                    debug.error("RADIUS login failure; Socket Exception se == ", se);
                    this.shutdown();
                    throw new AuthLoginException(amAuthRadius, "RadiusNoServer", null);
                }
                catch (Exception e) {
                    debug.error("RADIUS login failure; Can't connect to RADIUS server", e);
                    this.shutdown();
                    throw new AuthLoginException(amAuthRadius, "RadiusNoServer", null);
                }
                if (callbacks != null && callbacks.length == 0) {
                    username = (String)this.sharedState.get(this.getUserKey());
                    tmp_passwd = (String)this.sharedState.get(this.getPwdKey());
                    if (username == null || tmp_passwd == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    username = ((NameCallback)callbacks[0]).getName();
                    tmp_passwd = this.charToString(((PasswordCallback)callbacks[1]).getPassword(), callbacks[1]);
                    if (debug.messageEnabled()) {
                        debug.message("username: " + username);
                    }
                }
                this.storeUsernamePasswd(username, tmp_passwd);
                try {
                    this.succeeded = false;
                    this._radiusConn.authenticate(username, tmp_passwd);
                }
                catch (RejectException re) {
                    if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    debug.message("Radius login request rejected", re);
                    this.shutdown();
                    this.setFailureID(username);
                    throw new InvalidPasswordException(amAuthRadius, "RadiusLoginFailed", null, username, re);
                }
                catch (IOException ioe) {
                    if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    debug.error("Radius request IOException", ioe);
                    this.shutdown();
                    this.setFailureID(username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (NoSuchAlgorithmException ne) {
                    if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    debug.error("Radius No Such Algorithm Exception", ne);
                    this.shutdown();
                    this.setFailureID(username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (ChallengeException ce) {
                    if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    cException = ce;
                    String sState = ce.getState();
                    if (sState == null) {
                        debug.error("Radius failure - no state returned in challenge");
                        this.shutdown();
                        this.setFailureID(username);
                        throw new AuthLoginException(amAuthRadius, "RadiusAuth", null);
                    }
                    this.challengeID = ce.getReplyMessage();
                    if (debug.messageEnabled()) {
                        debug.message("Server challenge with challengeID: " + this.challengeID);
                    }
                    this.setDynamicText(2);
                    return 2;
                }
                catch (Exception e) {
                    if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    this.shutdown();
                    this.setFailureID(username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null, e);
                }
                this.succeeded = true;
                break;
            }
            case 2: {
                String passwd = this.getChallengePassword(callbacks);
                if (debug.messageEnabled()) {
                    debug.message("reply to challenge--username: " + username);
                }
                try {
                    this.succeeded = false;
                    this._radiusConn.replyChallenge(username, passwd, cException);
                }
                catch (ChallengeException ce) {
                    String sState = ce.getState();
                    if (sState == null) {
                        debug.error("handle Challenge failure - no state returned");
                        this.shutdown();
                        this.setFailureID(username);
                        throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                    }
                    this.resetCallback(2, 1);
                    this.challengeID = ce.getReplyMessage();
                    if (debug.messageEnabled()) {
                        debug.message("Server challenge again with challengeID: " + this.challengeID);
                    }
                    this.setDynamicText(2);
                    return 2;
                }
                catch (RejectException ex) {
                    debug.error("Radius challenge response rejected", ex);
                    this.shutdown();
                    this.setFailureID(username);
                    throw new InvalidPasswordException(amAuthRadius, "RadiusLoginFailed", null, username, ex);
                }
                catch (IOException ioe) {
                    debug.error("Radius challenge IOException", ioe);
                    this.shutdown();
                    this.setFailureID(username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (NoSuchAlgorithmException ex) {
                    debug.error("Radius No Such Algorithm Exception", ex);
                    this.shutdown();
                    this.setFailureID(username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (Exception e) {
                    debug.error("RADIUS challenge Authentication Failed ", e);
                    this.shutdown();
                    this.setFailureID(username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                this.succeeded = true;
                break;
            }
            default: {
                debug.error("RADIUS Authentication Failed - invalid state" + state);
                this.shutdown();
                this.succeeded = false;
                this.setFailureID(username);
                throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
            }
        }
        if (this.succeeded) {
            if (debug.messageEnabled()) {
                debug.message("RADIUS authentication successful");
            }
            if (username != null) {
                StringTokenizer usernameToken = new StringTokenizer(username, ",");
                this.userTokenId = usernameToken.nextToken();
            }
            if (debug.messageEnabled()) {
                debug.message("userTokenID: " + this.userTokenId);
            }
            this.shutdown();
            return -1;
        }
        if (debug.messageEnabled()) {
            debug.message("RADIUS authentication to be ignored");
        }
        return 0;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new RADIUSPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.sharedState = null;
        this.challengeID = null;
        this.bundle = null;
        this.server1 = null;
        this.server2 = null;
        this.sharedSecret = null;
    }

    private String getChallengePassword(Callback[] callbacks) throws AuthLoginException {
        char[] tmpPassword = ((PasswordCallback)callbacks[0]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)callbacks[0]).clearPassword();
        return new String(pwd);
    }

    private String charToString(char[] tmpPassword, Callback cbk) {
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)cbk).clearPassword();
        return new String(pwd);
    }

    public void shutdown() {
        try {
            this._radiusConn.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._radiusConn = null;
    }

    static {
        orgHash = new HashSet();
        helperConfigDone = false;
        locale = null;
        debug = null;
        if (debug == null) {
            debug = Debug.getInstance(amAuthRadius);
        }
    }
}

